/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.ItemType;

public class NameTest
extends NodeTest {
    private int nodeKind;
    private int fingerprint;
    private NamePool namePool;
    private String uri = null;
    private String localName = null;

    public NameTest(int n, int n2, NamePool namePool) {
        this.nodeKind = n;
        this.fingerprint = n2 & 0xFFFFF;
        this.namePool = namePool;
    }

    public NameTest(NodeInfo nodeInfo) {
        this.nodeKind = nodeInfo.getNodeKind();
        this.fingerprint = nodeInfo.getFingerprint();
        this.namePool = nodeInfo.getNamePool();
    }

    public boolean matches(int n, int n2, int n3) {
        return (n2 & 0xFFFFF) == this.fingerprint && n == this.nodeKind;
    }

    public boolean matches(NodeInfo nodeInfo) {
        if (nodeInfo.getNodeKind() != this.nodeKind) {
            return false;
        }
        if (nodeInfo instanceof FingerprintedNode) {
            return nodeInfo.getFingerprint() == this.fingerprint;
        }
        if (this.uri == null) {
            this.uri = this.namePool.getURI(this.fingerprint);
        }
        if (this.localName == null) {
            this.localName = this.namePool.getLocalName(this.fingerprint);
        }
        return this.localName.equals(nodeInfo.getLocalPart()) && this.uri.equals(nodeInfo.getURI());
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public int getPrimitiveType() {
        return this.nodeKind;
    }

    public ItemType getSuperType() {
        return NodeKindTest.makeNodeKindTest(this.nodeKind);
    }

    public int getNodeKindMask() {
        return 1 << this.nodeKind;
    }

    public Set getRequiredNodeNames() {
        HashSet<Integer> hashSet = new HashSet<Integer>(1);
        hashSet.add(new Integer(this.fingerprint));
        return hashSet;
    }

    public String toString() {
        return this.toString(this.namePool);
    }

    public String toString(NamePool namePool) {
        switch (this.nodeKind) {
            case 1: {
                return "element(" + namePool.getDisplayName(this.fingerprint) + ')';
            }
            case 2: {
                return "attribute(" + namePool.getDisplayName(this.fingerprint) + ')';
            }
            case 7: {
                return "processing-instruction(" + namePool.getDisplayName(this.fingerprint) + ')';
            }
            case 13: {
                return "namespace(" + namePool.getDisplayName(this.fingerprint) + ')';
            }
        }
        return namePool.getDisplayName(this.fingerprint);
    }

    public int hashCode() {
        return this.nodeKind << 20 ^ this.fingerprint;
    }
}

