/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.EagerLetExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IfExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.Attribute;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Comment;
import net.sf.saxon.instruct.ComputedElement;
import net.sf.saxon.instruct.CopyOf;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.FixedAttribute;
import net.sf.saxon.instruct.FixedElement;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.ProcessingInstruction;
import net.sf.saxon.instruct.QuerySimpleContentConstructor;
import net.sf.saxon.instruct.ResultDocument;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TraceExpression;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceConstant;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.TupleExpression;
import net.sf.saxon.sort.TupleSorter;
import net.sf.saxon.trans.IndependentContext;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class QueryParser
extends ExpressionParser {
    private boolean preserveSpace = false;
    private boolean defaultEmptyLeast = true;
    private int errorCount = 0;
    protected Executable executable;
    private boolean foundCopyNamespaces = false;
    private boolean foundBoundarySpaceDeclaration = false;
    private boolean foundOrderingDeclaration = false;
    private boolean foundEmptyOrderingDeclaration = false;
    private boolean foundDefaultCollation = false;
    private boolean foundConstructionDeclaration = false;
    private boolean foundDefaultFunctionNamespace = false;
    private boolean foundDefaultElementNamespace = false;
    private boolean foundBaseURIDeclaration = false;
    public Set importedModules = new HashSet(5);
    private Expression defaultValue = null;

    public XQueryExpression makeXQueryExpression(String string, StaticQueryContext staticQueryContext, Configuration configuration) throws XPathException {
        DocumentInstr documentInstr;
        Executable executable = new Executable();
        executable.setLocationMap(new LocationMap());
        executable.setConfiguration(configuration);
        executable.setFunctionLibrary(new ExecutableFunctionLibrary(configuration));
        executable.setHostLanguage(11);
        this.setExecutable(executable);
        staticQueryContext.setExecutable(executable);
        Expression expression = this.parseQuery(string, 0, 0, staticQueryContext);
        XQueryExpression xQueryExpression = new XQueryExpression(expression, executable, staticQueryContext, configuration);
        expression = xQueryExpression.getExpression();
        if (expression instanceof DocumentInstr) {
            documentInstr = (DocumentInstr)expression;
        } else {
            documentInstr = new DocumentInstr(false, null, staticQueryContext.getSystemId());
            documentInstr.setContentExpression(expression);
            this.setLocation(documentInstr, 1);
        }
        xQueryExpression.setDocumentInstruction(documentInstr);
        FunctionLibrary functionLibrary = executable.getFunctionLibrary();
        FunctionLibraryList functionLibraryList = new FunctionLibraryList();
        functionLibraryList.addFunctionLibrary(new SystemFunctionLibrary(0));
        functionLibraryList.addFunctionLibrary(configuration.getVendorFunctionLibrary());
        functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(configuration));
        if (configuration.isAllowExternalFunctions()) {
            functionLibraryList.addFunctionLibrary(configuration.getExtensionBinder());
        }
        functionLibraryList.addFunctionLibrary(functionLibrary);
        executable.setFunctionLibrary(functionLibraryList);
        return xQueryExpression;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public final Expression parseQuery(String string, int n, int n2, StaticQueryContext staticQueryContext) throws XPathException {
        this.env = staticQueryContext;
        this.language = 3;
        this.t = new Tokenizer();
        try {
            this.t.tokenize(string, n, -1, 1);
        }
        catch (StaticError staticError) {
            this.grumble(staticError.getMessage());
        }
        this.parseVersionDeclaration();
        this.parseProlog();
        Expression expression = this.parseExpression();
        if (this.t.currentToken != n2) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of query");
        }
        if (this.errorCount == 0) {
            try {
                this.setLocation(expression);
                staticQueryContext.bindUnboundFunctionCalls();
                staticQueryContext.fixupGlobalVariables(staticQueryContext.getGlobalStackFrameMap());
                staticQueryContext.fixupGlobalFunctions();
            }
            catch (XPathException xPathException) {
                try {
                    ++this.errorCount;
                    staticQueryContext.getConfiguration().getErrorListener().fatalError(xPathException);
                }
                catch (TransformerException transformerException) {
                    if (transformerException instanceof XPathException) {
                        throw (XPathException)transformerException;
                    }
                    throw new StaticError(transformerException);
                }
            }
        }
        if (this.errorCount == 0) {
            return expression;
        }
        StaticError staticError = new StaticError("One or more static errors were reported during query analysis");
        staticError.setHasBeenReported();
        throw staticError;
    }

    public final void parseLibraryModule(String string, StaticQueryContext staticQueryContext) throws StaticError {
        this.env = staticQueryContext;
        this.executable = staticQueryContext.getExecutable();
        this.t = new Tokenizer();
        try {
            this.t.tokenize(string, 0, -1, 1);
        }
        catch (StaticError staticError) {
            this.grumble(staticError.getMessage());
        }
        this.parseVersionDeclaration();
        this.parseModuleDeclaration();
        this.parseProlog();
        if (this.t.currentToken != 0) {
            this.grumble("Unrecognized content found after the variable and function declarations in a library module");
        }
        if (this.errorCount == 0) {
            staticQueryContext.bindUnboundFunctionCalls();
            staticQueryContext.fixupGlobalVariables(staticQueryContext.getExecutable().getGlobalVariableMap());
            try {
                staticQueryContext.fixupGlobalFunctions();
            }
            catch (XPathException xPathException) {
                throw xPathException.makeStatic();
            }
        }
        if (this.errorCount != 0) {
            throw new StaticError("Static errors were reported in the imported library module");
        }
    }

    protected void grumble(String string, String string2) throws StaticError {
        String string3 = this.t.recentText();
        ExpressionLocation expressionLocation = this.makeLocator();
        String string4 = this.getLanguage() + ("XPST0003".equals(string2) ? " syntax error " : " static error ") + (string.startsWith("...") ? "near" : "in") + " #" + string3 + "#:\n    ";
        StaticError staticError = new StaticError(string4 + string);
        staticError.setErrorCode(string2);
        staticError.setLocator(expressionLocation);
        this.reportError(staticError);
    }

    private void reportError(StaticError staticError) throws StaticError {
        ++this.errorCount;
        try {
            this.env.getConfiguration().getErrorListener().fatalError(staticError);
        }
        catch (TransformerException transformerException) {
            if (transformerException instanceof StaticError) {
                throw (StaticError)transformerException;
            }
            throw new StaticError(transformerException);
        }
        throw staticError;
    }

    private ExpressionLocation makeLocator() {
        int n = this.t.getLineNumber();
        int n2 = this.t.getColumnNumber();
        ExpressionLocation expressionLocation = new ExpressionLocation();
        expressionLocation.setSystemId(this.env.getSystemId());
        expressionLocation.setLineNumber(n);
        expressionLocation.setColumnNumber(n2);
        return expressionLocation;
    }

    private void parseVersionDeclaration() throws StaticError {
        if (this.t.currentToken == 70) {
            this.nextToken();
            this.expect(102);
            if (!"1.0".equals(this.t.currentTokenValue)) {
                this.grumble("XQuery version must be 1.0", "XQST0031");
            }
            this.nextToken();
            if ("encoding".equals(this.t.currentTokenValue)) {
                this.nextToken();
                this.expect(102);
                String string = this.t.currentTokenValue;
                this.nextToken();
            }
            this.expect(90);
            this.nextToken();
        }
    }

    private void parseModuleDeclaration() throws StaticError {
        this.expect(80);
        this.nextToken();
        this.expect(101);
        String string = this.t.currentTokenValue;
        this.checkProhibitedPrefixes(string);
        this.nextToken();
        this.expect(6);
        this.nextToken();
        this.expect(102);
        String string2 = this.t.currentTokenValue;
        this.nextToken();
        this.expect(90);
        this.nextToken();
        try {
            ((StaticQueryContext)this.env).declarePassiveNamespace(string, string2, true);
        }
        catch (StaticError staticError) {
            staticError.setLocator(this.makeLocator());
            this.reportError(staticError);
        }
        ((StaticQueryContext)this.env).setModuleNamespace(string2);
    }

    private void parseProlog() throws StaticError {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        block4: while (true) {
            try {
                while (true) {
                    if (this.t.currentToken == 80) {
                        String string = ((StaticQueryContext)this.env).getModuleNamespace();
                        if (string == null) {
                            this.grumble("Module declaration must not be used in a main module");
                        } else {
                            this.grumble("Module declaration appears more than once");
                        }
                        if (!bl2) {
                            this.grumble("Module declaration must precede other declarations in the query prolog");
                        }
                    }
                    bl2 = false;
                    if (this.t.currentToken == 71) {
                        if (!bl3) {
                            this.grumble("Namespace declarations cannot follow variables, functions, or options");
                        }
                        bl = false;
                        this.parseNamespaceDeclaration();
                    } else if (this.t.currentToken == 72) {
                        this.nextToken();
                        this.expect(101);
                        if (this.t.currentTokenValue == "element") {
                            if (!bl3) {
                                this.grumble("Namespace declarations cannot follow variables, functions, or options");
                            }
                            bl = false;
                            this.parseDefaultElementNamespace();
                        } else if (this.t.currentTokenValue == "function") {
                            if (!bl3) {
                                this.grumble("Namespace declarations cannot follow variables, functions, or options");
                            }
                            bl = false;
                            this.parseDefaultFunctionNamespace();
                        } else if (this.t.currentTokenValue == "collation") {
                            if (!bl3) {
                                this.grumble("Collation declarations must appear earlier in the prolog");
                            }
                            this.parseDefaultCollation();
                        } else if (this.t.currentTokenValue == "order") {
                            if (!bl3) {
                                this.grumble("Order declarations must appear earlier in the prolog");
                            }
                            this.parseDefaultOrder();
                        } else {
                            this.grumble("After 'declare default', expected 'element', 'function', or 'collation'");
                        }
                    } else if (this.t.currentToken == 75) {
                        if (!bl) {
                            this.grumble("'declare boundary-space' must appear earlier in the query prolog");
                        }
                        this.parseBoundarySpaceDeclaration();
                    } else if (this.t.currentToken == 84) {
                        if (!bl) {
                            this.grumble("'declare ordering' must appear earlier in the query prolog");
                        }
                        this.parseOrderingDeclaration();
                    } else if (this.t.currentToken == 85) {
                        if (!bl) {
                            this.grumble("'declare copy-namespaces' must appear earlier in the query prolog");
                        }
                        this.parseCopyNamespacesDeclaration();
                    } else if (this.t.currentToken == 74) {
                        if (!bl) {
                            this.grumble("'declare base-uri' must appear earlier in the query prolog");
                        }
                        this.parseBaseURIDeclaration();
                    } else if (this.t.currentToken == 76) {
                        bl = false;
                        if (!bl3) {
                            this.grumble("Import schema must appear earlier in the prolog");
                        }
                        this.parseSchemaImport();
                    } else if (this.t.currentToken == 77) {
                        bl = false;
                        if (!bl3) {
                            this.grumble("Import module must appear earlier in the prolog");
                        }
                        this.parseModuleImport();
                    } else if (this.t.currentToken == 78) {
                        bl = false;
                        bl3 = false;
                        this.parseVariableDeclaration();
                    } else if (this.t.currentToken == 79) {
                        bl = false;
                        bl3 = false;
                        this.parseFunctionDeclaration();
                    } else if (this.t.currentToken == 86) {
                        bl = false;
                        bl3 = false;
                        this.parseOptionDeclaration();
                    } else {
                        if (this.t.currentToken != 73) break block4;
                        if (!bl) {
                            this.grumble("'declare construction' must appear earlier in the query prolog");
                        }
                        this.parseConstructionDeclaration();
                    }
                    this.expect(90);
                    this.nextToken();
                }
            }
            catch (StaticError staticError) {
                if (!staticError.hasBeenReported()) {
                    try {
                        this.env.getConfiguration().getErrorListener().fatalError(staticError);
                    }
                    catch (TransformerException transformerException) {
                        if (transformerException instanceof StaticError) {
                            throw (StaticError)transformerException;
                        }
                        throw new StaticError(staticError);
                    }
                }
                while (this.t.currentToken != 90) {
                    this.nextToken();
                    if (this.t.currentToken == 0) {
                        return;
                    }
                    if (this.t.currentToken == 115) {
                        this.t.lookAhead();
                        continue;
                    }
                    if (this.t.currentToken != 117) continue;
                    this.parsePseudoXML(true);
                }
                this.nextToken();
                continue;
            }
            break;
        }
    }

    private void parseDefaultCollation() throws StaticError {
        if (this.foundDefaultCollation) {
            this.grumble("default collation appears more than once", "XQST0038");
        }
        this.foundDefaultCollation = true;
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        try {
            ((StaticQueryContext)this.env).declareDefaultCollation(string);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
        this.nextToken();
    }

    private void parseDefaultOrder() throws StaticError {
        if (this.foundEmptyOrderingDeclaration) {
            this.grumble("empty ordering declaration appears more than once", "XQST0069");
        }
        this.foundEmptyOrderingDeclaration = true;
        this.nextToken();
        if (!this.isKeyword("empty")) {
            this.grumble("After 'declare default order', expected keyword 'empty'");
        }
        this.nextToken();
        if (this.isKeyword("least")) {
            this.defaultEmptyLeast = true;
        } else if (this.isKeyword("greatest")) {
            this.defaultEmptyLeast = false;
        } else {
            this.grumble("After 'declare default order empty', expected keyword 'least' or 'greatest'");
        }
        this.nextToken();
    }

    private void parseBoundarySpaceDeclaration() throws StaticError {
        if (this.foundBoundarySpaceDeclaration) {
            this.grumble("'declare boundary-space' appears more than once", "XQST0068");
        }
        this.foundBoundarySpaceDeclaration = true;
        this.nextToken();
        this.expect(101);
        if ("preserve".equals(this.t.currentTokenValue)) {
            this.preserveSpace = true;
        } else if ("strip".equals(this.t.currentTokenValue)) {
            this.preserveSpace = false;
        } else {
            this.grumble("boundary-space must be 'preserve' or 'strip'");
        }
        this.nextToken();
    }

    private void parseOrderingDeclaration() throws StaticError {
        if (this.foundOrderingDeclaration) {
            this.grumble("ordering mode declaration appears more than once", "XQST0065");
        }
        this.foundOrderingDeclaration = true;
        this.nextToken();
        this.expect(101);
        if (!"ordered".equals(this.t.currentTokenValue) && !"unordered".equals(this.t.currentTokenValue)) {
            this.grumble("ordering mode must be 'ordered' or 'unordered'");
        }
        this.nextToken();
    }

    private void parseCopyNamespacesDeclaration() throws StaticError {
        if (this.foundCopyNamespaces) {
            this.grumble("declare inherit-namespaces appears more than once", "XQST0055");
        }
        this.foundCopyNamespaces = true;
        this.nextToken();
        this.expect(101);
        if ("preserve".equals(this.t.currentTokenValue)) {
            ((StaticQueryContext)this.env).setPreserveNamespaces(true);
        } else if ("no-preserve".equals(this.t.currentTokenValue)) {
            ((StaticQueryContext)this.env).setPreserveNamespaces(false);
            this.warning("The no-preserve option is not yet implemented");
        } else {
            this.grumble("copy-namespaces must be followed by 'preserve' or 'no-preserve'");
        }
        this.nextToken();
        this.expect(7);
        this.nextToken();
        this.expect(101);
        if ("inherit".equals(this.t.currentTokenValue)) {
            ((StaticQueryContext)this.env).setInheritNamespaces(true);
        } else if ("no-inherit".equals(this.t.currentTokenValue)) {
            ((StaticQueryContext)this.env).setInheritNamespaces(false);
        } else {
            this.grumble("After the comma in the copy-namespaces declaration, expected 'inherit' or 'no-inherit'");
        }
        this.nextToken();
    }

    private void parseConstructionDeclaration() throws StaticError {
        int n;
        if (this.foundConstructionDeclaration) {
            this.grumble("declare construction appears more than once", "XQST0067");
        }
        this.foundConstructionDeclaration = true;
        this.nextToken();
        this.expect(101);
        if ("preserve".equals(this.t.currentTokenValue)) {
            n = 3;
        } else if ("strip".equals(this.t.currentTokenValue)) {
            n = 4;
        } else {
            this.grumble("construction mode must be 'preserve' or 'strip'");
            n = 4;
        }
        ((StaticQueryContext)this.env).setConstructionMode(n);
        this.nextToken();
    }

    private void parseSchemaImport() throws StaticError {
        Configuration configuration;
        if (!this.env.getConfiguration().isSchemaAware(11)) {
            this.grumble("To import a schema, you need the schema-aware version of Saxon", "XQST0009");
        }
        String string = null;
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>(5);
        this.nextToken();
        if (this.isKeyword("namespace")) {
            this.nextToken();
            this.expect(101);
            string = this.t.currentTokenValue;
            this.checkProhibitedPrefixes(string);
            this.nextToken();
            this.expect(6);
            this.nextToken();
        } else if (this.isKeyword("default")) {
            this.nextToken();
            if (!this.isKeyword("element")) {
                this.grumble("In 'import schema', expected 'element namespace'");
            }
            this.nextToken();
            if (!this.isKeyword("namespace")) {
                this.grumble("In 'import schema', expected keyword 'namespace'");
            }
            this.nextToken();
            string = "";
        }
        if (this.t.currentToken == 102) {
            string2 = this.t.currentTokenValue;
            this.nextToken();
            if (this.isKeyword("at")) {
                this.nextToken();
                this.expect(102);
                arrayList.add(this.t.currentTokenValue);
                this.nextToken();
                while (this.t.currentToken == 7) {
                    this.nextToken();
                    this.expect(102);
                    arrayList.add(this.t.currentTokenValue);
                    this.nextToken();
                }
            } else if (this.t.currentToken != 90) {
                this.grumble("After the target namespace URI, expected 'at' or ';'");
            }
        } else {
            this.grumble("After 'import schema', expected 'namespace', 'default', or a string-literal");
        }
        if (string != null) {
            if (string2 == null || "".equals(string2)) {
                this.grumble("A prefix cannot be bound to the null namespace", "XQST0057");
            }
            try {
                if ("".equals(string)) {
                    ((StaticQueryContext)this.env).setDefaultElementNamespace(string2);
                } else {
                    ((StaticQueryContext)this.env).declarePassiveNamespace(string, string2, true);
                }
            }
            catch (StaticError staticError) {
                staticError.setLocator(this.makeLocator());
                this.reportError(staticError);
            }
        }
        if ((configuration = this.env.getConfiguration()).getSchema(string2) == null) {
            if (arrayList.size() > 0) {
                try {
                    PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
                    configuration.readMultipleSchemas(pipelineConfiguration, this.env.getBaseURI(), arrayList, string2);
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    this.grumble("Error in schema. " + transformerConfigurationException.getMessage(), "XQST0059");
                }
            } else {
                this.grumble("Unable to locate requested schema", "XQST0059");
            }
        }
        ((StaticQueryContext)this.env).addImportedSchema(string2);
    }

    private void parseModuleImport() throws StaticError {
        String string;
        StaticQueryContext staticQueryContext = (StaticQueryContext)this.env;
        String string2 = null;
        String string3 = null;
        ArrayList<String> arrayList = new ArrayList<String>(5);
        this.nextToken();
        if (this.t.currentToken == 101 && this.t.currentTokenValue == "namespace") {
            this.nextToken();
            this.expect(101);
            string2 = this.t.currentTokenValue;
            this.checkProhibitedPrefixes(string2);
            this.nextToken();
            this.expect(6);
            this.nextToken();
        }
        if (this.t.currentToken == 102) {
            string3 = this.t.currentTokenValue;
            if (this.importedModules.contains(string3)) {
                this.grumble("Two 'import module' declarations specify the same module namespace", "XQST0047");
            }
            this.importedModules.add(string3);
            this.nextToken();
            if (this.isKeyword("at")) {
                do {
                    this.nextToken();
                    this.expect(102);
                    arrayList.add(this.t.currentTokenValue);
                    this.nextToken();
                } while (this.t.currentToken == 7);
            }
        } else {
            this.grumble("After 'import module', expected 'namespace' or a string-literal");
        }
        if (string2 != null) {
            try {
                staticQueryContext.declarePassiveNamespace(string2, string3, true);
            }
            catch (StaticError staticError) {
                staticError.setLocator(this.makeLocator());
                this.reportError(staticError);
            }
        }
        if ((string = staticQueryContext.getModuleNamespace()) != null && string.equals(string3)) {
            this.grumble("A module cannot import its own namespace", "XQST0056");
        }
        if (arrayList.size() == 0) {
            List list = this.executable.getQueryLibraryModules(string3);
            if (list == null) {
                this.grumble("Cannot locate a library module with this module namespace", "XQST0059");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.importModuleContents((StaticQueryContext)list.get(i), staticQueryContext);
                }
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                StaticQueryContext staticQueryContext2 = staticQueryContext.loadModule(string3, (String)arrayList.get(i));
                this.importModuleContents(staticQueryContext2, staticQueryContext);
                continue;
            }
            catch (StaticError staticError) {
                if (staticError.getLocator() == null) {
                    staticError.setLocator(this.makeLocator());
                }
                this.reportError(staticError);
            }
        }
    }

    private void importModuleContents(StaticQueryContext staticQueryContext, StaticQueryContext staticQueryContext2) throws StaticError {
        Object object;
        short s = staticQueryContext.getModuleNamespaceCode();
        NamePool namePool = this.env.getNamePool();
        Iterator iterator = staticQueryContext.getFunctionDefinitions();
        while (iterator.hasNext()) {
            object = (XQueryFunction)iterator.next();
            if (namePool.getURICode(((XQueryFunction)object).getFunctionFingerprint()) != s) continue;
            staticQueryContext2.declareFunction((XQueryFunction)object);
            this.checkImportedType(((XQueryFunction)object).getResultType(), object);
            for (int i = 0; i < ((XQueryFunction)object).getNumberOfArguments(); ++i) {
                SequenceType sequenceType = ((XQueryFunction)object).getArgumentTypes()[i];
                this.checkImportedType(sequenceType, object);
            }
        }
        iterator = staticQueryContext.getVariableDeclarations();
        while (iterator.hasNext()) {
            object = (GlobalVariableDefinition)iterator.next();
            if (namePool.getURICode(((GlobalVariableDefinition)object).getNameCode()) != s) continue;
            staticQueryContext2.declareVariable((VariableDeclaration)object);
            this.checkImportedType(((GlobalVariableDefinition)object).getRequiredType(), object);
        }
    }

    private void checkImportedType(SequenceType sequenceType, Object object) throws StaticError {
        ItemType itemType = sequenceType.getPrimaryType();
        if (itemType instanceof AnyItemType) {
            return;
        }
        if (itemType instanceof AtomicType) {
            int n = ((AtomicType)itemType).getFingerprint();
            this.checkSchemaNamespaceImported(n, object);
        } else if (itemType instanceof ContentTypeTest) {
            SchemaType schemaType = ((ContentTypeTest)itemType).getSchemaType();
            int n = schemaType.getFingerprint();
            this.checkSchemaNamespaceImported(n, object);
        } else if (itemType instanceof CombinedNodeTest) {
            NodeTest[] nodeTestArray = ((CombinedNodeTest)itemType).getComponentNodeTests();
            for (int i = 0; i < nodeTestArray.length; ++i) {
                SequenceType sequenceType2 = SequenceType.makeSequenceType(nodeTestArray[1], 16384);
                this.checkImportedType(sequenceType2, object);
            }
        }
    }

    private void checkSchemaNamespaceImported(int n, Object object) throws StaticError {
        String string = this.env.getNamePool().getURI(n);
        if (string.equals("http://www.w3.org/2001/XMLSchema")) {
            return;
        }
        if (NamespaceConstant.isXDTNamespace(string)) {
            return;
        }
        if (this.env.isImportedSchema(string)) {
            return;
        }
        String string2 = "Schema component " + this.env.getNamePool().getDisplayName(n) + " used in ";
        string2 = object instanceof GlobalVariableDefinition ? string2 + "declaration of imported variable " + this.env.getNamePool().getDisplayName(((GlobalVariableDefinition)object).getNameCode()) : string2 + "signature of imported function " + this.env.getNamePool().getDisplayName(((XQueryFunction)object).getNameCode());
        string2 = string2 + " is not declared in any schema imported by this query module";
        this.grumble(string2, "XQST0036");
    }

    private void parseBaseURIDeclaration() throws StaticError {
        if (this.foundBaseURIDeclaration) {
            this.grumble("Base URI Declaration may only appear once", "XQST0032");
        }
        this.foundBaseURIDeclaration = true;
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        ((StaticQueryContext)this.env).setBaseURI(string);
        this.nextToken();
    }

    private void parseDefaultFunctionNamespace() throws StaticError {
        if (this.foundDefaultFunctionNamespace) {
            this.grumble("default function namespace appears more than once", "XQST0066");
        }
        this.foundDefaultFunctionNamespace = true;
        this.nextToken();
        this.expect(101);
        if (!"namespace".equals(this.t.currentTokenValue)) {
            this.grumble("After 'declare default function', expected 'namespace'");
        }
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        if (string.equals("")) {
            this.grumble("The default function namespace must not be a zero-length string", "XQST0063");
        }
        ((StaticQueryContext)this.env).setDefaultFunctionNamespace(string);
        this.nextToken();
    }

    private void parseDefaultElementNamespace() throws StaticError {
        if (this.foundDefaultElementNamespace) {
            this.grumble("default element namespace appears more than once", "XQST0066");
        }
        this.foundDefaultElementNamespace = true;
        this.nextToken();
        this.expect(101);
        if (!"namespace".equals(this.t.currentTokenValue)) {
            this.grumble("After 'declare default element', expected 'namespace'");
        }
        this.nextToken();
        this.expect(102);
        String string = this.t.currentTokenValue;
        ((StaticQueryContext)this.env).setDefaultElementNamespace(string);
        this.nextToken();
    }

    private void parseNamespaceDeclaration() throws StaticError {
        this.nextToken();
        this.expect(101);
        String string = this.t.currentTokenValue;
        if (!XMLChar.isValidNCName(string)) {
            this.grumble("Invalid namespace prefix " + Err.wrap(string));
        }
        this.checkProhibitedPrefixes(string);
        this.nextToken();
        this.expect(6);
        this.nextToken();
        this.expect(102);
        String string2 = this.t.currentTokenValue;
        if ("".equals(string2)) {
            this.grumble("A namespace URI cannot be empty");
        }
        try {
            ((StaticQueryContext)this.env).declarePassiveNamespace(string, string2, true);
        }
        catch (StaticError staticError) {
            staticError.setLocator(this.makeLocator());
            this.reportError(staticError);
        }
        this.nextToken();
    }

    private void checkProhibitedPrefixes(String string) throws StaticError {
        if ("xml".equals(string) || "xmlns".equals(string)) {
            this.grumble("The namespace prefix " + Err.wrap(string) + " cannot be redeclared", "XQST0070");
        }
    }

    private void parseVariableDeclaration() throws StaticError {
        Object object;
        int n = this.t.currentTokenStartOffset;
        GlobalVariableDefinition globalVariableDefinition = new GlobalVariableDefinition();
        globalVariableDefinition.setLineNumber(this.t.getLineNumber());
        this.nextToken();
        this.expect(21);
        this.t.setState(1);
        this.nextToken();
        this.expect(101);
        String string = this.t.currentTokenValue;
        globalVariableDefinition.setVariableName(string);
        int n2 = this.makeNameCode(this.t.currentTokenValue, false);
        int n3 = n2 & 0xFFFFF;
        globalVariableDefinition.setNameCode(n3);
        String string2 = this.env.getNamePool().getURI(n2);
        String string3 = ((StaticQueryContext)this.env).getModuleNamespace();
        if (string3 != null && !string3.equals(string2)) {
            this.grumble("A variable declared in a library module must be in the module namespace", "XQST0048");
        }
        this.nextToken();
        SequenceType sequenceType = SequenceType.ANY_SEQUENCE;
        if (this.isKeyword("as")) {
            this.t.setState(2);
            this.nextToken();
            sequenceType = this.parseSequenceType();
        }
        globalVariableDefinition.setRequiredType(sequenceType);
        if (this.t.currentToken == 52) {
            this.t.setState(0);
            this.nextToken();
            object = this.parseExpression();
            globalVariableDefinition.setIsParameter(false);
            globalVariableDefinition.setValueExpression(this.makeTracer(n, (Expression)object, 185, n2));
        } else if (this.t.currentToken == 101) {
            if ("external".equals(this.t.currentTokenValue)) {
                globalVariableDefinition.setIsParameter(true);
                if (this.defaultValue != null) {
                    globalVariableDefinition.setValueExpression(this.defaultValue);
                }
                this.nextToken();
            } else {
                this.grumble("Variable must either be initialized or be declared as external");
            }
        } else {
            this.grumble("Expected ':=' or 'external' in variable declaration");
        }
        object = (StaticQueryContext)this.env;
        if (((StaticQueryContext)object).getModuleNamespace() != null && this.env.getNamePool().getURICode(n3) != ((StaticQueryContext)object).getModuleNamespaceCode()) {
            this.grumble("Variable " + Err.wrap(string, 5) + " is not defined in the module namespace");
        }
        try {
            ((StaticQueryContext)object).declareVariable(globalVariableDefinition);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage(), xPathException.getErrorCodeLocalPart());
        }
    }

    private void parseFunctionDeclaration() throws StaticError {
        int n;
        UserFunctionParameter[] userFunctionParameterArray;
        String string;
        int n2;
        String string2;
        int n3 = this.t.currentTokenStartOffset;
        this.nextToken();
        this.expect(34);
        if (this.t.currentTokenValue.indexOf(58) < 0) {
            string2 = this.env.getDefaultFunctionNamespace();
            n2 = this.env.getNamePool().allocate("", string2, this.t.currentTokenValue);
        } else {
            n2 = this.makeNameCode(this.t.currentTokenValue, false);
            string2 = this.env.getNamePool().getURI(n2);
        }
        if (string2.equals("")) {
            this.grumble("The function must be in a namespace", "XQST0060");
        }
        if ((string = ((StaticQueryContext)this.env).getModuleNamespace()) != null && !string.equals(string2)) {
            this.grumble("A function in a library module must be in the module namespace", "XQST0048");
        }
        if (NamespaceConstant.isReservedInQuery(string2)) {
            this.grumble("The function name " + this.t.currentTokenValue + " is in a reserved namespace", "XQST0045");
        }
        XQueryFunction xQueryFunction = new XQueryFunction();
        xQueryFunction.setNameCode(n2);
        xQueryFunction.arguments = new ArrayList(8);
        xQueryFunction.resultType = SequenceType.ANY_SEQUENCE;
        xQueryFunction.body = null;
        xQueryFunction.lineNumber = this.t.getLineNumber(n3);
        xQueryFunction.columnNumber = this.t.getColumnNumber(n3);
        xQueryFunction.systemId = this.env.getSystemId();
        xQueryFunction.setExecutable(this.getExecutable());
        this.nextToken();
        HashSet<Integer> hashSet = new HashSet<Integer>(8);
        while (this.t.currentToken != 104) {
            this.expect(21);
            this.nextToken();
            this.expect(101);
            userFunctionParameterArray = this.t.currentTokenValue;
            n = this.makeNameCode((String)userFunctionParameterArray, false);
            int n4 = n & 0xFFFFF;
            Integer n5 = new Integer(n4);
            if (hashSet.contains(n5)) {
                this.grumble("Duplicate parameter name " + Err.wrap(this.t.currentTokenValue, 5), "XQST0039");
            }
            hashSet.add(n5);
            SequenceType sequenceType = SequenceType.ANY_SEQUENCE;
            this.nextToken();
            if (this.t.currentToken == 101 && "as".equals(this.t.currentTokenValue)) {
                this.nextToken();
                sequenceType = this.parseSequenceType();
            }
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setNameCode(n);
            rangeVariableDeclaration.setRequiredType(sequenceType);
            rangeVariableDeclaration.setVariableName((String)userFunctionParameterArray);
            xQueryFunction.arguments.add(rangeVariableDeclaration);
            this.declareRangeVariable(rangeVariableDeclaration);
            if (this.t.currentToken == 104) break;
            if (this.t.currentToken == 7) {
                this.nextToken();
                continue;
            }
            this.grumble("Expected ',' or ')' after function argument, found '" + Token.tokens[this.t.currentToken] + '\'');
        }
        this.t.setState(1);
        this.nextToken();
        if (this.isKeyword("as")) {
            this.t.setState(2);
            this.nextToken();
            xQueryFunction.resultType = this.parseSequenceType();
        }
        if (this.isKeyword("external")) {
            this.grumble("Saxon does not allow external functions to be declared");
        } else {
            this.expect(53);
            this.t.setState(0);
            this.nextToken();
            xQueryFunction.body = this.parseExpression();
            if (xQueryFunction.body instanceof ComputedExpression) {
                ((ComputedExpression)xQueryFunction.body).setParentExpression(xQueryFunction);
            }
            this.expect(115);
            this.lookAhead();
        }
        userFunctionParameterArray = xQueryFunction.getParameterDefinitions();
        for (n = 0; n < userFunctionParameterArray.length; ++n) {
            this.undeclareRangeVariable();
        }
        this.t.setState(0);
        this.nextToken();
        StaticQueryContext staticQueryContext = (StaticQueryContext)this.env;
        try {
            staticQueryContext.declareFunction(xQueryFunction);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
    }

    private void parseOptionDeclaration() throws StaticError {
        this.nextToken();
        this.expect(101);
        int n = this.makeNameCode(this.t.currentTokenValue, false);
        String string = this.env.getNamePool().getURI(n);
        this.nextToken();
        this.expect(102);
        String string2 = this.t.currentTokenValue;
        if (string.equals("http://saxon.sf.net/")) {
            String string3 = this.env.getNamePool().getLocalName(n);
            if (string3.equals("output")) {
                this.setOutputProperty(string2);
            } else if (string3.equals("default")) {
                this.defaultValue = this.setDefaultValue(string2);
            } else {
                this.warning("Unknown Saxon option declaration: " + this.env.getNamePool().getDisplayName(n));
            }
        }
        this.nextToken();
    }

    private void setOutputProperty(String string) {
        int n = string.indexOf("=");
        if (n < 0) {
            this.badOutputProperty("no equals sign");
        } else if (n == 0) {
            this.badOutputProperty("starts with '=");
        } else if (n == string.length() - 1) {
            this.badOutputProperty("ends with '=");
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        Properties properties = this.getExecutable().getDefaultOutputProperties();
        try {
            ResultDocument.setSerializationProperty(properties, this.makeNameCode(string2, false) & 0xFFFFF, string3, this.env.getNamePool(), this.env.getNamespaceResolver());
        }
        catch (XPathException xPathException) {
            this.badOutputProperty(xPathException.getMessage());
        }
    }

    private void badOutputProperty(String string) {
        try {
            this.warning("Invalid serialization property (" + string + ") - ignored");
        }
        catch (StaticError staticError) {
            // empty catch block
        }
    }

    public Expression setDefaultValue(String string) {
        try {
            IndependentContext independentContext = new IndependentContext(this.env.getConfiguration());
            independentContext.setNamespaceResolver(this.env.getNamespaceResolver());
            Expression expression = ExpressionTool.make(string, independentContext, 0, 0, 1);
            ItemType itemType = Type.ITEM_TYPE;
            expression = expression.analyze(independentContext, itemType);
            SlotManager slotManager = independentContext.getStackFrameMap();
            ExpressionTool.allocateSlots(expression, slotManager.getNumberOfVariables(), slotManager);
            return expression;
        }
        catch (XPathException xPathException) {
            try {
                this.warning("Invalid expression for default value: " + xPathException.getMessage() + " (ignored)");
            }
            catch (StaticError staticError) {
                // empty catch block
            }
            return null;
        }
    }

    protected Expression parseForExpression() throws StaticError {
        Object object;
        Object object2;
        int n;
        int n2 = this.t.currentTokenStartOffset;
        Expression expression = null;
        int n3 = -1;
        ArrayList arrayList = new ArrayList(4);
        while (true) {
            if (this.t.currentToken == 111) {
                this.parseForClause(arrayList);
                continue;
            }
            if (this.t.currentToken != 116) break;
            this.parseLetClause(arrayList);
        }
        if (this.t.currentToken == 28 || this.isKeyword("where")) {
            n3 = this.t.currentTokenStartOffset;
            this.nextToken();
            expression = this.parseExpression();
        }
        int n4 = this.t.currentTokenStartOffset;
        if (this.isKeyword("stable")) {
            this.nextToken();
            if (!this.isKeyword("order")) {
                this.grumble("'stable' must be followed by 'order by'");
            }
        }
        List list = null;
        if (this.isKeyword("order")) {
            this.t.setState(1);
            this.nextToken();
            if (!this.isKeyword("by")) {
                this.grumble("'order' must be followed by 'by'");
            }
            this.t.setState(0);
            this.nextToken();
            list = this.parseSortDefinition();
        }
        int n5 = this.t.currentTokenStartOffset;
        this.expect(25);
        this.t.setState(0);
        this.nextToken();
        Expression expression2 = this.parseExprSingle();
        expression2 = this.makeTracer(n5, expression2, 2014, -1);
        if (list != null) {
            TupleExpression tupleExpression = new TupleExpression(1 + list.size());
            this.setLocation(tupleExpression);
            tupleExpression.setExpression(0, expression2);
            for (n = 0; n < list.size(); ++n) {
                try {
                    object2 = new RoleLocator(6, "FLWR", n, null);
                    ((RoleLocator)object2).setSourceLocator(this.makeLocator());
                    object = TypeChecker.staticTypeCheck(((SortSpec)list.get((int)n)).sortKey, SequenceType.OPTIONAL_ATOMIC, false, (RoleLocator)object2, this.env);
                    tupleExpression.setExpression(n + 1, (Expression)object);
                    continue;
                }
                catch (XPathException xPathException) {
                    this.grumble(xPathException.getMessage());
                }
            }
            expression2 = tupleExpression;
        }
        if (expression != null) {
            expression2 = new IfExpression(expression, expression2, EmptySequence.getInstance());
            expression2 = this.makeTracer(n3, expression2, 2018, -1);
            this.setLocation(expression2);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Object e = arrayList.get(i);
            if (e instanceof ExpressionParser.ForClause) {
                object2 = (ExpressionParser.ForClause)e;
                object = new ForExpression();
                ((Assignation)object).setVariableDeclaration(((ExpressionParser.ForClause)object2).rangeVariable);
                ((ForExpression)object).setPositionVariable(((ExpressionParser.ForClause)object2).positionVariable);
                ((ComputedExpression)object).setLocationId(this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), this.t.getLineNumber(((ExpressionParser.ForClause)object2).offset)));
                ((Assignation)object).setSequence(((ExpressionParser.ForClause)object2).sequence);
                ((ForExpression)object).setAction(expression2);
                expression2 = this.makeTracer(((ExpressionParser.ForClause)object2).offset, (Expression)object, 2012, ((ExpressionParser.ForClause)object2).rangeVariable.getNameCode());
                continue;
            }
            object2 = (LetClause)e;
            object = this.makeLetExpression();
            ((Assignation)object).setVariableDeclaration(((LetClause)object2).variable);
            ((ComputedExpression)object).setLocationId(this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), this.t.getLineNumber(((LetClause)object2).offset)));
            ((Assignation)object).setSequence(((LetClause)object2).value);
            ((Assignation)object).setAction(expression2);
            expression2 = this.makeTracer(((LetClause)object2).offset, (Expression)object, 2013, ((LetClause)object2).variable.getNameCode());
        }
        if (list != null) {
            FixedSortKeyDefinition[] fixedSortKeyDefinitionArray = new FixedSortKeyDefinition[list.size()];
            for (n = 0; n < list.size(); ++n) {
                object2 = (SortSpec)list.get(n);
                object = new FixedSortKeyDefinition();
                ((SortKeyDefinition)object).setSortKey(((SortSpec)list.get((int)n)).sortKey);
                ((SortKeyDefinition)object).setOrder(new StringValue(((SortSpec)object2).ascending ? "ascending" : "descending"));
                ((SortKeyDefinition)object).setEmptyFirst(((SortSpec)object2).ascending ? ((SortSpec)object2).emptyLeast : !((SortSpec)object2).emptyLeast);
                try {
                    if (((SortSpec)object2).collation != null) {
                        ((SortKeyDefinition)object).setCollation(this.env.getCollation(((SortSpec)object2).collation));
                    }
                    ((FixedSortKeyDefinition)object).bindComparer(this.env.getConfiguration());
                    fixedSortKeyDefinitionArray[n] = object;
                    continue;
                }
                catch (XPathException xPathException) {
                    this.grumble(xPathException.getMessage());
                }
            }
            TupleSorter tupleSorter = new TupleSorter(expression2, fixedSortKeyDefinitionArray);
            this.setLocation(tupleSorter);
            expression2 = this.makeTracer(n4, tupleSorter, 2019, -1);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Object e = arrayList.get(i);
            if (e instanceof ExpressionParser.ForClause && ((ExpressionParser.ForClause)e).positionVariable != null) {
                this.undeclareRangeVariable();
            }
            this.undeclareRangeVariable();
        }
        this.setLocation(expression2, n2);
        return expression2;
    }

    private LetExpression makeLetExpression() {
        if (this.env.getConfiguration().getTraceListener() == null) {
            return new LetExpression();
        }
        return new EagerLetExpression();
    }

    private void parseForClause(List list) throws StaticError {
        boolean bl = true;
        do {
            Object object;
            ExpressionParser.ForClause forClause = new ExpressionParser.ForClause();
            if (bl) {
                forClause.offset = this.t.currentTokenStartOffset;
            }
            list.add(forClause);
            this.nextToken();
            if (bl) {
                bl = false;
            } else {
                forClause.offset = this.t.currentTokenStartOffset;
            }
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String string = this.t.currentTokenValue;
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setNameCode(this.makeNameCode(string, false));
            rangeVariableDeclaration.setRequiredType(SequenceType.SINGLE_ITEM);
            rangeVariableDeclaration.setVariableName(string);
            forClause.rangeVariable = rangeVariableDeclaration;
            this.nextToken();
            if (this.isKeyword("as")) {
                this.nextToken();
                object = this.parseSequenceType();
                rangeVariableDeclaration.setRequiredType((SequenceType)object);
                if (((SequenceType)object).getCardinality() != 16384) {
                    this.grumble("Cardinality of range variable must be exactly one");
                }
            }
            forClause.positionVariable = null;
            if (this.isKeyword("at")) {
                this.nextToken();
                this.expect(21);
                this.nextToken();
                this.expect(101);
                object = new RangeVariableDeclaration();
                ((RangeVariableDeclaration)object).setNameCode(this.makeNameCode(this.t.currentTokenValue, false));
                ((RangeVariableDeclaration)object).setRequiredType(SequenceType.SINGLE_INTEGER);
                ((RangeVariableDeclaration)object).setVariableName(this.t.currentTokenValue);
                forClause.positionVariable = object;
                this.nextToken();
            }
            this.expect(30);
            this.nextToken();
            forClause.sequence = this.parseExprSingle();
            this.declareRangeVariable(forClause.rangeVariable);
            if (forClause.positionVariable == null) continue;
            this.declareRangeVariable(forClause.positionVariable);
        } while (this.t.currentToken == 7);
    }

    private void parseLetClause(List list) throws StaticError {
        boolean bl = true;
        do {
            LetClause letClause = new LetClause();
            if (bl) {
                letClause.offset = this.t.currentTokenStartOffset;
            }
            list.add(letClause);
            this.nextToken();
            if (bl) {
                bl = false;
            } else {
                letClause.offset = this.t.currentTokenStartOffset;
            }
            this.expect(21);
            this.nextToken();
            this.expect(101);
            String string = this.t.currentTokenValue;
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setNameCode(this.makeNameCode(string, false));
            rangeVariableDeclaration.setRequiredType(SequenceType.ANY_SEQUENCE);
            rangeVariableDeclaration.setVariableName(string);
            letClause.variable = rangeVariableDeclaration;
            this.nextToken();
            if (this.isKeyword("as")) {
                this.nextToken();
                rangeVariableDeclaration.setRequiredType(this.parseSequenceType());
            }
            this.expect(52);
            this.nextToken();
            letClause.value = this.parseExprSingle();
            this.declareRangeVariable(rangeVariableDeclaration);
        } while (this.t.currentToken == 7);
    }

    public static Expression makeStringJoin(Expression expression, StaticContext staticContext) {
        ItemType itemType = (expression = new Atomizer(expression, staticContext.getConfiguration())).getItemType();
        if (itemType != Type.STRING_TYPE && itemType != Type.UNTYPED_ATOMIC_TYPE) {
            expression = new AtomicSequenceConverter(expression, Type.STRING_TYPE);
        }
        StringJoin stringJoin = (StringJoin)SystemFunction.makeSystemFunction("string-join", 2, staticContext.getNamePool());
        Expression[] expressionArray = new Expression[]{expression, new StringValue(" ")};
        stringJoin.setArguments(expressionArray);
        if (expression instanceof ComputedExpression) {
            stringJoin.setLocationId(((ComputedExpression)expression).getLocationId());
        }
        return stringJoin;
    }

    private List parseSortDefinition() throws StaticError {
        ArrayList<SortSpec> arrayList = new ArrayList<SortSpec>(5);
        while (true) {
            SortSpec sortSpec = new SortSpec();
            sortSpec.sortKey = this.parseExprSingle();
            sortSpec.ascending = true;
            sortSpec.emptyLeast = this.defaultEmptyLeast;
            sortSpec.collation = this.env.getDefaultCollationName();
            if (this.isKeyword("ascending")) {
                this.nextToken();
            } else if (this.isKeyword("descending")) {
                sortSpec.ascending = false;
                this.nextToken();
            }
            if (this.isKeyword("empty")) {
                this.nextToken();
                if (this.isKeyword("greatest")) {
                    sortSpec.emptyLeast = false;
                    this.nextToken();
                } else if (this.isKeyword("least")) {
                    sortSpec.emptyLeast = true;
                    this.nextToken();
                } else {
                    this.grumble("'empty' must be followed by 'greatest' or 'least'");
                }
            }
            if (this.isKeyword("collation")) {
                this.nextToken();
                this.expect(102);
                sortSpec.collation = this.t.currentTokenValue;
                this.nextToken();
            }
            arrayList.add(sortSpec);
            if (this.t.currentToken != 7) break;
            this.nextToken();
        }
        return arrayList;
    }

    protected Expression parseTypeswitchExpression() throws StaticError {
        Object object;
        Object object2;
        int n;
        int n2 = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression expression = this.parseExpression();
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(10);
        this.expect(104);
        this.nextToken();
        LetExpression letExpression = this.makeLetExpression();
        RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
        rangeVariableDeclaration.setNameCode(this.makeNameCode("zz_typeswitchVar", false));
        rangeVariableDeclaration.setRequiredType(SequenceType.ANY_SEQUENCE);
        rangeVariableDeclaration.setVariableName("zz_typeswitchVar");
        letExpression.setVariableDeclaration(rangeVariableDeclaration);
        letExpression.setSequence(expression);
        while (this.t.currentToken == 59) {
            n = this.t.currentTokenStartOffset;
            this.nextToken();
            if (this.t.currentToken == 21) {
                this.nextToken();
                this.expect(101);
                String string = this.t.currentTokenValue;
                int n3 = this.makeNameCode(string, false);
                this.nextToken();
                this.expect(101);
                if (!"as".equals(this.t.currentTokenValue)) {
                    this.grumble("After 'case $" + string + "', expected 'as'");
                }
                this.nextToken();
                object2 = this.parseSequenceType();
                object = this.makeTracer(n, this.parseTypeswitchReturnClause(string, n3, (SequenceType)object2, rangeVariableDeclaration), 2021, n3);
                if (object instanceof TraceExpression) {
                    ((TraceExpression)object).setProperty("type", ((SequenceType)object2).toString());
                }
            } else {
                object2 = this.parseSequenceType();
                this.t.treatCurrentAsOperator();
                this.expect(25);
                this.nextToken();
                object = this.makeTracer(n, this.parseExprSingle(), 2021, -1);
                if (object instanceof TraceExpression) {
                    ((TraceExpression)object).setProperty("type", ((SequenceType)object2).toString());
                }
            }
            arrayList.add(object2);
            arrayList2.add(object);
        }
        if (arrayList.size() == 0) {
            this.grumble("At least one case clause is required in a typeswitch");
        }
        this.expect(60);
        n = this.t.currentTokenStartOffset;
        this.nextToken();
        if (this.t.currentToken == 21) {
            this.nextToken();
            this.expect(101);
            object = this.t.currentTokenValue;
            int n4 = this.makeNameCode((String)object, false);
            this.nextToken();
            object2 = this.makeTracer(n, this.parseTypeswitchReturnClause((String)object, n4, SequenceType.ANY_SEQUENCE, rangeVariableDeclaration), 2022, n4);
        } else {
            this.t.treatCurrentAsOperator();
            this.expect(25);
            this.nextToken();
            object2 = this.makeTracer(n, this.parseExprSingle(), 2022, -1);
        }
        object = object2;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            VariableReference variableReference = new VariableReference(rangeVariableDeclaration);
            this.setLocation(variableReference);
            InstanceOfExpression instanceOfExpression = new InstanceOfExpression(variableReference, (SequenceType)arrayList.get(i));
            this.setLocation(instanceOfExpression);
            IfExpression ifExpression = new IfExpression(instanceOfExpression, (Expression)arrayList2.get(i), (Expression)object);
            this.setLocation(ifExpression);
            object = ifExpression;
        }
        letExpression.setAction((Expression)object);
        return this.makeTracer(n2, letExpression, 2020, -1);
    }

    private Expression parseTypeswitchReturnClause(String string, int n, SequenceType sequenceType, RangeVariableDeclaration rangeVariableDeclaration) throws StaticError {
        this.t.treatCurrentAsOperator();
        this.expect(25);
        this.nextToken();
        RangeVariableDeclaration rangeVariableDeclaration2 = new RangeVariableDeclaration();
        rangeVariableDeclaration2.setNameCode(n);
        rangeVariableDeclaration2.setRequiredType(sequenceType);
        rangeVariableDeclaration2.setVariableName(string);
        this.declareRangeVariable(rangeVariableDeclaration2);
        Expression expression = this.parseExprSingle();
        this.undeclareRangeVariable();
        LetExpression letExpression = this.makeLetExpression();
        letExpression.setVariableDeclaration(rangeVariableDeclaration2);
        letExpression.setSequence(new VariableReference(rangeVariableDeclaration));
        letExpression.setAction(expression);
        expression = letExpression;
        return expression;
    }

    protected Expression parseValidateExpression() throws StaticError {
        if (!this.env.getConfiguration().isSchemaAware(11)) {
            this.grumble("To use a validate expression, you need the schema-aware processor from http://www.saxonica.com/");
        }
        int n = this.t.currentTokenStartOffset;
        int n2 = 1;
        boolean bl = false;
        switch (this.t.currentToken) {
            case 82: {
                n2 = 1;
                this.nextToken();
                break;
            }
            case 83: {
                n2 = 2;
                this.nextToken();
                break;
            }
            case 54: {
                if (this.t.currentTokenValue != "validate") {
                    throw new AssertionError((Object)"shouldn't be parsing a validate expression");
                }
                n2 = 1;
                bl = true;
            }
        }
        if (!bl) {
            this.expect(53);
        }
        this.nextToken();
        Expression expression = this.parseExpression();
        if (expression instanceof ElementCreator) {
            ((ElementCreator)expression).setValidationMode(n2);
        } else if (expression instanceof DocumentInstr) {
            ((DocumentInstr)expression).setValidationAction(n2);
        } else {
            try {
                RoleLocator roleLocator = new RoleLocator(2, "validate", 0, null);
                roleLocator.setSourceLocator(this.makeLocator());
                expression = TypeChecker.staticTypeCheck(expression, SequenceType.SINGLE_NODE, false, roleLocator, this.env);
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage());
            }
            expression = new CopyOf(expression, true, n2, null);
            this.setLocation(expression);
            ((CopyOf)expression).setRequireDocumentOrElement(true);
        }
        this.expect(115);
        this.t.lookAhead();
        this.nextToken();
        return this.makeTracer(n, expression, 2023, -1);
    }

    protected Expression parseExtensionExpression() throws StaticError {
        this.nextToken();
        if (this.t.currentToken == 118) {
            return this.parseExtensionExpression();
        }
        this.expect(53);
        this.nextToken();
        if (this.t.currentToken == 115) {
            this.t.lookAhead();
            this.nextToken();
            this.grumble("Unrecognized pragma, with no fallback expression");
        }
        Expression expression = this.parseExpression();
        this.expect(115);
        this.t.lookAhead();
        this.nextToken();
        return expression;
    }

    protected Expression parseConstructor() throws StaticError {
        int n = this.t.currentTokenStartOffset;
        switch (this.t.currentToken) {
            case 117: {
                Expression expression = this.parsePseudoXML(false);
                this.lookAhead();
                this.t.setState(3);
                this.nextToken();
                return expression;
            }
            case 54: {
                String string = this.t.currentTokenValue;
                if (string == "validate") {
                    return this.parseValidateExpression();
                }
                if (string == "ordered" || string == "unordered") {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    return expression;
                }
                if (string == "document") {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    DocumentInstr documentInstr = new DocumentInstr(false, null, this.env.getBaseURI());
                    documentInstr.setContentExpression(expression);
                    this.setLocation(documentInstr, n);
                    return documentInstr;
                }
                if ("element".equals(string)) {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression expression2 = null;
                    if (this.t.currentToken != 115) {
                        expression2 = this.parseExpression();
                        if (expression2 instanceof ElementCreator) {
                            ((ElementCreator)expression2).setValidationMode(3);
                        }
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    if (expression instanceof Value) {
                        int n2;
                        if (expression instanceof StringValue) {
                            String string2 = ((StringValue)expression).getStringValue();
                            n2 = this.makeNameCode(string2, true);
                        } else if (expression instanceof QNameValue) {
                            n2 = this.env.getNamePool().allocate("", ((QNameValue)expression).getNamespaceURI(), ((QNameValue)expression).getLocalName());
                        } else {
                            this.grumble("Element name must be either a string or a QName");
                            return null;
                        }
                        FixedElement fixedElement = new FixedElement(n2, ((StaticQueryContext)this.env).getActiveNamespaceCodes(), ((StaticQueryContext)this.env).isInheritNamespaces(), null, ((StaticQueryContext)this.env).getConstructionMode());
                        if (expression2 == null) {
                            expression2 = EmptySequence.getInstance();
                        }
                        fixedElement.setContentExpression(expression2);
                        this.setLocation(fixedElement, n);
                        return this.makeTracer(n, fixedElement, 2006, n2);
                    }
                    ComputedElement computedElement = new ComputedElement(expression, null, this.env.getNamespaceResolver(), null, ((StaticQueryContext)this.env).getConstructionMode(), ((StaticQueryContext)this.env).isInheritNamespaces(), true);
                    this.setLocation(computedElement);
                    if (expression2 == null) {
                        expression2 = EmptySequence.getInstance();
                    }
                    computedElement.setContentExpression(expression2);
                    this.setLocation(computedElement, n);
                    return this.makeTracer(n, computedElement, 143, -1);
                }
                if ("attribute".equals(string)) {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression expression3 = null;
                    if (this.t.currentToken != 115) {
                        expression3 = this.parseExpression();
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    if (expression instanceof StringValue && expression3 instanceof Value) {
                        int n3 = this.makeNameCode(((StringValue)expression).getStringValue(), false);
                        FixedAttribute fixedAttribute = new FixedAttribute(n3, 4, null, -1);
                        fixedAttribute.setRejectDuplicates();
                        this.makeSimpleContent(expression3, fixedAttribute, n);
                        return this.makeTracer(n, fixedAttribute, 131, -1);
                    }
                    Attribute attribute = new Attribute(expression, null, this.env.getNamespaceResolver(), 4, null, -1, true);
                    attribute.setRejectDuplicates();
                    this.makeSimpleContent(expression3, attribute, n);
                    return this.makeTracer(n, attribute, 131, -1);
                }
                if ("text".equals(string)) {
                    this.nextToken();
                    if (this.t.currentToken == 115) {
                        this.lookAhead();
                        this.nextToken();
                        return EmptySequence.getInstance();
                    }
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    ValueOf valueOf = new ValueOf(this.stringify(expression), false);
                    this.setLocation(valueOf, n);
                    return this.makeTracer(n, valueOf, 182, -1);
                }
                if ("comment".equals(string)) {
                    this.nextToken();
                    if (this.t.currentToken == 115) {
                        this.lookAhead();
                        this.nextToken();
                        return EmptySequence.getInstance();
                    }
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    Comment comment = new Comment();
                    this.makeSimpleContent(expression, comment, n);
                    return this.makeTracer(n, comment, 138, -1);
                }
                if ("processing-instruction".equals(string)) {
                    this.nextToken();
                    Expression expression = this.parseExpression();
                    this.expect(115);
                    this.lookAhead();
                    this.nextToken();
                    this.expect(53);
                    this.t.setState(0);
                    this.nextToken();
                    Expression expression4 = null;
                    if (this.t.currentToken != 115) {
                        expression4 = this.parseExpression();
                        this.expect(115);
                    }
                    this.lookAhead();
                    this.nextToken();
                    ProcessingInstruction processingInstruction = new ProcessingInstruction(expression);
                    this.makeSimpleContent(expression4, processingInstruction, n);
                    return this.makeTracer(n, processingInstruction, 173, -1);
                }
                this.grumble("Unrecognized node constructor " + this.t.currentTokenValue + "{}");
            }
            case 55: {
                int n4 = this.makeNameCode(this.t.currentTokenValue, true);
                Expression expression = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    expression = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                FixedElement fixedElement = new FixedElement(n4, ((StaticQueryContext)this.env).getActiveNamespaceCodes(), ((StaticQueryContext)this.env).isInheritNamespaces(), null, ((StaticQueryContext)this.env).getConstructionMode());
                this.setLocation(fixedElement, n);
                if (expression == null) {
                    expression = EmptySequence.getInstance();
                }
                fixedElement.setContentExpression(expression);
                return this.makeTracer(n, fixedElement, 2006, n4);
            }
            case 56: {
                int n5 = this.makeNameCode(this.t.currentTokenValue, false);
                Expression expression = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    expression = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                FixedAttribute fixedAttribute = new FixedAttribute(n5, 4, null, -1);
                fixedAttribute.setRejectDuplicates();
                this.makeSimpleContent(expression, fixedAttribute, n);
                return this.makeTracer(n, fixedAttribute, 2007, n5);
            }
            case 57: {
                StringValue stringValue = new StringValue(this.t.currentTokenValue);
                Expression expression = null;
                this.nextToken();
                if (this.t.currentToken != 115) {
                    expression = this.parseExpression();
                    this.expect(115);
                }
                this.lookAhead();
                this.nextToken();
                ProcessingInstruction processingInstruction = new ProcessingInstruction(stringValue);
                this.makeSimpleContent(expression, processingInstruction, n);
                return this.makeTracer(n, processingInstruction, 173, -1);
            }
        }
        return null;
    }

    private void makeSimpleContent(Expression expression, SimpleNodeConstructor simpleNodeConstructor, int n) throws StaticError {
        try {
            if (expression == null) {
                simpleNodeConstructor.setSelect(StringValue.EMPTY_STRING);
            } else {
                simpleNodeConstructor.setSelect(this.stringify(expression));
            }
            this.setLocation(simpleNodeConstructor, n);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
    }

    private Expression parsePseudoXML(boolean bl) throws StaticError {
        Expression expression = null;
        int n = this.t.inputOffset;
        char c = this.t.nextChar();
        switch (c) {
            case '!': {
                c = this.t.nextChar();
                if (c == '-') {
                    expression = this.parseCommentConstructor();
                    break;
                }
                if (c == '[') {
                    this.grumble("A CDATA section is allowed only in element content");
                    break;
                }
                this.grumble("Expected '--' or '[CDATA[' after '<!'");
                break;
            }
            case '?': {
                expression = this.parsePIConstructor();
                break;
            }
            case '/': {
                if (bl) {
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(40);
                    while ((c = this.t.nextChar()) != '>') {
                        fastStringBuffer.append(c);
                    }
                    return new StringValue(fastStringBuffer);
                }
                this.grumble("Unmatched XML end tag");
                break;
            }
            default: {
                this.t.unreadChar();
                expression = this.parseDirectElementConstructor();
            }
        }
        this.setLocation(expression, n);
        return expression;
    }

    private Expression parseDirectElementConstructor() throws StaticError {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        char c;
        int n = this.t.inputOffset - 1;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(40);
        int n2 = 0;
        while ((c = this.t.nextChar()) != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '/' && c != '>') {
            fastStringBuffer.append(c);
        }
        String string = fastStringBuffer.toString();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
        while ((c = this.skipSpaces(c)) != '/' && c != '>') {
            int n3 = this.t.inputOffset - 1;
            fastStringBuffer.setLength(0);
            do {
                fastStringBuffer.append(c);
            } while ((c = this.t.nextChar()) != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '=');
            String string2 = fastStringBuffer.toString();
            if (!Name.isQName(string2)) {
                this.grumble("Invalid attribute name " + Err.wrap(string2, 2));
            }
            c = this.skipSpaces(c);
            this.expectChar(c, '=');
            c = this.t.nextChar();
            c = this.skipSpaces(c);
            try {
                object5 = this.makeAttributeContent(this.t.input, this.t.inputOffset, c, true);
            }
            catch (StaticError staticError) {
                this.grumble(staticError.getMessage());
                return null;
            }
            catch (XPathException xPathException) {
                throw xPathException.makeStatic();
            }
            int n4 = (int)((IntegerValue)object5).longValue();
            object4 = this.t.input.substring(this.t.inputOffset - 1, n4 + 1);
            object3 = this.t.input.substring(this.t.inputOffset, n4);
            this.t.inputOffset = n4 + 1;
            c = this.t.nextChar();
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '/' && c != '>') {
                this.grumble("There must be whitespace after every attribute except the last");
            }
            if ("xmlns".equals(string2) || string2.startsWith("xmlns:")) {
                if (((String)object3).indexOf(123) >= 0) {
                    this.grumble("Namespace URI must be a constant value", "XQST0022");
                }
                if ("xmlns".equals(string2)) {
                    object2 = "";
                    object = object3;
                } else {
                    object2 = string2.substring(6);
                    if (((String)object2).equals("xml")) {
                        this.grumble("Cannot redeclare the XML namespace", "XQST0070");
                    } else if (((String)object2).equals("xmlns")) {
                        this.grumble("Cannot use xmlns as a namespace prefix", "XQST0070");
                    }
                    object = object3;
                    if ("".equals(object)) {
                        this.grumble("Namespace URI must not be empty");
                    }
                }
                ++n2;
                ((StaticQueryContext)this.env).declareActiveNamespace((String)object2, (String)object);
            }
            if (hashMap.get(string2) != null) {
                if ("xmlns".equals(string2) || string2.startsWith("xmlns:")) {
                    this.grumble("Duplicate namespace declaration " + string2, "XQST0071");
                } else {
                    this.grumble("Duplicate attribute name " + string2, "XQST0040");
                }
            }
            object2 = new AttributeDetails();
            ((AttributeDetails)object2).value = object4;
            ((AttributeDetails)object2).startOffset = n3;
            hashMap.put(string2, object2);
        }
        int n5 = 0;
        try {
            object5 = Name.getQNameParts(string);
            String string3 = ((StaticQueryContext)this.env).checkURIForPrefix(object5[0]);
            if (string3 == null) {
                this.grumble("Undeclared prefix in element name " + Err.wrap(string, 1));
            }
            n5 = this.env.getNamePool().allocate(object5[0], string3, object5[1]);
        }
        catch (QNameException qNameException) {
            this.grumble("Invalid element name " + Err.wrap(string, 1));
        }
        int n6 = ((StaticQueryContext)this.env).getConstructionMode();
        FixedElement fixedElement = new FixedElement(n5, ((StaticQueryContext)this.env).getActiveNamespaceCodes(), ((StaticQueryContext)this.env).isInheritNamespaces(), null, n6);
        this.setLocation(fixedElement, n);
        object4 = new ArrayList(10);
        object3 = new HashSet(hashMap.size());
        object2 = hashMap.keySet().iterator();
        while (object2.hasNext()) {
            Object object6;
            Object object7;
            object = (String)object2.next();
            AttributeDetails attributeDetails = (AttributeDetails)hashMap.get(object);
            String string4 = attributeDetails.value;
            int n7 = attributeDetails.startOffset;
            if ("xmlns".equals(object) || ((String)object).startsWith("xmlns:") || this.scanOnly) continue;
            int n8 = 0;
            try {
                object7 = Name.getQNameParts((CharSequence)object);
                String string5 = "".equals(object7[0]) ? "" : ((StaticQueryContext)this.env).checkURIForPrefix(object7[0]);
                if (string5 == null) {
                    this.grumble("Undeclared prefix in attribute name " + Err.wrap((CharSequence)object, 2));
                }
                if (((HashSet)object3).contains(object6 = new Integer((n8 = this.env.getNamePool().allocate(object7[0], string5, object7[1])) & 0xFFFFF))) {
                    this.grumble("Duplicate expanded attribute name " + (String)object, "XQST0040");
                }
                ((HashSet)object3).add(object6);
            }
            catch (QNameException qNameException) {
                this.grumble("Invalid attribute name " + Err.wrap((CharSequence)object, 2));
            }
            object7 = new FixedAttribute(n8, 4, null, -1);
            this.setLocation((Expression)object7);
            try {
                object6 = this.makeAttributeContent(string4, 1, string4.charAt(0), false);
            }
            catch (XPathException xPathException) {
                throw xPathException.makeStatic();
            }
            ((FixedAttribute)object7).setSelect((Expression)object6);
            ((FixedAttribute)object7).setRejectDuplicates();
            this.setLocation((Expression)object7);
            object4.add(this.makeTracer(n7, (Expression)object7, 2007, n8));
        }
        if (c == '/') {
            this.expectChar(this.t.nextChar(), '>');
        } else {
            this.readElementContent(string, (List)object4);
        }
        object2 = new Expression[object4.size()];
        for (int i = 0; i < object4.size(); ++i) {
            if (n6 != 4 && object4.get(i) instanceof ElementCreator && ((ElementCreator)object4.get(i)).getValidationMode() == n6) {
                ((ElementCreator)object4.get(i)).setValidationMode(3);
            }
            object2[i] = (Expression)object4.get(i);
        }
        Block block = new Block();
        block.setChildren((Expression[])object2);
        fixedElement.setContentExpression(block);
        for (int i = 0; i < n2; ++i) {
            ((StaticQueryContext)this.env).undeclareNamespace();
        }
        return this.makeTracer(n, fixedElement, 2006, n5);
    }

    private Expression makeAttributeContent(String string, int n, char c, boolean bl) throws XPathException {
        Expression expression;
        Object object;
        int n2 = this.t.getLineNumber();
        ArrayList<Expression> arrayList = new ArrayList<Expression>(10);
        int n3 = n;
        int n4 = string.length();
        while (n3 < n4) {
            int n5 = string.indexOf(c, n3);
            if (n5 < 0) {
                throw new StaticError("Attribute constructor is not properly terminated");
            }
            int n6 = string.indexOf("{", n3);
            int n7 = string.indexOf("{{", n3);
            int n8 = string.indexOf("}", n3);
            int n9 = string.indexOf("}}", n3);
            if (!(n6 >= 0 && n5 >= n6 || n8 >= 0 && n5 >= n8)) {
                this.addStringComponent(arrayList, string, n3, n5);
                if (n5 + 1 < string.length() && string.charAt(n5 + 1) == c) {
                    arrayList.add(new StringValue(c + ""));
                    n3 = n5 + 2;
                    continue;
                }
                n3 = n5;
                break;
            }
            if (n8 >= 0 && (n6 < 0 || n8 < n6)) {
                if (n8 != n9) {
                    throw new StaticError("Closing curly brace in attribute value template \"" + string + "\" must be doubled");
                }
                this.addStringComponent(arrayList, string, n3, n8 + 1);
                n3 = n8 + 2;
                continue;
            }
            if (n7 >= 0 && n7 == n6) {
                this.addStringComponent(arrayList, string, n3, n7 + 1);
                n3 = n7 + 2;
                continue;
            }
            if (n6 >= 0) {
                if (n6 > n3) {
                    this.addStringComponent(arrayList, string, n3, n6);
                }
                object = new QueryParser();
                ((ExpressionParser)object).setScanOnly(bl);
                if (this.rangeVariables != null) {
                    ((ExpressionParser)object).setRangeVariableStack(this.rangeVariables);
                }
                expression = ((ExpressionParser)object).parse(string, n6 + 1, 115, n2, this.env);
                if (!bl) {
                    expression = expression.simplify(this.env);
                }
                n3 = ((ExpressionParser)object).getTokenizer().currentTokenStartOffset + 1;
                arrayList.add(QueryParser.makeStringJoin(expression, this.env));
                continue;
            }
            throw new IllegalStateException("Internal error parsing direct attribute constructor");
        }
        if (bl) {
            return new IntegerValue(n3);
        }
        if (arrayList.size() == 0) {
            return StringValue.EMPTY_STRING;
        }
        if (arrayList.size() == 1) {
            return ((Expression)arrayList.get(0)).simplify(this.env);
        }
        expression = (Concat)SystemFunction.makeSystemFunction("concat", arrayList.size(), this.env.getNamePool());
        object = new Expression[arrayList.size()];
        arrayList.toArray((T[])object);
        ((FunctionCall)expression).setArguments((Expression[])object);
        ((ComputedExpression)expression).setLocationId(this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), n2));
        return ((FunctionCall)expression).simplify(this.env);
    }

    private void addStringComponent(List list, String string, int n, int n2) throws XPathException {
        if (n < n2) {
            list.add(this.makeStringLiteral(string.substring(n, n2)));
        }
    }

    private void readElementContent(String string, List list) throws StaticError {
        try {
            boolean bl = false;
            while (true) {
                Object object;
                Expression expression;
                char c;
                FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
                boolean bl2 = false;
                while (true) {
                    if ((c = this.t.nextChar()) == '<') {
                        if (this.t.nextChar() == '!') {
                            if (this.t.nextChar() == '[') {
                                this.readCDATASection(fastStringBuffer);
                                bl2 = true;
                                continue;
                            }
                            this.t.unreadChar();
                            this.t.unreadChar();
                            break;
                        }
                        this.t.unreadChar();
                        break;
                    }
                    if (c == '&') {
                        fastStringBuffer.append(this.readEntityReference());
                        bl2 = true;
                    } else if (c == '}') {
                        c = this.t.nextChar();
                        if (c != '}') {
                            this.grumble("'}' must be written as '}}' within element content");
                        }
                        fastStringBuffer.append(c);
                    } else if (c == '{') {
                        c = this.t.nextChar();
                        if (c != '{') {
                            c = '{';
                            break;
                        }
                        fastStringBuffer.append(c);
                    } else {
                        fastStringBuffer.append(c);
                    }
                    bl = false;
                }
                if (fastStringBuffer.length() > 0 && bl2 | this.preserveSpace | !Navigator.isWhite(fastStringBuffer)) {
                    expression = new ValueOf(new StringValue(fastStringBuffer.condense()), false);
                    this.setLocation(expression);
                    list.add(expression);
                }
                if (c == '<') {
                    expression = this.parsePseudoXML(true);
                    if (expression instanceof StringValue) {
                        object = ((StringValue)expression).getStringValue().trim();
                        if (((String)object).equals(string)) {
                            return;
                        }
                        this.grumble("end tag </" + (String)object + "> does not match start tag <" + string + '>');
                    } else {
                        list.add(expression);
                    }
                    bl = false;
                    continue;
                }
                if (bl && !((object = (expression = (Expression)list.get(list.size() - 1)).getItemType()) instanceof NodeTest)) {
                    ValueOf valueOf = new ValueOf(new StringValue(""), false);
                    this.setLocation(valueOf);
                    list.add(valueOf);
                }
                this.t.unreadChar();
                this.t.setState(0);
                this.lookAhead();
                this.nextToken();
                expression = this.parseExpression();
                list.add(expression);
                this.expect(115);
                bl = true;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing end tag found for direct element constructor");
            return;
        }
    }

    private Expression parsePIConstructor() throws StaticError {
        try {
            String string;
            FastStringBuffer fastStringBuffer = new FastStringBuffer(120);
            int n = -1;
            while (!fastStringBuffer.toString().endsWith("?>")) {
                char c = this.t.nextChar();
                if (n < 0 && " \t\r\n".indexOf(c) >= 0) {
                    n = fastStringBuffer.length();
                }
                fastStringBuffer.append(c);
            }
            fastStringBuffer.setLength(fastStringBuffer.length() - 2);
            String string2 = "";
            if (n < 0) {
                string = fastStringBuffer.toString();
            } else {
                string = fastStringBuffer.toString().substring(0, n);
                string2 = fastStringBuffer.toString().substring(n + 1).trim();
            }
            if (!XMLChar.isValidNCName(string)) {
                this.grumble("Invalid processing instruction name " + Err.wrap(string));
            }
            ProcessingInstruction processingInstruction = new ProcessingInstruction(new StringValue(string));
            processingInstruction.setSelect(new StringValue(string2));
            this.setLocation(processingInstruction);
            return processingInstruction;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing '?>' found for processing instruction");
            return null;
        }
    }

    private void readCDATASection(FastStringBuffer fastStringBuffer) throws StaticError {
        try {
            char c = this.t.nextChar();
            this.expectChar(c, 'C');
            c = this.t.nextChar();
            this.expectChar(c, 'D');
            c = this.t.nextChar();
            this.expectChar(c, 'A');
            c = this.t.nextChar();
            this.expectChar(c, 'T');
            c = this.t.nextChar();
            this.expectChar(c, 'A');
            c = this.t.nextChar();
            this.expectChar(c, '[');
            while (!fastStringBuffer.toString().endsWith("]]>")) {
                fastStringBuffer.append(this.t.nextChar());
            }
            fastStringBuffer.setLength(fastStringBuffer.length() - 3);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing ']]>' found for CDATA section");
        }
    }

    private Expression parseCommentConstructor() throws StaticError {
        try {
            char c = this.t.nextChar();
            this.expectChar(c, '-');
            FastStringBuffer fastStringBuffer = new FastStringBuffer(240);
            while (!fastStringBuffer.toString().endsWith("--")) {
                fastStringBuffer.append(this.t.nextChar());
            }
            if (this.t.nextChar() != '>') {
                this.grumble("'--' is not permitted in an XML comment");
            }
            CharSequence charSequence = fastStringBuffer.subSequence(0, fastStringBuffer.length() - 2);
            Comment comment = new Comment();
            comment.setSelect(new StringValue(charSequence));
            this.setLocation(comment);
            return comment;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing '-->' found for comment constructor");
            return null;
        }
    }

    private Expression stringify(Expression expression) {
        return new QuerySimpleContentConstructor(expression, StringValue.SINGLE_SPACE);
    }

    protected StringValue makeStringLiteral(String string) throws StaticError {
        if (string.indexOf(38) == -1) {
            return new StringValue(string);
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(80);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                int n = string.indexOf(59, i);
                if (n < 0) {
                    this.grumble("No closing ';' found for entity or character reference");
                    continue;
                }
                String string2 = string.substring(i + 1, n);
                fastStringBuffer.append(this.analyzeEntityReference(string2));
                i = n;
                continue;
            }
            fastStringBuffer.append(c);
        }
        return new StringValue(fastStringBuffer);
    }

    private String readEntityReference() throws StaticError {
        try {
            char c;
            FastStringBuffer fastStringBuffer = new FastStringBuffer(40);
            while ((c = this.t.nextChar()) != ';') {
                fastStringBuffer.append(c);
            }
            String string = fastStringBuffer.toString();
            return this.analyzeEntityReference(string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.grumble("No closing ';' found for entity or character reference");
            return null;
        }
    }

    private String analyzeEntityReference(String string) throws StaticError {
        if ("lt".equals(string)) {
            return "<";
        }
        if ("gt".equals(string)) {
            return ">";
        }
        if ("amp".equals(string)) {
            return "&";
        }
        if ("quot".equals(string)) {
            return "\"";
        }
        if ("apos".equals(string)) {
            return "'";
        }
        if (string.length() < 2 || string.charAt(0) != '#') {
            this.grumble("invalid entity reference &" + string + ';');
            return null;
        }
        string = string.toLowerCase();
        return this.parseCharacterReference(string);
    }

    private String parseCharacterReference(String string) throws StaticError {
        int n = 0;
        if (string.charAt(1) == 'x') {
            for (int i = 2; i < string.length(); ++i) {
                int n2 = "0123456789abcdef".indexOf(string.charAt(i));
                if (n2 < 0) {
                    this.grumble("invalid character '" + string.charAt(i) + "' in hex character reference");
                }
                n = n * 16 + n2;
            }
        } else {
            for (int i = 1; i < string.length(); ++i) {
                int n3 = "0123456789".indexOf(string.charAt(i));
                if (n3 < 0) {
                    this.grumble("invalid character '" + string.charAt(i) + "' in decimal character reference");
                }
                n = n * 10 + n3;
            }
        }
        if (n < 32 && n != 10 && n != 9 && n != 13 || n >= 55296 && n <= 57343 || n == 65534 || n == 65535 || n > 0x10FFFF) {
            this.grumble("Invalid XML character reference x" + Integer.toHexString(n));
        }
        if (n <= 65535) {
            return "" + (char)n;
        }
        if (n <= 0x10FFFF) {
            return "" + (char)(0xD800 | (n -= 65536) >> 10) + (char)(0xDC00 | n & 0x3FF);
        }
        this.grumble("Character reference x" + Integer.toHexString(n) + " is too large");
        return null;
    }

    private void lookAhead() throws StaticError {
        try {
            this.t.lookAhead();
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
    }

    private char skipSpaces(char c) {
        while (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
            c = this.t.nextChar();
        }
        return c;
    }

    private void expectChar(char c, char c2) throws StaticError {
        if (c != c2) {
            this.grumble("Expected '" + c2 + "', found '" + c + '\'');
        }
    }

    protected String getLanguage() {
        return "XQuery";
    }

    private static class AttributeDetails {
        String value;
        int startOffset;

        private AttributeDetails() {
        }
    }

    private static class SortSpec {
        public Expression sortKey;
        public boolean ascending;
        public boolean emptyLeast;
        public String collation;

        private SortSpec() {
        }
    }

    private static class LetClause {
        public RangeVariableDeclaration variable;
        public Expression value;
        public int offset;

        private LetClause() {
        }
    }
}

