/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.DocumentSender;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ResultWrapper;
import net.sf.saxon.event.SequenceCopier;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.SequenceWrapper;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;

public class QueryResult {
    public static String RESULT_NS = "http://saxon.sf.net/xquery-results";

    private QueryResult() {
    }

    public static DocumentInfo wrap(SequenceIterator sequenceIterator, Configuration configuration) throws XPathException {
        PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
        TinyBuilder tinyBuilder = new TinyBuilder();
        NamespaceReducer namespaceReducer = new NamespaceReducer();
        namespaceReducer.setUnderlyingReceiver(tinyBuilder);
        NamespaceReducer namespaceReducer2 = namespaceReducer;
        namespaceReducer2.setPipelineConfiguration(pipelineConfiguration);
        tinyBuilder.setPipelineConfiguration(pipelineConfiguration);
        QueryResult.sendWrappedSequence(sequenceIterator, namespaceReducer2);
        return (DocumentInfo)tinyBuilder.getCurrentRoot();
    }

    public static void sendWrappedSequence(SequenceIterator sequenceIterator, Receiver receiver) throws XPathException {
        SequenceCopier.copySequence(sequenceIterator, new SequenceWrapper(receiver));
    }

    public static void sendWrappedSequenceOLD(SequenceIterator sequenceIterator, Receiver receiver) throws XPathException {
        Item item;
        NamePool namePool = receiver.getPipelineConfiguration().getConfiguration().getNamePool();
        receiver.open();
        receiver.startDocument(0);
        int n = namePool.allocate("result", RESULT_NS, "sequence");
        int n2 = namePool.allocate("result", RESULT_NS, "document");
        int n3 = namePool.allocate("result", RESULT_NS, "element");
        int n4 = namePool.allocate("result", RESULT_NS, "attribute");
        int n5 = namePool.allocate("result", RESULT_NS, "text");
        int n6 = namePool.allocate("result", RESULT_NS, "comment");
        int n7 = namePool.allocate("result", RESULT_NS, "processing-instruction");
        int n8 = namePool.allocate("result", RESULT_NS, "namespace");
        int n9 = namePool.allocate("result", RESULT_NS, "atomic-value");
        int n10 = namePool.allocate("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type");
        receiver.startElement(n, -1, 0, 0);
        receiver.namespace(namePool.allocateNamespaceCode("result", RESULT_NS), 0);
        receiver.namespace(namePool.allocateNamespaceCode("xs", "http://www.w3.org/2001/XMLSchema"), 0);
        receiver.namespace(namePool.allocateNamespaceCode("xsi", "http://www.w3.org/2001/XMLSchema-instance"), 0);
        receiver.startContent();
        while ((item = sequenceIterator.next()) != null) {
            if (item instanceof NodeInfo) {
                switch (((NodeInfo)item).getNodeKind()) {
                    case 9: {
                        receiver.startElement(n2, -1, 0, 0);
                        receiver.startContent();
                        ((DocumentInfo)item).copy(receiver, 2, true, 0);
                        receiver.endElement();
                        break;
                    }
                    case 1: {
                        receiver.startElement(n3, -1, 0, 0);
                        receiver.startContent();
                        ((NodeInfo)item).copy(receiver, 2, true, 0);
                        receiver.endElement();
                        break;
                    }
                    case 2: {
                        receiver.startElement(n4, -1, 0, 0);
                        ((NodeInfo)item).copy(receiver, 2, true, 0);
                        receiver.startContent();
                        receiver.endElement();
                        break;
                    }
                    case 3: {
                        receiver.startElement(n5, -1, 0, 0);
                        receiver.startContent();
                        ((NodeInfo)item).copy(receiver, 2, true, 0);
                        receiver.endElement();
                        break;
                    }
                    case 8: {
                        receiver.startElement(n6, -1, 0, 0);
                        receiver.startContent();
                        ((NodeInfo)item).copy(receiver, 2, true, 0);
                        receiver.endElement();
                        break;
                    }
                    case 7: {
                        receiver.startElement(n7, -1, 0, 0);
                        receiver.startContent();
                        ((NodeInfo)item).copy(receiver, 2, true, 0);
                        receiver.endElement();
                        break;
                    }
                    case 13: {
                        receiver.startElement(n8, -1, 0, 0);
                        ((NodeInfo)item).copy(receiver, 2, true, 0);
                        receiver.startContent();
                        receiver.endElement();
                    }
                }
                continue;
            }
            receiver.startElement(n9, -1, 0, 0);
            AtomicType atomicType = (AtomicType)((AtomicValue)item).getItemType();
            int n11 = atomicType.getNameCode();
            String string = namePool.getPrefix(n11);
            String string2 = namePool.getLocalName(n11);
            String string3 = namePool.getURI(n11);
            if (string.equals("") && (string = namePool.suggestPrefixForURI(string3)) == null) {
                string = "p" + string3.hashCode();
            }
            int n12 = namePool.allocateNamespaceCode(string, string3);
            String string4 = string + ':' + string2;
            receiver.namespace(n12, 0);
            receiver.attribute(n10, -1, string4, 0, 0);
            receiver.startContent();
            receiver.characters(item.getStringValue(), 0, 0);
            receiver.endElement();
        }
        receiver.endElement();
        receiver.endDocument();
        receiver.close();
    }

    public static void serialize(NodeInfo nodeInfo, Result result, Properties properties, Configuration configuration) throws XPathException {
        PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
        int n = nodeInfo.getNodeKind();
        if (n != 9 && n != 1) {
            throw new DynamicError("Node to be serialized must be a Document or Element node");
        }
        DocumentSender documentSender = new DocumentSender(nodeInfo);
        Receiver receiver = ResultWrapper.getReceiver(result, pipelineConfiguration, properties);
        NamespaceReducer namespaceReducer = new NamespaceReducer();
        namespaceReducer.setUnderlyingReceiver(receiver);
        namespaceReducer.setPipelineConfiguration(pipelineConfiguration);
        documentSender.send(namespaceReducer);
    }

    public static void serializeSequence(SequenceIterator sequenceIterator, Configuration configuration, OutputStream outputStream, Properties properties) throws XPathException {
        Item item;
        PrintWriter printWriter;
        String string = properties.getProperty("encoding");
        if (string == null) {
            string = "UTF-8";
        }
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DynamicError(unsupportedEncodingException);
        }
        block8: while ((item = sequenceIterator.next()) != null) {
            if (item instanceof NodeInfo) {
                switch (((NodeInfo)item).getNodeKind()) {
                    case 1: 
                    case 9: {
                        QueryResult.serialize((NodeInfo)item, new StreamResult(printWriter), properties, configuration);
                        printWriter.println("");
                        continue block8;
                    }
                    case 2: {
                        printWriter.println(((NodeInfo)item).getLocalPart() + "=\"" + item.getStringValue() + '\"');
                        continue block8;
                    }
                    case 8: {
                        printWriter.println("<!--" + item.getStringValue() + "-->");
                        continue block8;
                    }
                    case 7: {
                        printWriter.println("<?" + ((NodeInfo)item).getLocalPart() + ' ' + item.getStringValue() + "?>");
                        continue block8;
                    }
                }
                printWriter.println(item.getStringValue());
                continue;
            }
            if (item instanceof QNameValue) {
                printWriter.println(((QNameValue)item).getClarkName());
                continue;
            }
            printWriter.println(item.getStringValue());
        }
        printWriter.flush();
    }
}

