/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.SavedNamespaceContext;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollationFactory;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.SchemaType;
import org.xml.sax.SAXParseException;

public class StaticQueryContext
implements StaticContext {
    private Configuration config;
    private NamePool namePool;
    private HashMap passiveNamespaces;
    private HashSet explicitPrologNamespaces;
    private Stack activeNamespaces;
    private boolean inheritNamespaces = true;
    private boolean preserveNamespaces = true;
    private HashMap collations;
    private HashMap variables;
    private List variableList;
    private HashSet importedSchemata;
    private String defaultCollationName;
    private String defaultFunctionNamespace;
    private short defaultElementNamespace;
    private String baseURI;
    private SlotManager stackFrameMap;
    private String moduleNamespace;
    private short moduleNamespaceURICode;
    private int constructionMode;
    private Executable executable;
    private StaticQueryContext importer;
    private FunctionLibraryList functionLibraryList;
    private XQueryFunctionLibrary functions;

    private StaticQueryContext() {
    }

    public StaticQueryContext(Configuration configuration) {
        this.config = configuration;
        this.namePool = configuration.getNamePool();
        this.reset();
    }

    public void reset() {
        this.passiveNamespaces = new HashMap(10);
        this.explicitPrologNamespaces = new HashSet(10);
        this.activeNamespaces = new Stack();
        this.collations = new HashMap(5);
        this.variables = new HashMap(40);
        this.variableList = new ArrayList(40);
        this.functions = new XQueryFunctionLibrary(this.config, true);
        this.importedSchemata = new HashSet(5);
        this.defaultFunctionNamespace = "http://www.w3.org/2005/04/xpath-functions";
        this.defaultElementNamespace = 0;
        this.moduleNamespace = null;
        this.moduleNamespaceURICode = 0;
        this.constructionMode = 3;
        this.defaultCollationName = "http://www.w3.org/2005/04/xpath-functions/collation/codepoint";
        this.declareCollation(this.defaultCollationName, CodepointCollator.getInstance());
        this.functionLibraryList = new FunctionLibraryList();
        this.functionLibraryList.addFunctionLibrary(new SystemFunctionLibrary(0));
        this.functionLibraryList.addFunctionLibrary(this.config.getVendorFunctionLibrary());
        this.functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(this.config));
        if (this.config.isAllowExternalFunctions()) {
            this.functionLibraryList.addFunctionLibrary(this.config.getExtensionBinder());
        }
        this.functionLibraryList.addFunctionLibrary(this.functions);
        this.clearPassiveNamespaces();
    }

    public StaticQueryContext copy() {
        StaticQueryContext staticQueryContext = new StaticQueryContext();
        staticQueryContext.config = this.config;
        staticQueryContext.namePool = this.namePool;
        staticQueryContext.passiveNamespaces = new HashMap(this.passiveNamespaces);
        staticQueryContext.explicitPrologNamespaces = new HashSet(this.explicitPrologNamespaces);
        staticQueryContext.activeNamespaces = new Stack();
        staticQueryContext.inheritNamespaces = this.inheritNamespaces;
        staticQueryContext.preserveNamespaces = this.preserveNamespaces;
        staticQueryContext.collations = new HashMap(this.collations);
        staticQueryContext.variables = new HashMap(this.variables);
        staticQueryContext.variableList = new ArrayList(this.variableList);
        staticQueryContext.importedSchemata = new HashSet(this.importedSchemata);
        staticQueryContext.defaultCollationName = this.defaultCollationName;
        staticQueryContext.defaultFunctionNamespace = this.defaultFunctionNamespace;
        staticQueryContext.defaultElementNamespace = this.defaultElementNamespace;
        staticQueryContext.baseURI = this.baseURI;
        staticQueryContext.stackFrameMap = this.stackFrameMap;
        staticQueryContext.moduleNamespace = this.moduleNamespace;
        staticQueryContext.moduleNamespaceURICode = this.moduleNamespaceURICode;
        staticQueryContext.constructionMode = this.constructionMode;
        staticQueryContext.executable = this.executable;
        staticQueryContext.importer = this.importer;
        staticQueryContext.functionLibraryList = (FunctionLibraryList)this.functionLibraryList.copy();
        List list = staticQueryContext.functionLibraryList.getLibraryList();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof XQueryFunctionLibrary)) continue;
            staticQueryContext.functions = (XQueryFunctionLibrary)list.get(i);
            break;
        }
        return staticQueryContext;
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public DocumentInfo buildDocument(Source source) throws XPathException {
        AllElementStripper allElementStripper = null;
        if (this.config.isStripsAllWhiteSpace()) {
            allElementStripper = AllElementStripper.getInstance();
            allElementStripper.setStripAll();
        }
        try {
            NodeInfo nodeInfo = Builder.build(source, allElementStripper, this.config);
            return nodeInfo.getDocumentRoot();
        }
        catch (XPathException xPathException) {
            XPathException xPathException2;
            Throwable throwable = xPathException.getException();
            if (throwable != null && throwable instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                if ((throwable = sAXParseException.getException()) instanceof RuntimeException) {
                    try {
                        this.config.getErrorListener().fatalError(xPathException);
                    }
                    catch (TransformerException transformerException) {}
                }
            } else {
                while (xPathException2.getException() instanceof XPathException) {
                    xPathException2 = (XPathException)xPathException2.getException();
                }
                try {
                    this.config.getErrorListener().fatalError(xPathException2);
                }
                catch (TransformerException transformerException) {
                    // empty catch block
                }
            }
            throw xPathException2;
        }
    }

    public XQueryExpression compileQuery(String string) throws XPathException {
        QueryParser queryParser = new QueryParser();
        XQueryExpression xQueryExpression = queryParser.makeXQueryExpression(string, this.copy(), this.config);
        return xQueryExpression;
    }

    public XQueryExpression compileQuery(Reader reader) throws XPathException, IOException {
        int n;
        char[] cArray = new char[4096];
        StringBuffer stringBuffer = new StringBuffer(4096);
        while ((n = reader.read(cArray)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return this.compileQuery(stringBuffer.toString());
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public LocationMap getLocationMap() {
        return this.executable.getLocationMap();
    }

    public void declarePassiveNamespace(String string, String string2, boolean bl) throws StaticError {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declarePassiveNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declarePassiveNamespace()");
        }
        if (bl) {
            if (this.explicitPrologNamespaces.contains(string)) {
                StaticError staticError = new StaticError("Duplicate declaration of namespace prefix \"" + string + '\"');
                staticError.setErrorCode("XQST0033");
                throw staticError;
            }
            this.explicitPrologNamespaces.add(string);
        }
        this.passiveNamespaces.put(string, string2);
        this.namePool.allocateNamespaceCode(string, string2);
    }

    public void declareActiveNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declareActiveNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declareActiveNamespace()");
        }
        int n = this.namePool.allocateNamespaceCode(string, string2);
        ActiveNamespace activeNamespace = new ActiveNamespace();
        activeNamespace.prefix = string;
        activeNamespace.uri = string2;
        activeNamespace.code = n;
        this.activeNamespaces.push(activeNamespace);
        if (string.equals("")) {
            this.defaultElementNamespace = (short)(n & 0xFFFF);
        }
    }

    public void undeclareNamespace() {
        ActiveNamespace activeNamespace = (ActiveNamespace)this.activeNamespaces.pop();
        if (activeNamespace.prefix.equals("")) {
            for (int i = this.activeNamespaces.size() - 1; i >= 0; --i) {
                if (!((ActiveNamespace)this.activeNamespaces.get((int)i)).prefix.equals("")) continue;
                this.defaultElementNamespace = (short)(((ActiveNamespace)this.activeNamespaces.get((int)i)).code & 0xFFFF);
                return;
            }
            String string = (String)this.passiveNamespaces.get("");
            this.defaultElementNamespace = "".equals(string) ? (short)0 : this.getNamePool().getCodeForURI(string);
        }
    }

    public void clearPassiveNamespaces() {
        try {
            if (this.passiveNamespaces != null) {
                this.passiveNamespaces.clear();
                this.declarePassiveNamespace("xml", "http://www.w3.org/XML/1998/namespace", false);
                this.declarePassiveNamespace("saxon", "http://saxon.sf.net/", false);
                this.declarePassiveNamespace("xs", "http://www.w3.org/2001/XMLSchema", false);
                this.declarePassiveNamespace("fn", "http://www.w3.org/2005/04/xpath-functions", false);
                this.declarePassiveNamespace("xdt", "http://www.w3.org/2005/04/xpath-datatypes", false);
                this.declarePassiveNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance", false);
                this.declarePassiveNamespace("local", "http://www.w3.org/2005/02/xquery-local-functions", false);
                this.declarePassiveNamespace("", "", false);
            }
        }
        catch (StaticError staticError) {
            throw new IllegalStateException("Internal Failure initializing namespace declarations");
        }
    }

    public String getURIForPrefix(String string) throws XPathException {
        String string2 = this.checkURIForPrefix(string);
        if (string2 == null) {
            throw new StaticError("Prefix " + string + " has not been declared");
        }
        return string2;
    }

    public String checkURIForPrefix(String string) {
        for (int i = this.activeNamespaces.size() - 1; i >= 0; --i) {
            if (!((ActiveNamespace)this.activeNamespaces.get((int)i)).prefix.equals(string)) continue;
            return ((ActiveNamespace)this.activeNamespaces.get((int)i)).uri;
        }
        return (String)this.passiveNamespaces.get(string);
    }

    public int[] getActiveNamespaceCodes() {
        int[] nArray = new int[this.activeNamespaces.size()];
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>(10);
        for (int i = this.activeNamespaces.size() - 1; i >= 0; --i) {
            ActiveNamespace activeNamespace = (ActiveNamespace)this.activeNamespaces.get(i);
            if (hashSet.contains(activeNamespace.prefix)) continue;
            hashSet.add(activeNamespace.prefix);
            nArray[n++] = activeNamespace.code;
        }
        if (n < nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public NamespaceResolver getNamespaceResolver() {
        int[] nArray = this.getActiveNamespaceCodes();
        int[] nArray2 = new int[this.passiveNamespaces.size() + nArray.length];
        int n = 0;
        Iterator iterator = this.passiveNamespaces.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.passiveNamespaces.get(string);
            nArray2[n++] = this.namePool.getNamespaceCode(string, string2);
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[n++] = nArray[i];
        }
        return new SavedNamespaceContext(nArray2, this.namePool);
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String string) {
        this.defaultFunctionNamespace = string;
    }

    public void setDefaultElementNamespace(String string) throws StaticError {
        int n = this.namePool.allocateNamespaceCode("", string);
        this.defaultElementNamespace = (short)(n & 0xFFFF);
        this.declarePassiveNamespace("", string, true);
    }

    public short getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setModuleNamespace(String string) {
        this.moduleNamespace = string;
        this.moduleNamespaceURICode = this.namePool.getCodeForURI(string);
    }

    public String getModuleNamespace() {
        return this.moduleNamespace;
    }

    public short getModuleNamespaceCode() {
        return this.moduleNamespaceURICode;
    }

    public void setInheritNamespaces(boolean bl) {
        this.inheritNamespaces = bl;
    }

    public boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    public void setPreserveNamespaces(boolean bl) {
        this.preserveNamespaces = bl;
    }

    public boolean isPreserveNamespaces() {
        return this.preserveNamespaces;
    }

    public void declareCollation(String string, Comparator comparator) {
        this.collations.put(string, comparator);
    }

    public void declareDefaultCollation(String string) throws XPathException {
        Comparator comparator = this.getCollation(string);
        if (comparator == null) {
            throw new StaticError("Collation " + string + " is not recognized");
        }
        this.defaultCollationName = string;
    }

    public Comparator getCollation(String string) {
        Comparator comparator = (Comparator)this.collations.get(string);
        if (comparator != null) {
            return comparator;
        }
        try {
            return CollationFactory.makeCollationFromURI(string, this.config);
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    public String getDefaultCollationName() {
        if (this.defaultCollationName != null) {
            return this.defaultCollationName;
        }
        return "http://www.w3.org/2005/04/xpath-functions/collation/codepoint";
    }

    public HashMap getAllCollations() {
        return new HashMap(this.collations);
    }

    public SlotManager getGlobalStackFrameMap() {
        return this.executable.getGlobalVariableMap();
    }

    public void declareVariable(VariableDeclaration variableDeclaration) throws StaticError {
        int n = variableDeclaration.getNameCode() & 0xFFFFF;
        Integer n2 = new Integer(n);
        if (this.variables.get(n2) != null) {
            StaticError staticError = new StaticError("Duplicate definition of global variable " + variableDeclaration.getVariableName());
            staticError.setErrorCode("XQST0049");
            throw staticError;
        }
        this.variables.put(n2, variableDeclaration);
        this.variableList.add(variableDeclaration);
    }

    public void fixupGlobalVariables(SlotManager slotManager) throws StaticError {
        Iterator iterator = this.variableList.iterator();
        while (iterator.hasNext()) {
            GlobalVariableDefinition globalVariableDefinition = (GlobalVariableDefinition)iterator.next();
            try {
                int n = slotManager.allocateSlotNumber(globalVariableDefinition.getNameCode() & 0xFFFFF);
                globalVariableDefinition.compile(this, n);
            }
            catch (XPathException xPathException) {
                if (xPathException instanceof StaticError) {
                    throw (StaticError)xPathException;
                }
                throw new StaticError(xPathException);
            }
        }
    }

    public void explainGlobalVariables() {
        Iterator iterator = this.variableList.iterator();
        while (iterator.hasNext()) {
            GlobalVariableDefinition globalVariableDefinition = (GlobalVariableDefinition)iterator.next();
            globalVariableDefinition.explain(this.getNamePool());
        }
    }

    public Iterator getVariableDeclarations() {
        return this.variableList.iterator();
    }

    public SlotManager getStackFrameMap() {
        if (this.stackFrameMap == null) {
            this.stackFrameMap = this.getConfiguration().makeSlotManager();
        }
        return this.stackFrameMap;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void issueWarning(String string, SourceLocator sourceLocator) {
        StaticError staticError = new StaticError(string);
        staticError.setLocator(sourceLocator);
        try {
            this.config.getErrorListener().warning(staticError);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getSystemId() {
        return this.baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public VariableDeclaration bindVariable(int n) throws StaticError {
        VariableDeclaration variableDeclaration = (VariableDeclaration)this.variables.get(new Integer(n));
        if (variableDeclaration == null) {
            throw new StaticError("Undeclared variable in query");
        }
        return variableDeclaration;
    }

    public void setFunctionLibraryList(FunctionLibraryList functionLibraryList) {
        this.functionLibraryList = functionLibraryList;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibraryList;
    }

    public void declareFunction(XQueryFunction xQueryFunction) throws StaticError {
        SchemaType schemaType;
        if (xQueryFunction.getNumberOfArguments() == 1 && (schemaType = this.config.getSchemaType(xQueryFunction.getNameCode() & 0xFFFFF)) != null && schemaType instanceof AtomicType) {
            StaticError staticError = new StaticError("Function name " + xQueryFunction.getFunctionDisplayName(this.getNamePool()) + " clashes with the name of the constructor function for an atomic type");
            staticError.setErrorCode("XQST0034");
            throw staticError;
        }
        this.functions.declareFunction(xQueryFunction);
    }

    protected void bindUnboundFunctionCalls() throws StaticError {
        this.functions.bindUnboundFunctionCalls();
    }

    public Iterator getFunctionDefinitions() {
        return this.functions.getFunctionDefinitions();
    }

    protected void fixupGlobalFunctions() throws XPathException {
        this.functions.fixupGlobalFunctions(this);
    }

    public void explainGlobalFunctions() throws XPathException {
        this.functions.explainGlobalFunctions();
    }

    public UserFunction getUserDefinedFunction(String string, String string2, int n) {
        return this.functions.getUserDefinedFunction(string, string2, n);
    }

    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    public void addImportedSchema(String string) {
        if (this.importedSchemata == null) {
            this.importedSchemata = new HashSet(5);
        }
        this.importedSchemata.add(string);
    }

    public boolean isImportedSchema(String string) {
        if (this.importedSchemata == null) {
            return false;
        }
        return this.importedSchemata.contains(string);
    }

    public boolean isAllowedBuiltInType(AtomicType atomicType) {
        return true;
    }

    public void setConstructionMode(int n) {
        this.constructionMode = n;
    }

    public int getConstructionMode() {
        return this.constructionMode;
    }

    protected StaticQueryContext loadModule(String string, String string2) throws StaticError {
        StaticQueryContext staticQueryContext = this.importer;
        while (staticQueryContext != null) {
            if (string.equals(staticQueryContext.moduleNamespace)) {
                StaticError staticError = new StaticError("A module cannot import itself directly or indirectly");
                staticError.setErrorCode("XQST0073");
                throw staticError;
            }
            staticQueryContext = staticQueryContext.importer;
        }
        return StaticQueryContext.loadQueryModule(this.config, this.executable, this.baseURI, string, string2, this);
    }

    public static StaticQueryContext loadQueryModule(Configuration configuration, Executable executable, String string, String string2, String string3, StaticQueryContext staticQueryContext) throws StaticError {
        URL uRL;
        if (string3 == null) {
            throw new StaticError("import module must either specify a known namespace or a location");
        }
        if (string == null) {
            try {
                uRL = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                throw new StaticError("Cannot resolve URI (no base URI available)", malformedURLException);
            }
        }
        try {
            uRL = new URL(new URL(string), string3);
        }
        catch (MalformedURLException malformedURLException) {
            throw new StaticError("Cannot resolve relative URI", malformedURLException);
        }
        try {
            int n;
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer(2048);
            char[] cArray = new char[2048];
            while ((n = bufferedReader.read(cArray, 0, 2048)) >= 0) {
                stringBuffer.append(cArray, 0, n);
            }
            bufferedReader.close();
            inputStream.close();
            StaticQueryContext staticQueryContext2 = new StaticQueryContext(configuration);
            staticQueryContext2.setBaseURI(uRL.toString());
            staticQueryContext2.setExecutable(executable);
            staticQueryContext2.importer = staticQueryContext;
            QueryParser queryParser = new QueryParser();
            queryParser.parseLibraryModule(stringBuffer.toString(), staticQueryContext2);
            if (staticQueryContext2.getModuleNamespace() == null) {
                throw new StaticError("Imported module must be a library module");
            }
            if (!staticQueryContext2.getModuleNamespace().equals(string2)) {
                throw new StaticError("Imported module's namespace does not match requested namespace");
            }
            executable.addQueryLibraryModule(staticQueryContext2);
            return staticQueryContext2;
        }
        catch (IOException iOException) {
            throw new StaticError(iOException);
        }
    }

    private static class ActiveNamespace {
        public String prefix;
        public String uri;
        public int code;

        private ActiveNamespace() {
        }
    }
}

