/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;

public class XQueryFunctionLibrary
implements FunctionLibrary {
    private Configuration config;
    private HashMap functions = new HashMap(20);
    private List unboundFunctionCalls = new ArrayList(20);
    private boolean allowForwardsReferences = false;

    public XQueryFunctionLibrary(Configuration configuration, boolean bl) {
        this.config = configuration;
        this.allowForwardsReferences = bl;
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    private NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public void setAllowForwardsReferences(boolean bl) {
        this.allowForwardsReferences = bl;
    }

    public void declareFunction(XQueryFunction xQueryFunction) throws StaticError {
        int n;
        int n2 = xQueryFunction.getFunctionFingerprint();
        Long l = XQueryFunctionLibrary.functionKey(n2, n = xQueryFunction.getNumberOfArguments());
        if (this.functions.get(l) != null) {
            StaticError staticError = new StaticError("Duplicate definition of function " + this.getNamePool().getDisplayName(n2));
            staticError.setErrorCode("XQST0034");
            throw staticError;
        }
        this.functions.put(l, xQueryFunction);
    }

    private static Long functionKey(int n, int n2) {
        return new Long(((long)n2 << 32) + (long)n);
    }

    public boolean isAvailable(int n, String string, String string2, int n2) {
        if (n2 == -1) {
            for (int i = 0; i < 20; ++i) {
                if (!this.isAvailable(n, string, string2, i)) continue;
                return true;
            }
            return false;
        }
        return this.functions.get(XQueryFunctionLibrary.functionKey(n, n2)) != null;
    }

    public Expression bind(int n, String string, String string2, Expression[] expressionArray) throws XPathException {
        int n2 = this.getNamePool().allocate("", string, string2) & 0xFFFFF;
        XQueryFunction xQueryFunction = (XQueryFunction)this.functions.get(XQueryFunctionLibrary.functionKey(n2, expressionArray.length));
        if (xQueryFunction != null) {
            UserFunctionCall userFunctionCall = new UserFunctionCall();
            userFunctionCall.setFunctionNameCode(n);
            userFunctionCall.setArguments(expressionArray);
            userFunctionCall.setStaticType(xQueryFunction.getResultType());
            UserFunction userFunction = xQueryFunction.getUserFunction();
            if (userFunction == null) {
                xQueryFunction.registerReference(userFunctionCall);
                userFunctionCall.setConfirmed(true);
            } else {
                userFunctionCall.setFunction(userFunction, xQueryFunction.getStaticContext());
                userFunctionCall.checkFunctionCall(userFunction, xQueryFunction.getStaticContext());
            }
            return userFunctionCall;
        }
        if (this.allowForwardsReferences) {
            UserFunctionCall userFunctionCall = new UserFunctionCall();
            userFunctionCall.setFunctionNameCode(n);
            userFunctionCall.setArguments(expressionArray);
            this.unboundFunctionCalls.add(userFunctionCall);
            return userFunctionCall;
        }
        return null;
    }

    public void bindUnboundFunctionCalls() throws StaticError {
        Iterator iterator = this.unboundFunctionCalls.iterator();
        while (iterator.hasNext()) {
            int n;
            UserFunctionCall userFunctionCall = (UserFunctionCall)iterator.next();
            int n2 = userFunctionCall.getFunctionNameCode() & 0xFFFFF;
            XQueryFunction xQueryFunction = (XQueryFunction)this.functions.get(XQueryFunctionLibrary.functionKey(n2, n = userFunctionCall.getNumberOfArguments()));
            if (xQueryFunction != null) {
                userFunctionCall.setStaticType(xQueryFunction.getResultType());
                xQueryFunction.registerReference(userFunctionCall);
                continue;
            }
            StaticError staticError = new StaticError("Function " + this.getNamePool().getDisplayName(userFunctionCall.getFunctionNameCode()) + " has not been declared", ExpressionTool.getLocator(userFunctionCall));
            staticError.setErrorCode("XPST0017");
            throw staticError;
        }
    }

    public Iterator getFunctionDefinitions() {
        return this.functions.values().iterator();
    }

    protected void fixupGlobalFunctions(StaticQueryContext staticQueryContext) throws XPathException {
        XQueryFunction xQueryFunction;
        Iterator iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            xQueryFunction = (XQueryFunction)iterator.next();
            xQueryFunction.compile(staticQueryContext);
        }
        iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            xQueryFunction = (XQueryFunction)iterator.next();
            xQueryFunction.checkReferences(staticQueryContext);
        }
    }

    public void explainGlobalFunctions() throws XPathException {
        Iterator iterator = this.functions.values().iterator();
        while (iterator.hasNext()) {
            XQueryFunction xQueryFunction = (XQueryFunction)iterator.next();
            xQueryFunction.explain(this.getNamePool());
        }
    }

    public UserFunction getUserDefinedFunction(String string, String string2, int n) {
        int n2 = this.getNamePool().allocate("", string, string2) & 0xFFFFF;
        XQueryFunction xQueryFunction = (XQueryFunction)this.functions.get(XQueryFunctionLibrary.functionKey(n2, n));
        if (xQueryFunction == null) {
            return null;
        }
        return xQueryFunction.getUserFunction();
    }

    public FunctionLibrary copy() {
        XQueryFunctionLibrary xQueryFunctionLibrary = new XQueryFunctionLibrary(this.config, this.allowForwardsReferences);
        xQueryFunctionLibrary.functions = new HashMap(this.functions);
        xQueryFunctionLibrary.unboundFunctionCalls = new ArrayList(this.unboundFunctionCalls);
        return xQueryFunctionLibrary;
    }
}

