/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class GroupEndingIterator
implements GroupIterator {
    private SequenceIterator population;
    private Pattern endPattern;
    private XPathContext baseContext;
    private XPathContext runningContext;
    private List currentMembers;
    private Item next;
    private Item current = null;
    private int position = 0;

    public GroupEndingIterator(SequenceIterator sequenceIterator, Pattern pattern, XPathContext xPathContext) throws XPathException {
        this.population = sequenceIterator;
        this.endPattern = pattern;
        this.baseContext = xPathContext;
        this.runningContext = xPathContext.newMinorContext();
        this.runningContext.setCurrentIterator(sequenceIterator);
        this.next = sequenceIterator.next();
    }

    private void advance() throws XPathException {
        this.currentMembers = new ArrayList(20);
        this.currentMembers.add(this.current);
        this.next = this.current;
        while (this.next != null) {
            if (this.endPattern.matches((NodeInfo)this.next, this.runningContext)) {
                this.next = this.population.next();
                if (this.next == null) continue;
                break;
            }
            this.next = this.population.next();
            if (this.next == null) continue;
            this.currentMembers.add(this.next);
        }
    }

    public AtomicValue getCurrentGroupingKey() {
        return null;
    }

    public SequenceIterator iterateCurrentGroup() {
        return new ListIterator(this.currentMembers);
    }

    public Item next() throws XPathException {
        if (this.next != null) {
            this.current = this.next;
            ++this.position;
            this.advance();
            return this.current;
        }
        this.current = null;
        this.position = -1;
        return null;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new GroupEndingIterator(this.population.getAnother(), this.endPattern, this.baseContext);
    }
}

