/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.Comparator;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.GenericSorter;
import net.sf.saxon.sort.Sortable;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class SortedIterator
implements SequenceIterator,
LastPositionFinder,
Sortable {
    protected SequenceIterator base;
    protected FixedSortKeyDefinition[] sortkeys;
    protected int recordSize;
    protected Object[] nodeKeys;
    protected int count = -1;
    protected int index = 0;
    protected XPathContext context;
    private Comparator[] keyComparers;

    private SortedIterator() {
    }

    public SortedIterator(XPathContext xPathContext, SequenceIterator sequenceIterator, FixedSortKeyDefinition[] fixedSortKeyDefinitionArray) throws XPathException {
        this.context = xPathContext.newMinorContext();
        this.context.setOriginatingConstructType(2061);
        this.context.setCurrentIterator(sequenceIterator);
        this.base = sequenceIterator;
        this.sortkeys = fixedSortKeyDefinitionArray;
        this.recordSize = fixedSortKeyDefinitionArray.length + 2;
        this.keyComparers = new Comparator[fixedSortKeyDefinitionArray.length];
        for (int i = 0; i < fixedSortKeyDefinitionArray.length; ++i) {
            this.keyComparers[i] = fixedSortKeyDefinitionArray[i].getComparer(xPathContext);
        }
    }

    public Item next() throws XPathException {
        if (this.index < 0) {
            return null;
        }
        if (this.count < 0) {
            this.doSort();
        }
        if (this.index < this.count) {
            return (Item)this.nodeKeys[this.index++ * this.recordSize];
        }
        this.index = -1;
        return null;
    }

    public Item current() {
        if (this.index < 1) {
            return null;
        }
        return (Item)this.nodeKeys[(this.index - 1) * this.recordSize];
    }

    public int position() {
        return this.index;
    }

    public int getLastPosition() throws XPathException {
        if (this.count < 0) {
            this.doSort();
        }
        return this.count;
    }

    public SequenceIterator getAnother() throws XPathException {
        if (this.count < 0) {
            this.doSort();
        }
        SortedIterator sortedIterator = new SortedIterator();
        sortedIterator.base = this.base.getAnother();
        sortedIterator.sortkeys = this.sortkeys;
        sortedIterator.recordSize = this.recordSize;
        sortedIterator.nodeKeys = this.nodeKeys;
        sortedIterator.count = this.count;
        sortedIterator.context = this.context;
        sortedIterator.keyComparers = this.keyComparers;
        sortedIterator.index = 0;
        return sortedIterator;
    }

    protected void buildArray() throws XPathException {
        Item item;
        int n = this.base instanceof LastPositionFinder ? ((LastPositionFinder)this.base).getLastPosition() : 100;
        this.nodeKeys = new Object[n * this.recordSize];
        this.count = 0;
        XPathContext xPathContext = this.context;
        while ((item = this.base.next()) != null) {
            if (this.count == n) {
                Object[] objectArray = new Object[(n *= 2) * this.recordSize];
                System.arraycopy(this.nodeKeys, 0, objectArray, 0, this.count * this.recordSize);
                this.nodeKeys = objectArray;
            }
            int n2 = this.count * this.recordSize;
            this.nodeKeys[n2] = item;
            for (int i = 0; i < this.sortkeys.length; ++i) {
                this.nodeKeys[n2 + i + 1] = this.sortkeys[i].getSortKey().evaluateItem(xPathContext);
            }
            this.nodeKeys[n2 + this.sortkeys.length + 1] = new Integer(this.count);
            ++this.count;
        }
    }

    private void doSort() throws XPathException {
        this.buildArray();
        if (this.count < 2) {
            return;
        }
        try {
            GenericSorter.quickSort(0, this.count, this);
        }
        catch (ClassCastException classCastException) {
            DynamicError dynamicError = new DynamicError("Non-comparable types found while sorting: " + classCastException.getMessage());
            dynamicError.setErrorCode("XPTY0004");
            throw dynamicError;
        }
    }

    public int compare(int n, int n2) {
        int n3 = n * this.recordSize + 1;
        int n4 = n2 * this.recordSize + 1;
        for (int i = 0; i < this.sortkeys.length; ++i) {
            int n5 = this.nodeKeys[n3 + i] == null ? (this.nodeKeys[n4 + i] == null ? 0 : (this.sortkeys[i].getEmptyFirst() ? -1 : 1)) : (this.nodeKeys[n4 + i] == null ? (this.sortkeys[i].getEmptyFirst() ? 1 : -1) : this.keyComparers[i].compare(this.nodeKeys[n3 + i], this.nodeKeys[n4 + i]));
            if (n5 == 0) continue;
            return n5;
        }
        return (Integer)this.nodeKeys[n3 + this.sortkeys.length] - (Integer)this.nodeKeys[n4 + this.sortkeys.length];
    }

    public void swap(int n, int n2) {
        int n3 = n * this.recordSize;
        int n4 = n2 * this.recordSize;
        for (int i = 0; i < this.recordSize; ++i) {
            Object object = this.nodeKeys[n3 + i];
            this.nodeKeys[n3 + i] = this.nodeKeys[n4 + i];
            this.nodeKeys[n4 + i] = object;
        }
    }
}

