/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.Value;

public class TupleExpression
extends ComputedExpression {
    Expression[] components;
    static /* synthetic */ Class class$java$lang$Object;

    public TupleExpression(int n) {
        this.components = new Expression[n];
    }

    public void setExpression(int n, Expression expression) {
        this.components[n] = expression;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = this.components[i].simplify(staticContext);
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = this.components[i].promote(promotionOffer);
        }
        return this;
    }

    public ItemType getItemType() {
        return new ExternalObjectType(class$java$lang$Object == null ? (class$java$lang$Object = TupleExpression.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = this.components[i].analyze(staticContext, itemType);
        }
        return this;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "Tuple");
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].display(n + 1, namePool, printStream);
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Value[] valueArray = new Value[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            valueArray[i] = Value.asValue(ExpressionTool.lazyEvaluate(this.components[i], xPathContext, true));
        }
        return new ObjectValue(valueArray);
    }

    public int computeCardinality() {
        return 16384;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public Iterator iterateSubExpressions() {
        return Arrays.asList(this.components).iterator();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

