/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.SortedTupleIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.Value;

public class TupleSorter
extends ComputedExpression
implements MappingFunction {
    private Expression base;
    private FixedSortKeyDefinition[] sortKeys;

    public TupleSorter(Expression expression, FixedSortKeyDefinition[] fixedSortKeyDefinitionArray) {
        this.base = expression;
        this.sortKeys = fixedSortKeyDefinitionArray;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.base = this.base.simplify(staticContext);
        for (int i = 0; i < this.sortKeys.length; ++i) {
            this.sortKeys[i].setSortKey(this.sortKeys[i].getSortKey().simplify(staticContext));
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.base = this.base.analyze(staticContext, itemType);
        for (int i = 0; i < this.sortKeys.length; ++i) {
            this.sortKeys[i].setSortKey(this.sortKeys[i].getSortKey().analyze(staticContext, itemType));
        }
        return this;
    }

    public ItemType getItemType() {
        return AnyItemType.getInstance();
    }

    public int computeCardinality() {
        return 57344;
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(this.sortKeys.length + 1);
        arrayList.add(this.base);
        for (int i = 0; i < this.sortKeys.length; ++i) {
            arrayList.add(this.sortKeys[i].getSortKey());
        }
        return arrayList.iterator();
    }

    public boolean isSortKey(Expression expression) {
        for (int i = 0; i < this.sortKeys.length; ++i) {
            Expression expression2 = this.sortKeys[i].getSortKey();
            if (expression2 != expression) continue;
            return true;
        }
        return false;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.base = this.base.promote(promotionOffer);
        if (promotionOffer.action != 11) {
            for (int i = 0; i < this.sortKeys.length; ++i) {
                this.sortKeys[i].setSortKey(this.sortKeys[i].getSortKey().promote(promotionOffer));
            }
        }
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SortedTupleIterator sortedTupleIterator = new SortedTupleIterator(xPathContext, this.base.iterate(xPathContext), this.sortKeys);
        MappingIterator mappingIterator = new MappingIterator(sortedTupleIterator, this, xPathContext);
        return mappingIterator;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return this.base.effectiveBooleanValue(xPathContext);
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "TupleSorter");
        this.base.display(n + 1, namePool, printStream);
    }

    public Object map(Item item, XPathContext xPathContext) throws XPathException {
        ObjectValue objectValue = (ObjectValue)item;
        Object object = objectValue.getObject();
        if (object == null) {
            return object;
        }
        if (object instanceof Item) {
            return object;
        }
        Value value = (Value)object;
        return value.iterate(xPathContext);
    }
}

