/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Err;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.DeferredError;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.LocalVariable;
import net.sf.saxon.instruct.SavedNamespaceContext;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TraceExpression;
import net.sf.saxon.instruct.TraceInstruction;
import net.sf.saxon.instruct.TraceWrapper;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceConstant;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.ElementWithAttributes;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.ValidationErrorValue;
import org.xml.sax.Locator;

public abstract class StyleElement
extends ElementWithAttributes
implements Locator,
Container,
InstructionInfo {
    protected short[] extensionNamespaces = null;
    private short[] excludedNamespaces = null;
    protected BigDecimal version = null;
    protected StaticContext staticContext = null;
    protected StaticError validationError = null;
    protected int reportingCircumstances = 1;
    protected String defaultXPathNamespace = null;
    protected String defaultCollationName = null;
    private int lineNumber;
    private boolean explaining = false;
    private int objectNameCode = -1;
    public static final int REPORT_ALWAYS = 1;
    public static final int REPORT_UNLESS_FORWARDS_COMPATIBLE = 2;
    public static final int REPORT_IF_INSTANTIATED = 3;

    public Executable getExecutable() {
        return this.getPrincipalStylesheet().getExecutable();
    }

    public LocationProvider getLocationProvider() {
        return this.getExecutable().getLocationMap();
    }

    public NamePool getTargetNamePool() {
        return this.getPrincipalStylesheet().getTargetNamePool();
    }

    public StaticContext getStaticContext() {
        if (this.staticContext == null) {
            this.staticContext = new ExpressionContext(this);
        }
        return this.staticContext;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public void substituteFor(StyleElement styleElement) {
        this.parent = styleElement.parent;
        this.attributeList = styleElement.attributeList;
        this.namespaceList = styleElement.namespaceList;
        this.nameCode = styleElement.nameCode;
        this.sequence = styleElement.sequence;
        this.extensionNamespaces = styleElement.extensionNamespaces;
        this.excludedNamespaces = styleElement.excludedNamespaces;
        this.version = styleElement.version;
        this.root = styleElement.root;
        this.staticContext = styleElement.staticContext;
        this.validationError = styleElement.validationError;
        this.reportingCircumstances = styleElement.reportingCircumstances;
        this.lineNumber = styleElement.lineNumber;
    }

    protected void setValidationError(TransformerException transformerException, int n) {
        this.validationError = StaticError.makeStaticError(transformerException);
        this.reportingCircumstances = n;
    }

    public boolean isInstruction() {
        return false;
    }

    protected ItemType getReturnedItemType() {
        return AnyItemType.getInstance();
    }

    protected ItemType getCommonChildItemType() {
        ItemType itemType = NoNodeTest.getInstance();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        do {
            NodeInfo nodeInfo;
            if ((nodeInfo = (NodeInfo)axisIterator.next()) == null) {
                return itemType;
            }
            if (nodeInfo instanceof StyleElement) {
                ItemType itemType2 = ((StyleElement)nodeInfo).getReturnedItemType();
                if (itemType2 == null) continue;
                itemType = Type.getCommonSuperType(itemType, itemType2);
                continue;
            }
            itemType = Type.getCommonSuperType(itemType, NodeKindTest.TEXT);
        } while (itemType != AnyItemType.getInstance());
        return itemType;
    }

    public void markTailCalls() {
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public boolean mayContainFallback() {
        return this.mayContainSequenceConstructor();
    }

    public XSLStylesheet getContainingStylesheet() {
        NodeInfo nodeInfo = this;
        while (!(nodeInfo instanceof XSLStylesheet)) {
            nodeInfo = nodeInfo.getParent();
        }
        return (XSLStylesheet)nodeInfo;
    }

    public int getPrecedence() {
        return this.getContainingStylesheet().getPrecedence();
    }

    public final int makeNameCode(String string) throws XPathException, NamespaceException {
        String[] stringArray;
        NamePool namePool = this.getTargetNamePool();
        try {
            stringArray = Name.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            StaticError staticError = new StaticError(qNameException.getMessage());
            staticError.setErrorCode("XTSE0020");
            throw staticError;
        }
        String string2 = stringArray[0];
        if ("".equals(string2)) {
            return namePool.allocate(string2, (short)0, string);
        }
        String string3 = this.getURIForPrefix(string2, false);
        if (string3 == null) {
            throw new NamespaceException(string2);
        }
        if (NamespaceConstant.isReserved(string3)) {
            StaticError staticError = new StaticError("Namespace prefix " + string2 + " refers to a reserved namespace");
            staticError.setErrorCode("XTSE0080");
            throw staticError;
        }
        return namePool.allocate(string2, string3, stringArray[1]);
    }

    public SavedNamespaceContext makeNamespaceContext() {
        return new SavedNamespaceContext(this.getInScopeNamespaceCodes(), this.getNamePool());
    }

    public void processAllAttributes() throws XPathException {
        this.staticContext = new ExpressionContext(this);
        this.processAttributes();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).processAllAttributes();
        }
        return;
    }

    public String getAttributeValue(String string) {
        int n = this.getNamePool().allocateClarkName(string);
        return this.getAttributeValue(n);
    }

    public final void processAttributes() throws XPathException {
        try {
            this.prepareAttributes();
        }
        catch (XPathException xPathException) {
            if (this.forwardsCompatibleModeIsEnabled()) {
                this.setValidationError(xPathException, 3);
            }
            this.compileError(xPathException);
        }
    }

    protected void checkUnknownAttribute(int n) throws XPathException {
        String string = this.getNamePool().getURI(n);
        String string2 = this.getURI();
        String string3 = this.getNamePool().getClarkName(n);
        if (string3.equals("{http://saxon.sf.net/}explain")) {
            this.explaining = "yes".equals(this.getAttributeValue(n & 0xFFFFF));
        }
        if (this.forwardsCompatibleModeIsEnabled()) {
            return;
        }
        if (this.isInstruction() && string3.startsWith("{http://www.w3.org/1999/XSL/Transform") && !string2.equals("http://www.w3.org/1999/XSL/Transform") && (string3.endsWith("}default-collation") || string3.endsWith("}xpath-default-namespace") || string3.endsWith("}extension-element-prefixes") || string3.endsWith("}exclude-result-prefixes") || string3.endsWith("}version") || string3.endsWith("}use-when"))) {
            return;
        }
        if (string2.equals("http://www.w3.org/1999/XSL/Transform") && (string3 == "default-collation" || string3 == "xpath-default-namespace" || string3 == "extension-element-prefixes" || string3 == "exclude-result-prefixes" || string3 == "version" || string3 == "use-when")) {
            return;
        }
        if ("".equals(string) || "http://www.w3.org/1999/XSL/Transform".equals(string)) {
            this.compileError("Attribute " + Err.wrap(this.getNamePool().getDisplayName(n), 2) + " is not allowed on element " + Err.wrap(this.getDisplayName(), 1), "XTSE0010");
        }
    }

    public abstract void prepareAttributes() throws XPathException;

    protected StyleElement getLastChildInstruction() {
        StyleElement styleElement = null;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo instanceof StyleElement) {
                styleElement = (StyleElement)nodeInfo;
                continue;
            }
            styleElement = null;
        }
        return styleElement;
    }

    public Expression makeExpression(String string) throws XPathException {
        try {
            Expression expression = ExpressionTool.make(string, this.staticContext, 0, 0, this.getLineNumber());
            return expression;
        }
        catch (XPathException xPathException) {
            xPathException.setLocator(this);
            if (!this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(xPathException);
            } else if (xPathException.isTypeError()) {
                this.compileError(xPathException);
            }
            ErrorExpression errorExpression = new ErrorExpression(xPathException);
            errorExpression.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            errorExpression.setParentExpression(this);
            return errorExpression;
        }
    }

    public Pattern makePattern(String string) throws XPathException {
        try {
            return Pattern.make(string, this.staticContext, this.getPrincipalStylesheet().getExecutable());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return new NodeTestPattern(AnyNodeTest.getInstance());
        }
    }

    public Expression makeAttributeValueTemplate(String string) throws XPathException {
        try {
            return AttributeValueTemplate.make(string, this.getLineNumber(), this.staticContext);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return new StringValue(string);
        }
    }

    public SequenceType makeSequenceType(String string) throws XPathException {
        this.getStaticContext();
        try {
            ExpressionParser expressionParser = new ExpressionParser();
            return expressionParser.parseSequenceType(string, this.staticContext);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return SequenceType.ANY_SEQUENCE;
        }
    }

    protected void processExtensionElementAttribute(String string) throws XPathException {
        String string2 = this.getAttributeValue(string);
        if (string2 != null) {
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++n;
            }
            this.extensionNamespaces = new short[n];
            n = 0;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                if ("#default".equals(string3)) {
                    string3 = "";
                }
                try {
                    short s = this.getURICodeForPrefix(string3);
                    this.extensionNamespaces[n++] = s;
                }
                catch (NamespaceException namespaceException) {
                    this.extensionNamespaces = null;
                    this.compileError(namespaceException.getMessage(), "XT0280");
                }
            }
        }
    }

    protected void processExcludedNamespaces(String string) throws XPathException {
        block10: {
            String string2 = this.getAttributeValue(string);
            if (string2 == null) break block10;
            if ("#all".equals(string2.trim())) {
                int[] nArray = this.getInScopeNamespaceCodes();
                this.excludedNamespaces = new short[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    this.excludedNamespaces[i] = (short)(nArray[i] & 0xFFFF);
                }
            } else {
                int n = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    ++n;
                }
                this.excludedNamespaces = new short[n];
                n = 0;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
                while (stringTokenizer2.hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    if ("#default".equals(string3)) {
                        string3 = "";
                    } else if ("#all".equals(string3)) {
                        this.compileError("In exclude-result-prefixes, cannot mix #all with other values", "XTSE0020");
                    }
                    try {
                        short s = this.getURICodeForPrefix(string3);
                        this.excludedNamespaces[n++] = s;
                    }
                    catch (NamespaceException namespaceException) {
                        this.excludedNamespaces = null;
                        this.compileError(namespaceException.getMessage(), "XTSE0280");
                    }
                }
            }
        }
    }

    protected void processVersionAttribute(String string) throws XPathException {
        String string2 = this.getAttributeValue(string);
        if (string2 != null) {
            AtomicValue atomicValue = DecimalValue.makeDecimalValue(string2, true);
            if (atomicValue instanceof ValidationErrorValue) {
                this.compileError("The version attribute must be a decimal literal");
            }
            this.version = ((DecimalValue)atomicValue).getValue();
        }
    }

    public BigDecimal getVersion() {
        if (this.version == null) {
            NodeInfo nodeInfo = this.getParent();
            this.version = nodeInfo instanceof StyleElement ? ((StyleElement)nodeInfo).getVersion() : new BigDecimal("2.0");
        }
        return this.version;
    }

    public boolean forwardsCompatibleModeIsEnabled() {
        return this.getVersion().compareTo(BigDecimal.valueOf(2L)) > 0;
    }

    public boolean backwardsCompatibleModeIsEnabled() {
        return this.getVersion().compareTo(BigDecimal.valueOf(2L)) < 0;
    }

    protected void processDefaultCollationAttribute(String string) throws XPathException {
        String string2 = this.getAttributeValue(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("http://www.w3.org/2005/04/xpath-functions/collation/codepoint")) {
                    this.defaultCollationName = string3;
                    return;
                }
                if (string3.startsWith("http://saxon.sf.net/")) {
                    this.defaultCollationName = string3;
                    return;
                }
                if (this.getPrincipalStylesheet().getExecutable().getNamedCollation(string3) == null) continue;
                this.defaultCollationName = string3;
                return;
            }
            this.compileError("No recognized collation URI found in default-collation attribute", "XTSE0125");
        }
    }

    protected String getDefaultCollationName() {
        StyleElement styleElement = this;
        while (true) {
            if (styleElement.defaultCollationName != null) {
                return styleElement.defaultCollationName;
            }
            NodeInfo nodeInfo = styleElement.getParent();
            if (!(nodeInfo instanceof StyleElement)) break;
            styleElement = (StyleElement)nodeInfo;
        }
        return this.getPrincipalStylesheet().getDefaultCollationName();
    }

    protected boolean definesExtensionElement(short s) {
        if (this.extensionNamespaces == null) {
            return false;
        }
        for (int i = 0; i < this.extensionNamespaces.length; ++i) {
            if (this.extensionNamespaces[i] != s) continue;
            return true;
        }
        return false;
    }

    public boolean isExtensionNamespace(short s) {
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            if (nodeInfo.definesExtensionElement(s)) {
                return true;
            }
            nodeInfo = nodeInfo.getParent();
        }
        return false;
    }

    protected boolean definesExcludedNamespace(short s) {
        if (this.excludedNamespaces == null) {
            return false;
        }
        for (int i = 0; i < this.excludedNamespaces.length; ++i) {
            if (this.excludedNamespaces[i] != s) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludedNamespace(short s) {
        if (s == 2) {
            return true;
        }
        if (this.isExtensionNamespace(s)) {
            return true;
        }
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            if (nodeInfo.definesExcludedNamespace(s)) {
                return true;
            }
            nodeInfo = nodeInfo.getParent();
        }
        return false;
    }

    protected void processDefaultXPathNamespaceAttribute(String string) throws TransformerConfigurationException {
        String string2 = this.getAttributeValue(string);
        if (string2 != null) {
            this.defaultXPathNamespace = string2;
        }
    }

    protected short getDefaultXPathNamespace() {
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof StyleElement) {
            String string = nodeInfo.defaultXPathNamespace;
            if (string != null) {
                return this.getTargetNamePool().allocateCodeForURI(string);
            }
            nodeInfo = nodeInfo.getParent();
        }
        return 0;
    }

    public SchemaType getSchemaType(String string) throws XPathException {
        try {
            String string2;
            int n;
            String[] stringArray = Name.getQNameParts(string);
            String string3 = stringArray[1];
            if ("".equals(stringArray[0])) {
                n = this.getDefaultXPathNamespace();
                string2 = this.getTargetNamePool().getURIFromURICode((short)n);
                this.nameCode = this.getTargetNamePool().allocate(stringArray[0], (short)n, string3);
            } else {
                string2 = this.getURIForPrefix(stringArray[0], false);
                if (string2 == null) {
                    this.compileError("Namespace prefix for type annotation is undeclared", "XTSE0280");
                    return null;
                }
            }
            n = this.getTargetNamePool().allocate(stringArray[0], string2, string3);
            if (string2.equals("http://www.w3.org/2001/XMLSchema")) {
                SchemaType schemaType = BuiltInSchemaFactory.getSchemaType(StandardNames.getFingerprint(string2, string3));
                if (schemaType == null) {
                    this.compileError("Unknown built-in type " + string);
                    return null;
                }
                return schemaType;
            }
            if (NamespaceConstant.isXDTNamespace(string2)) {
                ItemType itemType = Type.getBuiltInItemType("http://www.w3.org/2005/04/xpath-datatypes", string3);
                if (itemType == null) {
                    if ("untyped".equals(string3)) {
                        this.compileError("Cannot validate a node as 'untyped'");
                    } else {
                        this.compileError("Unknown built-in type " + string);
                    }
                }
                return (BuiltInAtomicType)itemType;
            }
            if (!this.getPrincipalStylesheet().isImportedSchema(string2)) {
                this.compileError("There is no imported schema for the namespace of type " + string);
                return null;
            }
            SchemaType schemaType = this.getConfiguration().getSchemaType(n & 0xFFFFF);
            if (schemaType == null) {
                this.compileError("There is no type named " + string + " in an imported schema");
            }
            return schemaType;
        }
        catch (QNameException qNameException) {
            this.compileError("Invalid type name. " + qNameException.getMessage());
            return null;
        }
    }

    public int getTypeAnnotation(SchemaType schemaType) {
        if (schemaType != null) {
            return schemaType.getFingerprint();
        }
        return -1;
    }

    public void validate() throws XPathException {
    }

    public void postValidate() throws XPathException {
    }

    public Expression typeCheck(String string, Expression expression) throws XPathException {
        if (expression == null) {
            return null;
        }
        ExpressionTool.makeParentReferences(expression);
        if (expression instanceof ComputedExpression) {
            ((ComputedExpression)expression).setParentExpression(this);
        }
        try {
            expression = expression.analyze(this.staticContext, Type.ITEM_TYPE);
            if (this.explaining) {
                System.err.println("Attribute '" + string + "' of element '" + this.getDisplayName() + "' at line " + this.getLineNumber() + ':');
                System.err.println("Static type: " + SequenceType.makeSequenceType(expression.getItemType(), expression.getCardinality()));
                System.err.println("Optimized expression tree:");
                expression.display(10, this.getNamePool(), System.err);
            }
            if (this.getConfiguration().getTraceListener() != null) {
                InstructionDetails instructionDetails = new InstructionDetails();
                instructionDetails.setConstructType(2011);
                instructionDetails.setLineNumber(this.getLineNumber());
                instructionDetails.setSystemId(this.getSystemId());
                instructionDetails.setProperty("attribute-name", string);
                TraceInstruction traceInstruction = new TraceInstruction(expression, instructionDetails);
                traceInstruction.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                traceInstruction.setParentExpression(this);
                expression = traceInstruction;
            }
            return expression;
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.isTypeError()) {
                this.compileError(dynamicError);
                return expression;
            }
            ErrorExpression errorExpression = new ErrorExpression(dynamicError);
            errorExpression.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            return errorExpression;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            ErrorExpression errorExpression = new ErrorExpression(xPathException);
            errorExpression.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            return errorExpression;
        }
    }

    public void allocateSlots(Expression expression) {
        SlotManager slotManager = this.getContainingSlotManager();
        if (slotManager == null) {
            throw new AssertionError((Object)"Slot manager has not been allocated");
        }
        int n = slotManager.getNumberOfVariables();
        int n2 = ExpressionTool.allocateSlots(expression, n, slotManager);
        if (n2 > n) {
            slotManager.setNumberOfVariables(n2);
        }
    }

    public Pattern typeCheck(String string, Pattern pattern) throws XPathException {
        if (pattern == null) {
            return null;
        }
        try {
            return pattern.analyze(this.staticContext, Type.NODE_TYPE);
        }
        catch (DynamicError dynamicError) {
            LocationPathPattern locationPathPattern = new LocationPathPattern();
            locationPathPattern.addFilter(new ErrorExpression(dynamicError));
            return locationPathPattern;
        }
        catch (XPathException xPathException) {
            StaticError staticError = new StaticError("Error in " + string + " pattern", xPathException);
            staticError.setLocator(xPathException.getLocator());
            staticError.setErrorCode(xPathException.getErrorCodeLocalPart());
            throw staticError;
        }
    }

    public void fixupReferences() throws XPathException {
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).fixupReferences();
        }
        return;
    }

    public SlotManager getContainingSlotManager() {
        NodeInfo nodeInfo = this;
        while (true) {
            NodeInfo nodeInfo2;
            if ((nodeInfo2 = nodeInfo.getParent()) instanceof XSLStylesheet) {
                if (nodeInfo instanceof StylesheetProcedure) {
                    return ((StylesheetProcedure)((Object)nodeInfo)).getSlotManager();
                }
                return null;
            }
            nodeInfo = nodeInfo2;
        }
    }

    public void validateSubtree() throws XPathException {
        if (this.validationError != null) {
            if (this.reportingCircumstances == 1) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 2 && !this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(this.validationError);
            }
        }
        try {
            this.validate();
        }
        catch (XPathException xPathException) {
            if (this.forwardsCompatibleModeIsEnabled()) {
                this.setValidationError(xPathException, 3);
            }
            this.compileError(xPathException);
        }
        this.validateChildren();
        this.postValidate();
    }

    protected void validateChildren() throws XPathException {
        NodeInfo nodeInfo;
        boolean bl = this.mayContainSequenceConstructor();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        StyleElement styleElement = null;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            if (bl && !((StyleElement)nodeInfo).isInstruction() && !this.isPermittedChild((StyleElement)nodeInfo)) {
                ((StyleElement)nodeInfo).compileError("An " + this.getDisplayName() + " element must not contain an " + nodeInfo.getDisplayName() + " element", "XTSE0010");
            }
            ((StyleElement)nodeInfo).validateSubtree();
            styleElement = (StyleElement)nodeInfo;
        }
        if (styleElement instanceof XSLVariable && !(this instanceof XSLStylesheet)) {
            styleElement.compileWarning("A variable with no following sibling instructions has no effect", "SXWN9001");
        }
    }

    protected boolean isPermittedChild(StyleElement styleElement) {
        return false;
    }

    protected XSLStylesheet getPrincipalStylesheet() {
        XSLStylesheet xSLStylesheet = this.getContainingStylesheet();
        XSLStylesheet xSLStylesheet2;
        while ((xSLStylesheet2 = xSLStylesheet.getImporter()) != null) {
            xSLStylesheet = xSLStylesheet2;
        }
        return xSLStylesheet;
    }

    public PreparedStylesheet getPreparedStylesheet() {
        return this.getPrincipalStylesheet().getPreparedStylesheet();
    }

    public void checkWithinTemplate() throws XPathException {
    }

    protected void checkSortComesFirst(boolean bl) throws XPathException {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        boolean bl2 = false;
        boolean bl3 = false;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo instanceof XSLSort) {
                if (bl3) {
                    ((XSLSort)nodeInfo).compileError("Within " + this.getDisplayName() + ", xsl:sort elements must come before other instructions", "XTSE0010");
                }
                bl2 = true;
                continue;
            }
            if (nodeInfo.getNodeKind() == 3) {
                if (Navigator.isWhite(nodeInfo.getStringValueCS())) continue;
                bl3 = true;
                continue;
            }
            bl3 = true;
        }
        if (bl && !bl2) {
            this.compileError(this.getDisplayName() + " must have at least one xsl:sort child", "XTSE0010");
        }
    }

    public void checkTopLevel(String string) throws XPathException {
        if (string == null) {
            string = "XTSE0010";
        }
        if (!(this.getParent() instanceof XSLStylesheet)) {
            this.compileError("Element must be used only at top level of stylesheet", string);
        }
    }

    public void checkEmpty() throws XPathException {
        if (this.hasChildNodes()) {
            this.compileError("Element must be empty", "XTSE0260");
        }
    }

    public void reportAbsence(String string) throws XPathException {
        this.compileError("Element must have a \"" + string + "\" attribute", "XTSE0010");
    }

    public abstract Expression compile(Executable var1) throws XPathException;

    public Expression compileSequenceConstructor(Executable executable, AxisIterator axisIterator, boolean bl) throws XPathException {
        int n = this.getLineNumber();
        NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
        if (nodeInfo == null) {
            return null;
        }
        if (nodeInfo instanceof StyleElement) {
            n = nodeInfo.getLineNumber();
        }
        if (nodeInfo.getNodeKind() == 3) {
            ValueOf valueOf = new ValueOf(new StringValue(nodeInfo.getStringValueCS()), false);
            valueOf.setLocationId(this.allocateLocationId(this.getSystemId(), n));
            Expression expression = this.compileSequenceConstructor(executable, axisIterator, bl);
            if (expression == null) {
                return valueOf;
            }
            Block block = Block.makeBlock(valueOf, expression);
            block.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            return block;
        }
        if (nodeInfo instanceof XSLVariable) {
            Expression expression = ((XSLVariable)nodeInfo).newCompile(executable);
            if (expression == null) {
                return this.compileSequenceConstructor(executable, axisIterator, bl);
            }
            LocalVariable localVariable = (LocalVariable)expression;
            Expression expression2 = this.compileSequenceConstructor(executable, axisIterator, bl);
            if (expression2 == null) {
                return null;
            }
            LetExpression letExpression = new LetExpression();
            RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
            rangeVariableDeclaration.setRequiredType(localVariable.getRequiredType());
            rangeVariableDeclaration.setNameCode(localVariable.getNameCode());
            rangeVariableDeclaration.setVariableName(localVariable.getVariableName());
            rangeVariableDeclaration.setReferenceList(((XSLVariable)nodeInfo).getReferenceList());
            letExpression.setVariableDeclaration(rangeVariableDeclaration);
            letExpression.setSequence(localVariable.getSelectExpression());
            letExpression.setAction(expression2);
            ((XSLVariable)nodeInfo).fixupBinding(letExpression);
            letExpression.setLocationId(this.allocateLocationId(nodeInfo.getSystemId(), nodeInfo.getLineNumber()));
            if (this.getConfiguration().getTraceListener() != null) {
                TraceExpression traceExpression = new TraceExpression(letExpression);
                traceExpression.setConstructType(2013);
                traceExpression.setObjectNameCode(localVariable.getNameCode());
                traceExpression.setSystemId(nodeInfo.getSystemId());
                traceExpression.setLineNumber(nodeInfo.getLineNumber());
                return traceExpression;
            }
            return letExpression;
        }
        if (nodeInfo instanceof StyleElement) {
            Expression expression;
            StyleElement styleElement = (StyleElement)nodeInfo;
            if (styleElement.validationError != null) {
                return this.fallbackProcessing(executable, styleElement);
            }
            Expression expression3 = styleElement.compile(executable);
            if (expression3 instanceof ComputedExpression) {
                expression = (ComputedExpression)expression3;
                expression.setLocationId(this.allocateLocationId(this.getSystemId(), styleElement.getLineNumber()));
            }
            if (expression3 != null && (bl || !(nodeInfo instanceof XSLParam)) && this.getConfiguration().getTraceListener() != null) {
                expression = StyleElement.makeTraceInstruction(styleElement, expression3);
                expression3 = expression;
            }
            if ((expression = this.compileSequenceConstructor(executable, axisIterator, bl)) == null) {
                return expression3;
            }
            if (expression3 == null) {
                return expression;
            }
            Block block = Block.makeBlock(expression3, expression);
            block.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            return block;
        }
        return null;
    }

    protected static TraceWrapper makeTraceInstruction(StyleElement styleElement, Expression expression) {
        if (expression instanceof TraceWrapper) {
            return (TraceWrapper)expression;
        }
        TraceInstruction traceInstruction = new TraceInstruction(expression, styleElement);
        traceInstruction.setLocationId(styleElement.allocateLocationId(styleElement.getSystemId(), styleElement.getLineNumber()));
        return traceInstruction;
    }

    protected Expression fallbackProcessing(Executable executable, StyleElement styleElement) throws XPathException {
        Object object;
        Expression expression = null;
        AxisIterator axisIterator = styleElement.iterateAxis((byte)3);
        while ((object = (NodeInfo)axisIterator.next()) != null) {
            if (!(object instanceof XSLFallback)) continue;
            Expression expression2 = ((XSLFallback)object).compileSequenceConstructor(executable, object.iterateAxis((byte)3), true);
            if (expression2 == null) {
                expression2 = EmptySequence.getInstance();
            }
            if (expression == null) {
                expression = expression2;
                continue;
            }
            expression = Block.makeBlock(expression, expression2);
        }
        if (expression != null) {
            return expression;
        }
        object = new DeferredError(styleElement.getNameCode(), styleElement.validationError);
        ((ComputedExpression)object).setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
        ((ComputedExpression)object).setParentExpression(this);
        return object;
    }

    public int allocateLocationId(String string, int n) {
        return this.getStaticContext().getLocationMap().allocateLocationId(string, n);
    }

    protected SortKeyDefinition[] makeSortKeys() {
        SortKeyDefinition[] sortKeyDefinitionArray;
        int n = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((sortKeyDefinitionArray = axisIterator.next()) != null) {
            if (!(sortKeyDefinitionArray instanceof XSLSort)) continue;
            ++n;
        }
        if (n > 0) {
            NodeInfo nodeInfo;
            sortKeyDefinitionArray = new SortKeyDefinition[n];
            axisIterator = this.iterateAxis((byte)3);
            int n2 = 0;
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (!(nodeInfo instanceof XSLSort)) continue;
                sortKeyDefinitionArray[n2++] = ((XSLSort)nodeInfo).getSortKeyDefinition();
            }
            return sortKeyDefinitionArray;
        }
        return null;
    }

    protected AttributeSet[] getAttributeSets(String string, List arrayList) throws XPathException {
        int n;
        AttributeSet[] attributeSetArray;
        if (arrayList == null) {
            arrayList = new ArrayList<XSLAttributeSet>(4);
        }
        XSLStylesheet xSLStylesheet = this.getPrincipalStylesheet();
        List list = xSLStylesheet.getTopLevel();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            attributeSetArray = stringTokenizer.nextToken();
            try {
                n = this.makeNameCode((String)attributeSetArray) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage(), "XTSE0710");
                n = -1;
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage(), "XTSE0710");
                n = -1;
            }
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                XSLAttributeSet xSLAttributeSet;
                if (!(list.get(i) instanceof XSLAttributeSet) || (xSLAttributeSet = (XSLAttributeSet)list.get(i)).getAttributeSetFingerprint() != n) continue;
                arrayList.add(xSLAttributeSet);
                bl = true;
            }
            if (bl) continue;
            this.compileError("No attribute-set exists named " + (String)attributeSetArray, "XTSE0710");
        }
        attributeSetArray = new AttributeSet[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            XSLAttributeSet xSLAttributeSet = (XSLAttributeSet)arrayList.get(n);
            xSLAttributeSet.incrementReferenceCount();
            attributeSetArray[n] = xSLAttributeSet.getInstruction();
        }
        return attributeSetArray;
    }

    protected WithParam[] getWithParamInstructions(Executable executable, boolean bl, Instruction instruction) throws XPathException {
        NodeInfo nodeInfo;
        WithParam[] withParamArray;
        int n = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((withParamArray = (WithParam[])axisIterator.next()) != null) {
            if (!(withParamArray instanceof XSLWithParam) || ((XSLGeneralVariable)(nodeInfo = (XSLWithParam)withParamArray)).isTunnelParam() != bl) continue;
            ++n;
        }
        withParamArray = new WithParam[n];
        n = 0;
        axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            NodeInfo nodeInfo2;
            if (!(nodeInfo instanceof XSLWithParam) || ((XSLGeneralVariable)(nodeInfo2 = nodeInfo)).isTunnelParam() != bl) continue;
            WithParam withParam = (WithParam)((XSLWithParam)nodeInfo2).compile(executable);
            withParam.setParentExpression(instruction);
            withParamArray[n++] = withParam;
        }
        return withParamArray;
    }

    protected void compileError(TransformerException transformerException) throws XPathException {
        if (transformerException.getLocator() == null || transformerException.getLocator() instanceof ExpressionLocation) {
            transformerException.setLocator(this);
        }
        PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
        try {
            if (preparedStylesheet == null) {
                throw transformerException;
            }
            preparedStylesheet.reportError(transformerException);
        }
        catch (TransformerException transformerException2) {
            if (transformerException2.getLocator() == null) {
                transformerException2.setLocator(this);
            }
            throw StaticError.makeStaticError(transformerException2);
        }
    }

    protected void compileError(String string) throws XPathException {
        StaticError staticError = new StaticError(string);
        staticError.setLocator(this);
        this.compileError(staticError);
    }

    protected void compileError(String string, String string2) throws XPathException {
        StaticError staticError = new StaticError(string);
        staticError.setErrorCode(string2);
        staticError.setLocator(this);
        this.compileError(staticError);
    }

    protected void undeclaredNamespaceError(String string, String string2) throws XPathException {
        if (string2 == null) {
            string2 = "XTSE0280";
        }
        this.compileError("Undeclared namespace prefix " + Err.wrap(string), string2);
    }

    protected void compileWarning(String string, String string2) throws XPathException {
        StaticError staticError = new StaticError(string);
        staticError.setErrorCode(string2);
        staticError.setLocator(this);
        PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
        if (preparedStylesheet != null) {
            preparedStylesheet.reportWarning(staticError);
        }
    }

    protected void issueWarning(TransformerException transformerException) {
        PreparedStylesheet preparedStylesheet;
        if (transformerException.getLocator() == null) {
            transformerException.setLocator(this);
        }
        if ((preparedStylesheet = this.getPreparedStylesheet()) != null) {
            preparedStylesheet.reportWarning(transformerException);
        }
    }

    protected void issueWarning(String string, SourceLocator sourceLocator) {
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string);
        if (sourceLocator == null) {
            transformerConfigurationException.setLocator(this);
        } else {
            transformerConfigurationException.setLocator(sourceLocator);
        }
        this.issueWarning(transformerConfigurationException);
    }

    public boolean isTopLevel() {
        return this.getParent() instanceof XSLStylesheet;
    }

    public XSLVariableDeclaration bindVariable(int n) throws StaticError {
        XSLVariableDeclaration xSLVariableDeclaration = this.getVariableBinding(n);
        if (xSLVariableDeclaration == null) {
            StaticError staticError = new StaticError("Variable " + this.getTargetNamePool().getDisplayName(n) + " has not been declared");
            staticError.setErrorCode("XPST0008");
            throw staticError;
        }
        return xSLVariableDeclaration;
    }

    private XSLVariableDeclaration getVariableBinding(int n) {
        XSLVariableDeclaration xSLVariableDeclaration;
        Object object;
        block4: {
            NodeInfo nodeInfo = this;
            NodeInfo nodeInfo2 = this;
            if (!this.isTopLevel()) {
                object = nodeInfo.iterateAxis((byte)11);
                do {
                    nodeInfo = (NodeInfo)object.next();
                    while (nodeInfo == null) {
                        nodeInfo = nodeInfo2.getParent();
                        while (nodeInfo instanceof XSLFallback) {
                            nodeInfo = nodeInfo.getParent();
                        }
                        nodeInfo2 = nodeInfo;
                        if (nodeInfo.getParent() instanceof XSLStylesheet) break;
                        object = nodeInfo.iterateAxis((byte)11);
                        nodeInfo = (NodeInfo)object.next();
                    }
                    if (nodeInfo.getParent() instanceof XSLStylesheet) break block4;
                } while (!(nodeInfo instanceof XSLVariableDeclaration) || (xSLVariableDeclaration = (XSLVariableDeclaration)nodeInfo).getVariableFingerprint() != n);
                return xSLVariableDeclaration;
            }
        }
        object = this.getPrincipalStylesheet();
        xSLVariableDeclaration = ((XSLStylesheet)object).getGlobalVariable(n);
        return xSLVariableDeclaration;
    }

    public XSLFunction getStylesheetFunction(int n, int n2) {
        XSLStylesheet xSLStylesheet = this.getPrincipalStylesheet();
        List list = xSLStylesheet.getTopLevel();
        for (int i = list.size() - 1; i >= 0; --i) {
            Object e = list.get(i);
            if (!(e instanceof XSLFunction) || ((XSLFunction)e).getFunctionFingerprint() != n || n2 != -1 && ((XSLFunction)e).getNumberOfArguments() != n2) continue;
            XSLFunction xSLFunction = (XSLFunction)e;
            return xSLFunction;
        }
        return null;
    }

    public int getConstructType() {
        return this.getFingerprint();
    }

    public int getInstructionFingerprint() {
        return this.getFingerprint();
    }

    public int getObjectNameCode() {
        return this.objectNameCode;
    }

    public int getObjectFingerprint() {
        return this.objectNameCode == -1 ? -1 : this.objectNameCode & 0xFFFFF;
    }

    public void setObjectNameCode(int n) {
        this.objectNameCode = n;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.makeNamespaceContext();
    }

    public Object getProperty(String string) {
        return this.getAttributeValue(string);
    }

    public Iterator getProperties() {
        NodeInfo nodeInfo;
        NamePool namePool = this.getNamePool();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        AxisIterator axisIterator = this.iterateAxis((byte)2);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            arrayList.add(namePool.getClarkName(nodeInfo.getNameCode()));
        }
        return arrayList.iterator();
    }

    public String getSystemId(int n) {
        return this.getSystemId();
    }

    public int getLineNumber(int n) {
        return this.getLineNumber();
    }
}

