/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.ComputedElement;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.FixedElement;
import net.sf.saxon.instruct.ParentNodeConstructor;
import net.sf.saxon.instruct.SavedNamespaceContext;
import net.sf.saxon.instruct.UseAttributeSets;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;

public class XSLElement
extends StyleElement {
    private Expression elementName;
    private Expression namespace = null;
    private String use;
    private AttributeSet[] attributeSets = null;
    private int validation;
    private SchemaType schemaType = null;
    private boolean inheritNamespaces = true;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string6 = this.getNamePool().getClarkName(n);
            if (string6 == "name") {
                string = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "namespace") {
                string2 = attributeCollection.getValue(i);
                continue;
            }
            if (string6 == "validation") {
                string3 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "type") {
                string4 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "inherit-namespaces") {
                string5 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "use-attribute-sets") {
                this.use = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string == null) {
            this.reportAbsence("name");
        } else {
            this.elementName = this.makeAttributeValueTemplate(string);
            if (this.elementName instanceof StringValue && !Name.isQName(((StringValue)this.elementName).getStringValue())) {
                this.compileError("Element name " + Err.wrap(((StringValue)this.elementName).getStringValue(), 1) + " is not a valid QName", "XTDE0820");
                this.elementName = new StringValue("saxon-error-element");
            }
        }
        if (string2 != null) {
            this.namespace = this.makeAttributeValueTemplate(string2);
        }
        if (string3 != null) {
            this.validation = Validation.getCode(string3);
            if (this.validation != 4 && !this.getConfiguration().isSchemaAware(10)) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
            if (this.validation == -1) {
                this.compileError("Invalid value for @validation attribute. Permitted values are (strict, lax, preserve, strip)", "XTSE0020");
            }
        } else {
            this.validation = this.getContainingStylesheet().getDefaultValidation();
        }
        if (string4 != null) {
            if (!this.getConfiguration().isSchemaAware(10)) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.schemaType = this.getSchemaType(string4);
        }
        if (string4 != null && string3 != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if (string5 != null) {
            if (string5.equals("yes")) {
                this.inheritNamespaces = true;
            } else if (string5.equals("no")) {
                this.inheritNamespaces = false;
            } else {
                this.compileError("The @inherit-namespaces attribute has permitted values (yes, no)", "XTSE0020");
            }
        }
    }

    public void validate() throws XPathException {
        this.checkWithinTemplate();
        if (this.use != null) {
            this.attributeSets = this.getAttributeSets(this.use, null);
        }
        this.elementName = this.typeCheck("name", this.elementName);
        this.namespace = this.typeCheck("namespace", this.namespace);
    }

    public Expression compile(Executable executable) throws XPathException {
        Object object;
        Object object2;
        SavedNamespaceContext savedNamespaceContext = null;
        if (this.elementName instanceof StringValue) {
            object2 = ((StringValue)this.elementName).getStringValueCS();
            try {
                object = Name.getQNameParts((CharSequence)object2);
            }
            catch (QNameException qNameException) {
                this.compileError("Invalid element name: " + object2, "XTDE0820");
                return null;
            }
            String string = null;
            if (this.namespace instanceof StringValue) {
                string = ((StringValue)this.namespace).getStringValue();
                if (string.equals("")) {
                    object[0] = "";
                }
            } else if (this.namespace == null && (string = this.getURIForPrefix(object[0], true)) == null) {
                this.undeclaredNamespaceError(object[0], "XTDE0280");
            }
            if (string != null) {
                int n = this.getTargetNamePool().allocate(object[0], string, object[1]);
                FixedElement fixedElement = new FixedElement(n, null, this.inheritNamespaces, this.schemaType, this.validation);
                Expression expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
                if (this.attributeSets != null) {
                    UseAttributeSets useAttributeSets = new UseAttributeSets(this.attributeSets);
                    expression = expression == null ? useAttributeSets : Block.makeBlock(useAttributeSets, expression);
                }
                if (expression == null) {
                    expression = EmptySequence.getInstance();
                }
                fixedElement.setContentExpression(expression);
                ExpressionTool.makeParentReferences(fixedElement);
                return fixedElement;
            }
        } else if (this.namespace == null) {
            savedNamespaceContext = this.makeNamespaceContext();
        }
        object2 = new ComputedElement(this.elementName, this.namespace, savedNamespaceContext, this.schemaType, this.validation, this.inheritNamespaces, false);
        object = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
        if (object == null) {
            object = EmptySequence.getInstance();
        }
        ((ParentNodeConstructor)object2).setContentExpression((Expression)object);
        ExpressionTool.makeParentReferences((Expression)object2);
        return object2;
    }
}

