/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Comparator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ForEachGroup;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public final class XSLForEachGroup
extends StyleElement {
    private Expression select = null;
    private Expression groupBy = null;
    private Expression groupAdjacent = null;
    private Pattern starting = null;
    private Pattern ending = null;
    private String collationName;

    public boolean isInstruction() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement styleElement) {
        return styleElement instanceof XSLSort;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        int n;
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (n = 0; n < attributeCollection.getLength(); ++n) {
            int n2 = attributeCollection.getNameCode(n);
            String string6 = this.getNamePool().getClarkName(n2);
            if (string6 == "select") {
                string = attributeCollection.getValue(n);
                continue;
            }
            if (string6 == "group-by") {
                string2 = attributeCollection.getValue(n);
                continue;
            }
            if (string6 == "group-adjacent") {
                string3 = attributeCollection.getValue(n);
                continue;
            }
            if (string6 == "group-starting-with") {
                string4 = attributeCollection.getValue(n);
                continue;
            }
            if (string6 == "group-ending-with") {
                string5 = attributeCollection.getValue(n);
                continue;
            }
            if (string6 == "collation") {
                this.collationName = attributeCollection.getValue(n).trim();
                continue;
            }
            this.checkUnknownAttribute(n2);
        }
        if (string == null) {
            this.reportAbsence("select");
        } else {
            this.select = this.makeExpression(string);
        }
        n = (string2 == null ? 0 : 1) + (string3 == null ? 0 : 1) + (string4 == null ? 0 : 1) + (string5 == null ? 0 : 1);
        if (n != 1) {
            this.compileError("Exactly one of the attributes group-by, group-adjacent, group-starting-with, and group-ending-with must be specified", "XTSE1080");
        }
        if (string2 != null) {
            this.groupBy = this.makeExpression(string2);
        }
        if (string3 != null) {
            this.groupAdjacent = this.makeExpression(string3);
        }
        if (string4 != null) {
            this.starting = this.makePattern(string4);
        }
        if (string5 != null) {
            this.ending = this.makePattern(string5);
        }
        if (this.collationName != null && this.groupBy == null && this.groupAdjacent == null) {
            this.compileError("A collation may be specified only if group-by or group-adjacent is specified", "XTSE1090");
        }
    }

    public void validate() throws XPathException {
        RoleLocator roleLocator;
        this.checkWithinTemplate();
        this.checkSortComesFirst(false);
        this.select = this.typeCheck("select", this.select);
        ExpressionLocation expressionLocation = new ExpressionLocation(this);
        if (this.groupBy != null) {
            this.groupBy = this.typeCheck("group-by", this.groupBy);
            try {
                roleLocator = new RoleLocator(4, "xsl:for-each-group/group-by", 0, null);
                roleLocator.setSourceLocator(expressionLocation);
                this.groupBy = TypeChecker.staticTypeCheck(this.groupBy, SequenceType.ATOMIC_SEQUENCE, false, roleLocator, this.getStaticContext());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        } else if (this.groupAdjacent != null) {
            this.groupAdjacent = this.typeCheck("group-adjacent", this.groupAdjacent);
            try {
                roleLocator = new RoleLocator(4, "xsl:for-each-group/group-adjacent", 0, null);
                roleLocator.setSourceLocator(expressionLocation);
                roleLocator.setErrorCode("XTTE1100");
                this.groupAdjacent = TypeChecker.staticTypeCheck(this.groupAdjacent, SequenceType.SINGLE_ATOMIC, false, roleLocator, this.getStaticContext());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        this.starting = this.typeCheck("starting", this.starting);
        this.ending = this.typeCheck("ending", this.ending);
        if (this.starting != null || this.ending != null) {
            try {
                roleLocator = new RoleLocator(4, "xsl:for-each-group/select", 0, null);
                roleLocator.setSourceLocator(expressionLocation);
                roleLocator.setErrorCode("XTTE1120");
                this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.NODE_SEQUENCE, false, roleLocator, this.getStaticContext());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        Comparator comparator = null;
        if (this.collationName != null && (comparator = this.getPrincipalStylesheet().findCollation(this.collationName)) == null) {
            this.compileError("The collation name '" + this.collationName + "' has not been defined", "XTDE1110");
        }
        byte by = 0;
        Expression expression = null;
        if (this.groupBy != null) {
            by = 0;
            expression = this.groupBy;
        } else if (this.groupAdjacent != null) {
            by = 1;
            expression = this.groupAdjacent;
        } else if (this.starting != null) {
            by = 2;
            expression = new PatternSponsor(this.starting);
        } else if (this.ending != null) {
            by = 3;
            expression = new PatternSponsor(this.ending);
        }
        Expression expression2 = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
        if (expression2 == null) {
            return EmptySequence.getInstance();
        }
        try {
            ForEachGroup forEachGroup = new ForEachGroup(this.select, expression2.simplify(this.getStaticContext()), by, expression, comparator, this.makeSortKeys());
            ExpressionTool.makeParentReferences(forEachGroup);
            return forEachGroup;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return null;
        }
    }
}

