/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import java.text.Collator;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.Err;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;

public class XSLKey
extends StyleElement
implements StylesheetProcedure {
    private Pattern match;
    private Expression use;
    private String collationName;
    SlotManager stackFrameMap;

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public void prepareAttributes() throws XPathException {
        String string = null;
        String string2 = null;
        String string3 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string4 = this.getNamePool().getClarkName(n);
            if (string4 == "name") {
                string = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string4 == "use") {
                string3 = attributeCollection.getValue(i);
                continue;
            }
            if (string4 == "match") {
                string2 = attributeCollection.getValue(i);
                continue;
            }
            if (string4 == "collation") {
                this.collationName = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        try {
            this.setObjectNameCode(this.makeNameCode(string.trim()));
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage(), "XTSE0280");
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        if (string2 == null) {
            this.reportAbsence("match");
            string2 = "*";
        }
        this.match = this.makePattern(string2);
        if (string3 != null) {
            this.use = this.makeExpression(string3);
        }
    }

    public void validate() throws XPathException {
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel(null);
        if (this.use != null) {
            if (this.hasChildNodes()) {
                this.compileError("An xsl:key element with a @use attribute must be empty", "XTSE1205");
            }
            try {
                RoleLocator roleLocator = new RoleLocator(4, "xsl:key/use", 0, null);
                roleLocator.setSourceLocator(new ExpressionLocation(this));
                this.use = TypeChecker.staticTypeCheck(this.use, SequenceType.makeSequenceType(Type.ANY_ATOMIC_TYPE, 57344), false, roleLocator, this.getStaticContext());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        } else if (!this.hasChildNodes()) {
            this.compileError("An xsl:key element must either have a @use attribute or have content", "XTSE1205");
        }
        this.use = this.typeCheck("use", this.use);
        this.match = this.typeCheck("match", this.match);
    }

    public Expression compile(Executable executable) throws XPathException {
        Serializable serializable;
        Object object;
        Collator collator = null;
        if (this.collationName != null) {
            object = this.getPrincipalStylesheet().findCollation(this.collationName);
            if (object == null) {
                this.compileError("The collation name " + Err.wrap(this.collationName) + " is not recognized", "XTSE1210");
            }
            if (!(object instanceof Collator)) {
                this.compileError("The collation used for xsl:key must be a java.text.Collator", "XTSE1210");
            }
            collator = (Collator)object;
        }
        if (this.use == null) {
            object = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
            try {
                this.use = new Atomizer(object.simplify(this.getStaticContext()), this.getStaticContext().getConfiguration());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
            try {
                serializable = new RoleLocator(4, "xsl:key/use", 0, null);
                ((RoleLocator)serializable).setSourceLocator(new ExpressionLocation(this));
                this.use = TypeChecker.staticTypeCheck(this.use, SequenceType.makeSequenceType(Type.ANY_ATOMIC_TYPE, 57344), false, (RoleLocator)serializable, this.getStaticContext());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        this.allocateSlots(this.use);
        object = this.getPrincipalStylesheet().getKeyManager();
        serializable = new KeyDefinition(this.match, this.use, this.collationName, collator);
        ((KeyDefinition)serializable).setStackFrameMap(this.stackFrameMap);
        ((KeyDefinition)serializable).setLocation(this.getSystemId(), this.getLineNumber());
        ((Procedure)serializable).setExecutable(this.getExecutable());
        try {
            ((KeyManager)object).setKeyDefinition(this.getObjectFingerprint(), (KeyDefinition)serializable);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.compileError(transformerConfigurationException);
        }
        return null;
    }
}

