/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Message;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public final class XSLMessage
extends StyleElement {
    private Expression terminate = null;
    private Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        String string;
        String string2 = null;
        String string3 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string4 = this.getNamePool().getClarkName(n);
            if (string4 == "terminate") {
                string2 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string4 == "select") {
                string3 = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string3 != null) {
            this.select = this.makeExpression(string3);
        }
        if (string2 == null) {
            string2 = "no";
        }
        this.terminate = this.makeAttributeValueTemplate(string2);
        if (this.terminate instanceof StringValue && !(string = ((StringValue)this.terminate).getStringValue()).equals("yes") && !string.equals("no")) {
            this.compileError("terminate must be 'yes' or 'no'", "XTSE0020");
        }
    }

    public void validate() throws XPathException {
        if (!(this.getParent() instanceof XSLFunction)) {
            this.checkWithinTemplate();
        }
        this.select = this.typeCheck("select", this.select);
        this.terminate = this.typeCheck("terminate", this.terminate);
    }

    public Expression compile(Executable executable) throws XPathException {
        Expression expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
        if (expression != null) {
            this.select = this.select == null ? expression : Block.makeBlock(this.select, expression);
        }
        if (this.select == null) {
            this.select = new StringValue("xsl:message (no content)");
        }
        Message message = new Message(this.select, this.terminate);
        ExpressionTool.makeParentReferences(message);
        return message;
    }
}

