/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;

public class XSLNamespaceAlias
extends StyleElement {
    private short stylesheetURICode;
    private int resultNamespaceCode;

    public void prepareAttributes() throws XPathException {
        String string = null;
        String string2 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string3 = this.getNamePool().getClarkName(n);
            if (string3 == "stylesheet-prefix") {
                string = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string3 == "result-prefix") {
                string2 = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string == null) {
            this.reportAbsence("stylesheet-prefix");
            return;
        }
        if (string.equals("#default")) {
            string = "";
        }
        if (string2 == null) {
            this.reportAbsence("result-prefix");
            return;
        }
        if (string2.equals("#default")) {
            string2 = "";
        }
        try {
            this.stylesheetURICode = this.getURICodeForPrefix(string);
            NamePool namePool = this.getNamePool();
            this.resultNamespaceCode = namePool.getNamespaceCode(string2, this.getURIForPrefix(string2, true));
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
    }

    public void validate() throws XPathException {
        this.checkTopLevel(null);
    }

    public Expression compile(Executable executable) throws XPathException {
        return null;
    }

    public short getStylesheetURICode() {
        return this.stylesheetURICode;
    }

    public int getResultNamespaceCode() {
        return this.resultNamespaceCode;
    }
}

