/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ResultDocument;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;

public class XSLResultDocument
extends StyleElement {
    private static final HashSet fans = new HashSet(25);
    private Expression href;
    private int format = -1;
    private int validationAction = 4;
    private SchemaType schemaType = null;
    private HashMap serializationAttributes = new HashMap(20);

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return null;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string6 = this.getNamePool().getClarkName(n);
            if (string6 == "format") {
                string = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "href") {
                string2 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "validation") {
                string3 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "type") {
                string4 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string6 == "use-character-maps") {
                string5 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (fans.contains(string6) || !string6.startsWith("{}")) {
                String string7 = attributeCollection.getValue(i).trim();
                Expression expression = this.makeAttributeValueTemplate(string7);
                this.serializationAttributes.put(new Integer(n & 0xFFFFF), expression);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string2 != null) {
            this.href = this.makeAttributeValueTemplate(string2);
        }
        if (string != null) {
            try {
                this.format = this.makeNameCode(string.trim()) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage(), "XTSE0280");
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage());
            }
        }
        if (string3 == null) {
            this.validationAction = this.getContainingStylesheet().getDefaultValidation();
        } else {
            this.validationAction = Validation.getCode(string3);
            if (this.validationAction != 4 && !this.getConfiguration().isSchemaAware(10)) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
            if (this.validationAction == -1) {
                this.compileError("Invalid value of @validation attribute", "XTSE0020");
            }
        }
        if (string4 != null) {
            if (!this.getConfiguration().isSchemaAware(10)) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.schemaType = this.getSchemaType(string4);
        }
        if (string4 != null && string3 != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if (string5 != null) {
            String string8 = XSLOutput.prepareCharacterMaps(this, string5, new Properties());
            this.serializationAttributes.put(new Integer(this.getNamePool().allocate("", "", "use-character-maps")), new StringValue(string8));
        }
    }

    public void validate() throws XPathException {
        this.checkWithinTemplate();
        if (!this.getPreparedStylesheet().getConfiguration().isAllowExternalFunctions()) {
            this.compileError("xsl:result-document is disabled when extension functions are disabled");
        }
        this.href = this.typeCheck("href", this.href);
        Iterator iterator = this.serializationAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            Expression expression;
            Integer n = (Integer)iterator.next();
            Expression expression2 = (Expression)this.serializationAttributes.get(n);
            if (expression2 == (expression = this.typeCheck(this.getNamePool().getDisplayName(n), expression2))) continue;
            this.serializationAttributes.put(n, expression);
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        Object object;
        Properties properties;
        try {
            properties = this.getPrincipalStylesheet().gatherOutputProperties(this.format);
        }
        catch (XPathException xPathException) {
            this.compileError("Named output format has not been defined", "XTSE1460");
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(10);
        boolean bl = false;
        Object object2 = this.serializationAttributes.keySet().iterator();
        while (object2.hasNext()) {
            String string;
            object = (Integer)object2.next();
            Expression expression = (Expression)this.serializationAttributes.get(object);
            if (expression instanceof StringValue) {
                string = ((StringValue)expression).getStringValue();
                try {
                    ResultDocument.setSerializationProperty(properties, (Integer)object, string, this.getNamePool(), this.getStaticContext().getNamespaceResolver());
                    arrayList.add((Integer)object);
                }
                catch (XPathException xPathException) {
                    if ("http://saxon.sf.net/".equals(xPathException.getErrorCodeNamespace())) {
                        this.compileWarning(xPathException.getMessage(), xPathException.getErrorCodeLocalPart());
                        continue;
                    }
                    this.compileError(xPathException);
                }
                continue;
            }
            string = this.getNamePool().getLocalName((Integer)object);
            if (!string.equals("method") && !string.equals("cdata-section-elements")) continue;
            bl = true;
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            this.serializationAttributes.remove(object2.next());
        }
        object2 = new ResultDocument(properties, this.href, this.getBaseURI(), this.validationAction, this.schemaType, this.serializationAttributes, bl ? this.getStaticContext().getNamespaceResolver() : null);
        object = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
        if (object == null) {
            object = EmptySequence.getInstance();
        }
        ((ResultDocument)object2).setContent((Expression)object);
        ExpressionTool.makeParentReferences((Expression)object2);
        return object2;
    }

    static {
        fans.add("method");
        fans.add("output-version");
        fans.add("byte-order-mark");
        fans.add("indent");
        fans.add("encoding");
        fans.add("media-type");
        fans.add("doctype-system");
        fans.add("doctype-public");
        fans.add("omit-xml-declaration");
        fans.add("standalone");
        fans.add("cdata-section-elements");
        fans.add("include-content-type");
        fans.add("escape-uri-attributes");
        fans.add("undeclare-prefixes");
        fans.add("{http://saxon.sf.net/}next-in-chain");
        fans.add("{http://saxon.sf.net/}character-representation");
        fans.add("{http://saxon.sf.net/}indent-spaces");
        fans.add("{http://saxon.sf.net/}require-well-formed");
    }
}

