/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyParentNodeImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.XPathException;

final class TinyElementImpl
extends TinyParentNodeImpl {
    public TinyElementImpl(TinyTree tinyTree, int n) {
        this.tree = tinyTree;
        this.nodeNr = n;
    }

    public final int getNodeKind() {
        return 1;
    }

    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    public int getTypeAnnotation() {
        return this.tree.getElementAnnotation(this.nodeNr);
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        NodeInfo nodeInfo;
        int n = this.tree.beta[this.nodeNr];
        if (n > 0) {
            while (n < this.tree.numberOfNamespaces && this.tree.namespaceParent[n] == this.nodeNr) {
                int n2 = this.tree.namespaceCode[n];
                receiver.namespace(n2, 0);
                ++n;
            }
        }
        if (bl && (nodeInfo = this.getParent()) != null) {
            nodeInfo.sendNamespaceDeclarations(receiver, true);
        }
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        return TinyElementImpl.getDeclaredNamespaces(this.tree, this.nodeNr, nArray);
    }

    static final int[] getDeclaredNamespaces(TinyTree tinyTree, int n, int[] nArray) {
        int n2 = tinyTree.beta[n];
        if (n2 > 0) {
            int n3 = 0;
            while (n2 < tinyTree.numberOfNamespaces && tinyTree.namespaceParent[n2] == n) {
                ++n3;
                ++n2;
            }
            if (n3 == 0) {
                return NodeInfo.EMPTY_NAMESPACE_LIST;
            }
            if (n3 <= nArray.length) {
                System.arraycopy(tinyTree.namespaceCode, tinyTree.beta[n], nArray, 0, n3);
                if (n3 < nArray.length) {
                    nArray[n3] = -1;
                }
                return nArray;
            }
            int[] nArray2 = new int[n3];
            System.arraycopy(tinyTree.namespaceCode, tinyTree.beta[n], nArray2, 0, n3);
            return nArray2;
        }
        return NodeInfo.EMPTY_NAMESPACE_LIST;
    }

    static final int[] getInScopeNamespaces(TinyTree tinyTree, int n, int[] nArray) {
        int n2;
        int n3;
        int n4;
        if (nArray == null || nArray.length == 0) {
            nArray = new int[10];
        }
        nArray[0] = 65537;
        int n5 = 1;
        do {
            if ((n4 = tinyTree.beta[n]) <= 0) continue;
            while (n4 < tinyTree.numberOfNamespaces && tinyTree.namespaceParent[n4] == n) {
                n3 = tinyTree.namespaceCode[n4];
                n2 = (short)(n3 >> 16);
                boolean bl = false;
                for (int i = 0; i < n5; ++i) {
                    if (nArray[i] >> 16 != n2) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    if (n5 >= nArray.length) {
                        int[] nArray2 = new int[n5 * 2];
                        System.arraycopy(nArray, 0, nArray2, 0, n5);
                        nArray = nArray2;
                    }
                    nArray[n5++] = n3;
                }
                ++n4;
            }
        } while ((n = TinyElementImpl.getParentNodeNr(tinyTree, n)) != -1);
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = nArray[n3];
            if ((n2 & 0xFFFF) == 0) continue;
            nArray[n4++] = n2;
        }
        if (n4 < nArray.length) {
            nArray[n4] = -1;
        }
        return nArray;
    }

    public String getAttributeValue(int n) {
        int n2 = this.tree.alpha[this.nodeNr];
        if (n2 < 0) {
            return null;
        }
        while (n2 < this.tree.numberOfAttributes && this.tree.attParent[n2] == this.nodeNr) {
            if ((this.tree.attCode[n2] & 0xFFFFF) == n) {
                return ((Object)this.tree.attValue[n2]).toString();
            }
            ++n2;
        }
        return null;
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        short s = -1;
        boolean bl2 = false;
        short s2 = this.tree.depth[this.nodeNr];
        boolean bl3 = true;
        int n3 = this.nodeNr;
        do {
            short s3 = this.tree.depth[n3];
            if (bl2) {
                s = (short)(s + 1);
            }
            while (s > s3) {
                receiver.endElement();
                s = (short)(s - 1);
            }
            s = s3;
            switch (this.tree.nodeKind[n3]) {
                case 1: {
                    int n4;
                    int n5;
                    receiver.startElement(this.tree.nameCode[n3], bl ? this.tree.getElementAnnotation(n3) : -1, n2, 0);
                    bl2 = true;
                    if (n != 0) {
                        if (bl3) {
                            this.sendNamespaceDeclarations(receiver, n == 2);
                        } else {
                            n5 = this.tree.beta[n3];
                            if (n5 > 0) {
                                while (n5 < this.tree.numberOfNamespaces && this.tree.namespaceParent[n5] == n3) {
                                    n4 = this.tree.namespaceCode[n5];
                                    receiver.namespace(n4, 0);
                                    ++n5;
                                }
                            }
                        }
                    }
                    bl3 = false;
                    n5 = this.tree.alpha[n3];
                    if (n5 >= 0) {
                        while (n5 < this.tree.numberOfAttributes && this.tree.attParent[n5] == n3) {
                            n4 = this.tree.attCode[n5];
                            int n6 = bl ? this.tree.getAttributeAnnotation(n5) : -1;
                            receiver.attribute(n4, n6, this.tree.attValue[n5], n2, 0);
                            ++n5;
                        }
                    }
                    receiver.startContent();
                    break;
                }
                case 3: {
                    bl2 = false;
                    int n7 = this.tree.alpha[n3];
                    int n4 = this.tree.beta[n3];
                    receiver.characters(new CharSlice(this.tree.charBuffer, n7, n4), n2, 0);
                    break;
                }
                case 8: {
                    bl2 = false;
                    int n8 = this.tree.alpha[n3];
                    int n4 = this.tree.beta[n3];
                    if (n4 > 0) {
                        receiver.comment(this.tree.commentBuffer.subSequence(n8, n8 + n4), n2, 0);
                        break;
                    }
                    receiver.comment("", 0, 0);
                    break;
                }
                case 7: {
                    bl2 = false;
                    TinyNodeImpl tinyNodeImpl = this.tree.getNode(n3);
                    receiver.processingInstruction(tinyNodeImpl.getLocalPart(), tinyNodeImpl.getStringValue(), n2, 0);
                }
            }
        } while (++n3 < this.tree.numberOfNodes && this.tree.depth[n3] > s2);
        if (bl2) {
            s = (short)(s + 1);
        }
        while (s > s2) {
            receiver.endElement();
            s = (short)(s - 1);
        }
    }

    public String getURIForPrefix(String string, boolean bl) {
        NodeInfo nodeInfo;
        if (!bl && "".equals(string)) {
            return "";
        }
        short s = this.getNamePool().getCodeForPrefix(string);
        if (s == -1) {
            return null;
        }
        int n = this.tree.beta[this.nodeNr];
        if (n > 0) {
            while (n < this.tree.numberOfNamespaces && this.tree.namespaceParent[n] == this.nodeNr) {
                int n2 = this.tree.namespaceCode[n];
                if (n2 >> 16 == s) {
                    int n3 = n2 & 0xFFFF;
                    if (n3 == 0) {
                        if (s == 0) {
                            return "";
                        }
                        return null;
                    }
                    return this.getNamePool().getURIFromURICode((short)n3);
                }
                ++n;
            }
        }
        if ((nodeInfo = this.getParent()) instanceof NamespaceResolver) {
            return ((NamespaceResolver)((Object)nodeInfo)).getURIForPrefix(string, bl);
        }
        return null;
    }
}

