/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.PrependIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.AncestorEnumeration;
import net.sf.saxon.tinytree.AttributeEnumeration;
import net.sf.saxon.tinytree.DescendantEnumeration;
import net.sf.saxon.tinytree.FollowingEnumeration;
import net.sf.saxon.tinytree.PrecedingEnumeration;
import net.sf.saxon.tinytree.PrecedingSiblingEnumeration;
import net.sf.saxon.tinytree.SiblingEnumeration;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.UntypedAtomicValue;

public abstract class TinyNodeImpl
implements NodeInfo,
FingerprintedNode,
SourceLocator {
    protected TinyTree tree;
    protected int nodeNr;
    protected TinyNodeImpl parent = null;
    public static final char[] NODE_LETTER = new char[]{'x', 'e', 'a', 't', 'x', 'x', 'x', 'p', 'c', 'r', 'x', 'x', 'x', 'n'};

    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    public int getTypeAnnotation() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public SequenceIterator getTypedValue() throws XPathException {
        int n = this.getTypeAnnotation();
        if (n == -1) {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(this.getStringValue()));
        }
        SchemaType schemaType = this.getConfiguration().getSchemaType(n);
        if (schemaType == null) {
            String string = this.getNamePool().getDisplayName(n);
            throw new DynamicError("Unknown type annotation " + Err.wrap(string) + " in document instance");
        }
        return schemaType.getTypedValue(this);
    }

    public void setSystemId(String string) {
        short s = this.tree.nodeKind[this.nodeNr];
        if (s == 2 || s == 13) {
            this.getParent().setSystemId(string);
        } else {
            this.tree.setSystemId(this.nodeNr, string);
        }
    }

    protected void setParentNode(TinyNodeImpl tinyNodeImpl) {
        this.parent = tinyNodeImpl;
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (this == nodeInfo) {
            return true;
        }
        if (!(nodeInfo instanceof TinyNodeImpl)) {
            return false;
        }
        if (this.tree != ((TinyNodeImpl)nodeInfo).tree) {
            return false;
        }
        if (this.nodeNr != ((TinyNodeImpl)nodeInfo).nodeNr) {
            return false;
        }
        return this.getNodeKind() == nodeInfo.getNodeKind();
    }

    public String getSystemId() {
        return this.tree.getSystemId(this.nodeNr);
    }

    public String getBaseURI() {
        return this.getParent().getBaseURI();
    }

    public int getLineNumber() {
        return this.tree.getLineNumber(this.nodeNr);
    }

    protected long getSequenceNumber() {
        return (long)this.nodeNr << 32;
    }

    public final int compareOrder(NodeInfo nodeInfo) {
        long l = this.getSequenceNumber();
        if (nodeInfo instanceof TinyNodeImpl) {
            long l2 = ((TinyNodeImpl)nodeInfo).getSequenceNumber();
            if (l < l2) {
                return -1;
            }
            if (l > l2) {
                return 1;
            }
            return 0;
        }
        return 0 - nodeInfo.compareOrder(this);
    }

    public int getFingerprint() {
        int n = this.getNameCode();
        if (n == -1) {
            return -1;
        }
        return n & 0xFFFFF;
    }

    public int getNameCode() {
        return this.tree.nameCode[this.nodeNr];
    }

    public String getPrefix() {
        int n = this.tree.nameCode[this.nodeNr];
        if (n < 0) {
            return "";
        }
        if ((n >> 20 & 0xFF) == 0) {
            return "";
        }
        return this.tree.getNamePool().getPrefix(n);
    }

    public String getURI() {
        int n = this.tree.nameCode[this.nodeNr];
        if (n < 0) {
            return "";
        }
        return this.tree.getNamePool().getURI(n);
    }

    public String getDisplayName() {
        int n = this.tree.nameCode[this.nodeNr];
        if (n < 0) {
            return "";
        }
        return this.tree.getNamePool().getDisplayName(n);
    }

    public String getLocalPart() {
        int n = this.tree.nameCode[this.nodeNr];
        if (n < 0) {
            return "";
        }
        return this.tree.getNamePool().getLocalName(n);
    }

    public AxisIterator iterateAxis(byte by) {
        if (by == 3) {
            if (this.hasChildNodes()) {
                return new SiblingEnumeration(this.tree, this, null, true);
            }
            return EmptyIterator.getInstance();
        }
        return this.iterateAxis(by, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        int n = this.getNodeKind();
        switch (by) {
            case 0: {
                return new AncestorEnumeration(this, nodeTest, false);
            }
            case 1: {
                return new AncestorEnumeration(this, nodeTest, true);
            }
            case 2: {
                if (n != 1) {
                    return EmptyIterator.getInstance();
                }
                if (this.tree.alpha[this.nodeNr] < 0) {
                    return EmptyIterator.getInstance();
                }
                return new AttributeEnumeration(this.tree, this.nodeNr, nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new SiblingEnumeration(this.tree, this, nodeTest, true);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (n == 9 && nodeTest instanceof NameTest && nodeTest.getPrimitiveType() == 1) {
                    return ((TinyDocumentImpl)this).getAllElements(nodeTest.getFingerprint());
                }
                if (this.hasChildNodes()) {
                    return new DescendantEnumeration(this.tree, this, nodeTest, false);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                if (this.hasChildNodes()) {
                    return new DescendantEnumeration(this.tree, this, nodeTest, true);
                }
                if (nodeTest.matches(this.getNodeKind(), this.getFingerprint(), this.getTypeAnnotation())) {
                    return SingletonIterator.makeIterator(this);
                }
                return EmptyIterator.getInstance();
            }
            case 6: {
                if (n == 2 || n == 13) {
                    return new FollowingEnumeration(this.tree, (TinyNodeImpl)this.getParent(), nodeTest, true);
                }
                if (this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.getInstance();
                }
                return new FollowingEnumeration(this.tree, this, nodeTest, false);
            }
            case 7: {
                if (n == 2 || n == 13 || this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.getInstance();
                }
                return new SiblingEnumeration(this.tree, this, nodeTest, false);
            }
            case 8: {
                if (n != 1) {
                    return EmptyIterator.getInstance();
                }
                return new NamespaceIterator(this, nodeTest);
            }
            case 9: {
                NodeInfo nodeInfo = this.getParent();
                if (nodeInfo == null) {
                    return EmptyIterator.getInstance();
                }
                if (nodeTest.matches(nodeInfo.getNodeKind(), nodeInfo.getFingerprint(), this.getTypeAnnotation())) {
                    return SingletonIterator.makeIterator(nodeInfo);
                }
                return EmptyIterator.getInstance();
            }
            case 10: {
                if (n == 2 || n == 13) {
                    return new PrecedingEnumeration(this.tree, (TinyNodeImpl)this.getParent(), nodeTest, false);
                }
                if (this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.getInstance();
                }
                return new PrecedingEnumeration(this.tree, this, nodeTest, false);
            }
            case 11: {
                if (n == 2 || n == 13 || this.tree.depth[this.nodeNr] == 0) {
                    return EmptyIterator.getInstance();
                }
                return new PrecedingSiblingEnumeration(this.tree, this, nodeTest);
            }
            case 12: {
                if (nodeTest.matches(this.getNodeKind(), this.getFingerprint(), this.getTypeAnnotation())) {
                    return SingletonIterator.makeIterator(this);
                }
                return EmptyIterator.getInstance();
            }
            case 13: {
                if (n == 9) {
                    return EmptyIterator.getInstance();
                }
                if (n == 2 || n == 13) {
                    TinyNodeImpl tinyNodeImpl = (TinyNodeImpl)this.getParent();
                    return new PrependIterator(tinyNodeImpl, new PrecedingEnumeration(this.tree, tinyNodeImpl, nodeTest, true));
                }
                return new PrecedingEnumeration(this.tree, this, nodeTest, true);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public NodeInfo getParent() {
        if (this.parent != null) {
            return this.parent;
        }
        int n = TinyNodeImpl.getParentNodeNr(this.tree, this.nodeNr);
        this.parent = n == -1 ? null : this.tree.getNode(n);
        return this.parent;
    }

    static final int getParentNodeNr(TinyTree tinyTree, int n) {
        if (tinyTree.depth[n] == 0) {
            return -1;
        }
        int n2 = tinyTree.next[n];
        while (n2 > n) {
            n2 = tinyTree.next[n2];
        }
        return n2;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public String getAttributeValue(int n) {
        return null;
    }

    public NodeInfo getRoot() {
        if (this.tree.depth[this.nodeNr] == 0) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this.tree.getNode(this.tree.getRootNode(this.nodeNr));
    }

    public DocumentInfo getDocumentRoot() {
        NodeInfo nodeInfo = this.getRoot();
        if (nodeInfo instanceof DocumentInfo) {
            return (DocumentInfo)nodeInfo;
        }
        return null;
    }

    public Configuration getConfiguration() {
        return this.tree.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.tree.getNamePool();
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        return null;
    }

    public String generateId() {
        return "d" + this.tree.getDocumentNumber() + NODE_LETTER[this.getNodeKind()] + this.nodeNr;
    }

    public final int getDocumentNumber() {
        return this.tree.getDocumentNumber();
    }
}

