/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTree;

abstract class TinyParentNodeImpl
extends TinyNodeImpl {
    TinyParentNodeImpl() {
    }

    public final boolean hasChildNodes() {
        return this.nodeNr + 1 < this.tree.numberOfNodes && this.tree.depth[this.nodeNr + 1] > this.tree.depth[this.nodeNr];
    }

    public final String getStringValue() {
        return ((Object)TinyParentNodeImpl.getStringValue(this.tree, this.nodeNr)).toString();
    }

    public CharSequence getStringValueCS() {
        return TinyParentNodeImpl.getStringValue(this.tree, this.nodeNr);
    }

    public static final CharSequence getStringValue(TinyTree tinyTree, int n) {
        int n2 = n + 1;
        short s = tinyTree.depth[n];
        if (tinyTree.depth[n2] <= s) {
            return "";
        }
        if (tinyTree.nodeKind[n2] == 3 && tinyTree.depth[n2 + 1] <= s) {
            int n3 = tinyTree.beta[n2];
            int n4 = tinyTree.alpha[n2];
            return new CharSlice(tinyTree.charBuffer, n4, n3);
        }
        FastStringBuffer fastStringBuffer = null;
        while (n2 < tinyTree.numberOfNodes && tinyTree.depth[n2] > s) {
            if (tinyTree.nodeKind[n2] == 3) {
                int n5 = tinyTree.beta[n2];
                int n6 = tinyTree.alpha[n2];
                if (fastStringBuffer == null) {
                    fastStringBuffer = new FastStringBuffer(1024);
                }
                fastStringBuffer.append(tinyTree.charBuffer, n6, n5);
            }
            ++n2;
        }
        if (fastStringBuffer == null) {
            return "";
        }
        return fastStringBuffer.condense();
    }
}

