/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Version;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.value.Value;

public abstract class AbstractTraceListener
implements TraceListener {
    private int indent = 0;
    private NamePool pool;
    private PrintStream out = System.err;
    private static StringBuffer spaceBuffer = new StringBuffer("                ");

    public void open() {
        this.out.println("<trace saxon-version=\"" + Version.getProductVersion() + "\" " + this.getOpeningAttributes() + '>');
        ++this.indent;
    }

    protected abstract String getOpeningAttributes();

    public void close() {
        --this.indent;
        this.out.println("</trace>");
    }

    public void enter(InstructionInfo instructionInfo, XPathContext xPathContext) {
        int n = instructionInfo.getConstructType();
        int n2 = instructionInfo.getObjectNameCode();
        String string = this.tag(n);
        if (string == null) {
            return;
        }
        String string2 = AbstractTraceListener.truncateURI(instructionInfo.getSystemId());
        this.pool = xPathContext.getController().getNamePool();
        String string3 = AbstractTraceListener.spaces(this.indent) + '<' + string;
        String string4 = (String)instructionInfo.getProperty("name");
        if (string4 != null) {
            string3 = string3 + " name=\"" + this.escape(string4) + '\"';
        } else if (n2 != -1) {
            string3 = string3 + " name=\"" + this.escape(this.pool.getDisplayName(n2)) + '\"';
        }
        Iterator iterator = instructionInfo.getProperties();
        while (iterator.hasNext()) {
            int n3;
            String string5 = (String)iterator.next();
            Object object = instructionInfo.getProperty(string5);
            if (string5.startsWith("{") && (n3 = string5.indexOf(125)) > 0) {
                string5 = string5.substring(n3 + 1);
            }
            if (object == null || string5.equals("name") || string5.equals("expression")) continue;
            string3 = string3 + ' ' + string5 + "=\"" + this.escape(object.toString()) + '\"';
        }
        string3 = string3 + " line=\"" + instructionInfo.getLineNumber() + '\"';
        int n4 = instructionInfo.getColumnNumber();
        if (n4 >= 0) {
            string3 = string3 + " column=\"" + instructionInfo.getColumnNumber() + '\"';
        }
        string3 = string3 + " module=\"" + this.escape(string2) + "\">";
        this.out.println(string3);
        ++this.indent;
    }

    public String escape(String string) {
        if (string == null) {
            return "";
        }
        CharSequence charSequence = Value.collapseWhitespace(string);
        StringBuffer stringBuffer = new StringBuffer(charSequence.length() + 10);
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&#34;");
                continue;
            }
            if (c == '\n') {
                stringBuffer.append("&#xA;");
                continue;
            }
            if (c == '\r') {
                stringBuffer.append("&#xD;");
                continue;
            }
            if (c == '\t') {
                stringBuffer.append("&#x9;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public void leave(InstructionInfo instructionInfo) {
        int n = instructionInfo.getConstructType();
        String string = this.tag(n);
        if (string == null) {
            return;
        }
        --this.indent;
        this.out.println(AbstractTraceListener.spaces(this.indent) + "</" + string + '>');
    }

    protected abstract String tag(int var1);

    public void startCurrentItem(Item item) {
        if (item instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)item;
            this.out.println(AbstractTraceListener.spaces(this.indent) + "<source node=\"" + Navigator.getPath(nodeInfo) + "\" line=\"" + nodeInfo.getLineNumber() + "\" file=\"" + AbstractTraceListener.truncateURI(nodeInfo.getSystemId()) + "\">");
        }
        ++this.indent;
    }

    public void endCurrentItem(Item item) {
        --this.indent;
        if (item instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)item;
            this.out.println(AbstractTraceListener.spaces(this.indent) + "</source><!-- " + Navigator.getPath(nodeInfo) + " -->");
        }
    }

    private static String truncateURI(String string) {
        int n;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        while ((n = string2.indexOf(47)) >= 0 && n < string2.length() - 6) {
            string2 = string2.substring(n + 1);
        }
        return string2;
    }

    private static String spaces(int n) {
        while (spaceBuffer.length() < n) {
            spaceBuffer.append(spaceBuffer);
        }
        return spaceBuffer.substring(0, n);
    }

    public void setOutputDestination(PrintStream printStream) {
        this.out = printStream;
    }

    public PrintStream getOutputDestination() {
        return this.out;
    }
}

