/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;

public class KeyManager
implements Serializable {
    private HashMap keyList = new HashMap();
    private transient WeakHashMap docIndexes = new WeakHashMap();

    public KeyManager(Configuration configuration) {
        this.registerIdrefKey(configuration);
    }

    private void registerIdrefKey(Configuration configuration) {
        SchemaType schemaType = BuiltInSchemaFactory.getSchemaType(561);
        SchemaType schemaType2 = BuiltInSchemaFactory.getSchemaType(562);
        NodeTestPattern nodeTestPattern = new NodeTestPattern(new ContentTypeTest(2, schemaType, configuration));
        NodeTestPattern nodeTestPattern2 = new NodeTestPattern(new ContentTypeTest(2, schemaType2, configuration));
        NodeTestPattern nodeTestPattern3 = new NodeTestPattern(new ContentTypeTest(1, schemaType, configuration));
        NodeTestPattern nodeTestPattern4 = new NodeTestPattern(new ContentTypeTest(1, schemaType2, configuration));
        UnionPattern unionPattern = new UnionPattern(nodeTestPattern, nodeTestPattern2);
        UnionPattern unionPattern2 = new UnionPattern(nodeTestPattern3, nodeTestPattern4);
        UnionPattern unionPattern3 = new UnionPattern(unionPattern, unionPattern2);
        Atomizer atomizer = new Atomizer(new ContextItemExpression(), configuration);
        KeyDefinition keyDefinition = new KeyDefinition(unionPattern3, atomizer, null, null);
        try {
            this.setKeyDefinition(562, keyDefinition);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new AssertionError((Object)transformerConfigurationException);
        }
    }

    public void setKeyDefinition(int n, KeyDefinition keyDefinition) throws TransformerConfigurationException {
        Integer n2 = new Integer(n);
        ArrayList<KeyDefinition> arrayList = (ArrayList<KeyDefinition>)this.keyList.get(n2);
        if (arrayList == null) {
            arrayList = new ArrayList<KeyDefinition>();
            this.keyList.put(n2, arrayList);
        } else {
            String string = keyDefinition.getCollationName();
            if (string == null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (((KeyDefinition)arrayList.get(i)).getCollationName() == null) continue;
                    throw new TransformerConfigurationException("All keys with the same name must use the same collation");
                }
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (string.equals(((KeyDefinition)arrayList.get(i)).getCollationName())) continue;
                    throw new TransformerConfigurationException("All keys with the same name must use the same collation");
                }
            }
        }
        arrayList.add(keyDefinition);
    }

    public List getKeyDefinitions(int n) {
        return (List)this.keyList.get(new Integer(n));
    }

    private synchronized HashMap buildIndex(int n, int n2, DocumentInfo documentInfo, XPathContext xPathContext) throws XPathException {
        List list = this.getKeyDefinitions(n);
        if (list == null) {
            DynamicError dynamicError = new DynamicError("Key " + xPathContext.getController().getNamePool().getDisplayName(n) + " has not been defined");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE1260");
            throw dynamicError;
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            this.constructIndex(documentInfo, hashMap, (KeyDefinition)list.get(i), n2, xPathContext, i == 0);
        }
        return hashMap;
    }

    private void constructIndex(DocumentInfo documentInfo, HashMap hashMap, KeyDefinition keyDefinition, int n, XPathContext xPathContext, boolean bl) throws XPathException {
        int n2;
        Pattern pattern = keyDefinition.getMatch();
        Expression expression = keyDefinition.getUse();
        Collator collator = keyDefinition.getCollation();
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(keyDefinition);
        SlotManager slotManager = keyDefinition.getStackFrameMap();
        if (slotManager != null) {
            xPathContextMajor.openStackFrame(slotManager);
        }
        if ((n2 = pattern.getNodeKind()) == 2 || n2 == 0 || n2 == 9) {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = documentInfo.iterateAxis((byte)5);
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (nodeInfo.getNodeKind() == 1) {
                    NodeInfo nodeInfo2;
                    AxisIterator axisIterator2 = nodeInfo.iterateAxis((byte)2);
                    while ((nodeInfo2 = (NodeInfo)axisIterator2.next()) != null) {
                        if (!pattern.matches(nodeInfo2, xPathContextMajor)) continue;
                        this.processKeyNode(nodeInfo2, expression, n, collator, hashMap, xPathContextMajor, bl);
                    }
                    if (n2 != 0 || !pattern.matches(nodeInfo, xPathContextMajor)) continue;
                    this.processKeyNode(nodeInfo, expression, n, collator, hashMap, xPathContextMajor, bl);
                    continue;
                }
                if (!pattern.matches(nodeInfo, xPathContextMajor)) continue;
                this.processKeyNode(nodeInfo, expression, n, collator, hashMap, xPathContextMajor, bl);
            }
        } else {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = documentInfo.iterateAxis((byte)4, pattern.getNodeTest());
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (!(pattern instanceof NodeTestPattern) && !pattern.matches(nodeInfo, xPathContextMajor)) continue;
                this.processKeyNode(nodeInfo, expression, n, collator, hashMap, xPathContextMajor, bl);
            }
        }
    }

    private void processKeyNode(NodeInfo nodeInfo, Expression expression, int n, Collator collator, HashMap hashMap, XPathContext xPathContext, boolean bl) throws XPathException {
        int n2;
        AtomicValue atomicValue;
        AxisIterator axisIterator = SingletonIterator.makeIterator(nodeInfo);
        axisIterator.next();
        xPathContext.setCurrentIterator(axisIterator);
        SequenceIterator sequenceIterator = expression.iterate(xPathContext);
        while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null && Type.isComparable(n2 = atomicValue.getItemType().getPrimitiveType(), n)) {
            Object object;
            if (n == 642) {
                object = collator == null ? atomicValue.getStringValue() : collator.getCollationKey(atomicValue.getStringValue());
            } else if (n == 513) {
                object = collator == null ? atomicValue.getStringValue() : collator.getCollationKey(atomicValue.getStringValue());
            } else {
                if (atomicValue instanceof NumericValue && ((NumericValue)atomicValue).isNaN()) break;
                try {
                    object = atomicValue.convert(n, xPathContext);
                }
                catch (XPathException xPathException) {
                    break;
                }
            }
            ArrayList<NodeInfo> arrayList = (ArrayList<NodeInfo>)hashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<NodeInfo>();
                hashMap.put(object, arrayList);
                arrayList.add(nodeInfo);
                continue;
            }
            if (bl) {
                if (arrayList.get(arrayList.size() - 1) == nodeInfo) continue;
                arrayList.add(nodeInfo);
                continue;
            }
            LocalOrderComparer localOrderComparer = LocalOrderComparer.getInstance();
            for (int i = 0; i < arrayList.size(); ++i) {
                int n3 = localOrderComparer.compare(nodeInfo, (NodeInfo)arrayList.get(i));
                if (n3 > 0) continue;
                if (n3 != 0) {
                    arrayList.add(i, nodeInfo);
                }
                return;
            }
            arrayList.add(nodeInfo);
        }
    }

    public SequenceIterator selectByKey(int n, DocumentInfo documentInfo, AtomicValue atomicValue, XPathContext xPathContext) throws XPathException {
        Object object;
        int n2 = atomicValue.getItemType().getPrimitiveType();
        if (n2 == 532 || n2 == 515 || n2 == 516) {
            n2 = 517;
            atomicValue = atomicValue.convert(n2, xPathContext);
        }
        if ((object = this.getIndex(documentInfo, n, n2)) instanceof String) {
            DynamicError dynamicError = new DynamicError("Key definition is circular");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE0640");
            throw dynamicError;
        }
        HashMap hashMap = (HashMap)object;
        if (hashMap == null) {
            this.putIndex(documentInfo, n, n2, "Under Construction", xPathContext);
            hashMap = this.buildIndex(n, n2, documentInfo, xPathContext);
            this.putIndex(documentInfo, n, n2, hashMap, xPathContext);
        }
        KeyDefinition keyDefinition = (KeyDefinition)this.getKeyDefinitions(n).get(0);
        Collator collator = keyDefinition.getCollation();
        Object object2 = n2 == 513 || n2 == 642 ? (collator == null ? atomicValue.getStringValue() : collator.getCollationKey(atomicValue.getStringValue())) : atomicValue;
        ArrayList arrayList = (ArrayList)hashMap.get(object2);
        if (arrayList == null) {
            return EmptyIterator.getInstance();
        }
        return new ListIterator(arrayList);
    }

    private synchronized void putIndex(DocumentInfo documentInfo, int n, int n2, Object object, XPathContext xPathContext) {
        HashMap hashMap;
        WeakReference weakReference;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap();
        }
        if ((weakReference = (WeakReference)this.docIndexes.get(documentInfo)) == null || weakReference.get() == null) {
            hashMap = new HashMap();
            xPathContext.getController().setUserData(documentInfo, "key-index-list", hashMap);
            this.docIndexes.put(documentInfo, new WeakReference<HashMap>(hashMap));
        } else {
            hashMap = (HashMap)weakReference.get();
        }
        hashMap.put(new Long((long)n << 32 | (long)n2), object);
    }

    private synchronized Object getIndex(DocumentInfo documentInfo, int n, int n2) {
        WeakReference weakReference;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap();
        }
        if ((weakReference = (WeakReference)this.docIndexes.get(documentInfo)) == null) {
            return null;
        }
        HashMap hashMap = (HashMap)weakReference.get();
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(new Long((long)n << 32 | (long)n2));
    }
}

