/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public final class Variable
implements VariableDeclaration,
Binding {
    private String name;
    private ValueRepresentation value;
    private Configuration config;

    private Variable() {
    }

    public static Variable make(String string, Configuration configuration) {
        Variable variable = new Variable();
        variable.name = string;
        variable.config = configuration;
        return variable;
    }

    public boolean isGlobal() {
        return true;
    }

    public String getVariableName() {
        return this.name;
    }

    public int getNameCode() {
        return -1;
    }

    public void setValue(Object object) throws XPathException {
        this.value = Value.convertJavaObjectToXPath(object, SequenceType.ANY_SEQUENCE, this.config);
        if (this.value == null) {
            this.value = EmptySequence.getInstance();
        }
    }

    public void setXPathValue(ValueRepresentation valueRepresentation) {
        this.value = valueRepresentation;
        if (this.value == null) {
            this.value = EmptySequence.getInstance();
        }
    }

    public void registerReference(BindingReference bindingReference) {
        bindingReference.setStaticType(SequenceType.ANY_SEQUENCE, null, 0);
        bindingReference.fixup(this);
    }

    public ValueRepresentation evaluateVariable(XPathContext xPathContext) {
        return this.value;
    }
}

