/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import net.sf.saxon.ConversionContext;
import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public class BuiltInAtomicType
implements AtomicType,
Serializable {
    int fingerprint;
    int baseFingerprint = -1;
    private static ConversionContext dummyConversionContext = new ConversionContext(){

        public int getImplicitTimezone() {
            return 0;
        }
    };

    public BuiltInAtomicType() {
    }

    public BuiltInAtomicType(int n) {
        this.fingerprint = n;
    }

    public AtomicType getCommonAtomicType() {
        return this;
    }

    public final int getValidationStatus() {
        return 3;
    }

    public final int getBlock() {
        return 0;
    }

    public final int getDerivationMethod() {
        return 1;
    }

    public final boolean allowsDerivation(int n) {
        return true;
    }

    public final void setBaseTypeFingerprint(int n) {
        this.baseFingerprint = n;
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public int getNameCode() {
        return this.fingerprint;
    }

    public String getDisplayName() {
        return StandardNames.getDisplayName(this.fingerprint);
    }

    public final boolean isComplexType() {
        return false;
    }

    public final SchemaType getBaseType() {
        if (this.baseFingerprint == -1) {
            return null;
        }
        return BuiltInSchemaFactory.getSchemaType(this.baseFingerprint);
    }

    public boolean matchesItem(Item item) {
        if (item instanceof AtomicValue) {
            AtomicValue atomicValue = (AtomicValue)item;
            AtomicType atomicType = (AtomicType)atomicValue.getItemType();
            if (atomicType.getFingerprint() == this.getFingerprint()) {
                return true;
            }
            return Type.isSubType(atomicType, this);
        }
        return false;
    }

    public ItemType getSuperType() {
        SchemaType schemaType = this.getBaseType();
        if (schemaType instanceof AnySimpleType) {
            return AnyItemType.getInstance();
        }
        return (ItemType)((Object)schemaType);
    }

    public ItemType getPrimitiveItemType() {
        if (Type.isPrimitiveType(this.getFingerprint())) {
            return this;
        }
        ItemType itemType = (ItemType)((Object)this.getBaseType());
        if (itemType instanceof AtomicType) {
            return itemType.getPrimitiveItemType();
        }
        return this;
    }

    public int getPrimitiveType() {
        int n = this.getFingerprint();
        if (Type.isPrimitiveType(n)) {
            return n;
        }
        SchemaType schemaType = this.getBaseType();
        if (schemaType instanceof AtomicType) {
            return ((AtomicType)schemaType).getPrimitiveType();
        }
        return this.getFingerprint();
    }

    public boolean isAllowedInBasicXSLT() {
        int n = this.getFingerprint();
        return Type.isPrimitiveType(n) && n != 531;
    }

    public String toString(NamePool namePool) {
        return this.getDisplayName();
    }

    public AtomicType getAtomizedItemType() {
        return this;
    }

    public SchemaType getKnownBaseType() {
        return this.getBaseType();
    }

    public boolean isSameType(SchemaType schemaType) {
        return schemaType.getFingerprint() == this.getFingerprint();
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public void isTypeDerivationOK(SchemaType schemaType, int n) throws SchemaException, ValidationException {
    }

    public final boolean isSimpleType() {
        return true;
    }

    public boolean isListType() {
        return false;
    }

    public boolean isUnionType() {
        return false;
    }

    public int getWhitespaceAction() {
        if (this.getPrimitiveType() == 513) {
            if (Type.isSubType(this, (ItemType)((Object)BuiltInSchemaFactory.getSchemaType(554)))) {
                return 2;
            }
            if (Type.isSubType(this, (ItemType)((Object)BuiltInSchemaFactory.getSchemaType(553)))) {
                return 1;
            }
            return 0;
        }
        return 2;
    }

    public CharSequence applyWhitespaceNormalization(CharSequence charSequence) throws ValidationException {
        int n = this.getWhitespaceAction();
        switch (n) {
            case 0: {
                return charSequence;
            }
            case 1: {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
                for (int i = 0; i < charSequence.length(); ++i) {
                    if ("\n\r\t".indexOf(charSequence.charAt(i)) >= 0) {
                        fastStringBuffer.append(' ');
                        continue;
                    }
                    fastStringBuffer.append(charSequence.charAt(i));
                }
                return fastStringBuffer;
            }
            case 2: {
                return NormalizeSpace.normalize(((Object)charSequence).toString());
            }
        }
        throw new IllegalArgumentException("Unknown whitespace facet value");
    }

    public SchemaType getBuiltInBaseType() throws ValidationException {
        BuiltInAtomicType builtInAtomicType;
        for (builtInAtomicType = this; builtInAtomicType != null && builtInAtomicType.getFingerprint() > 1023; builtInAtomicType = (BuiltInAtomicType)builtInAtomicType.getBaseType()) {
        }
        return builtInAtomicType;
    }

    public boolean isNamespaceSensitive() {
        BuiltInAtomicType builtInAtomicType = this;
        int n = builtInAtomicType.getFingerprint();
        while (n > 1023) {
            builtInAtomicType = (BuiltInAtomicType)builtInAtomicType.getBaseType();
            n = builtInAtomicType.getFingerprint();
        }
        return n == 530 || n == 531;
    }

    public ValidationException validateContent(CharSequence charSequence, NamespaceResolver namespaceResolver, ConversionContext conversionContext) {
        int n = this.getFingerprint();
        if (n == 513 || n == 573 || n == 642 || n == 643) {
            return null;
        }
        ValidationException validationException = null;
        if (this.isNamespaceSensitive()) {
            if (namespaceResolver == null) {
                throw new UnsupportedOperationException("Cannot validate a QName without a namespace resolver");
            }
            try {
                String[] stringArray = Name.getQNameParts(((Object)charSequence).toString());
                String string = namespaceResolver.getURIForPrefix(stringArray[0], true);
                if (string == null) {
                    validationException = new ValidationException("Namespace prefix " + Err.wrap(stringArray[0]) + " has not been declared");
                }
                new QNameValue(stringArray[0], string, stringArray[1]);
            }
            catch (QNameException qNameException) {
                validationException = new ValidationException("Invalid lexical QName " + Err.wrap(charSequence));
            }
            catch (XPathException xPathException) {
                validationException = new ValidationException(xPathException.getMessage());
            }
        } else {
            AtomicValue atomicValue = new StringValue(charSequence).convert(this, dummyConversionContext, true);
            if (atomicValue instanceof ValidationErrorValue) {
                validationException = new ValidationException("Value " + Err.wrap(charSequence, 4) + " is invalid for type " + this.getDisplayName() + ". " + ((ValidationErrorValue)atomicValue).getException().getMessage());
            }
        }
        return validationException;
    }

    public final SequenceIterator getTypedValue(NodeInfo nodeInfo) throws XPathException {
        try {
            return this.getTypedValue(nodeInfo.getStringValue(), new InscopeNamespaceResolver(nodeInfo), nodeInfo.getConfiguration());
        }
        catch (ValidationException validationException) {
            throw new DynamicError("Internal error: value doesn't match its type annotation. " + validationException.getMessage());
        }
    }

    public SequenceIterator getTypedValue(CharSequence charSequence, NamespaceResolver namespaceResolver, ConversionContext conversionContext) throws ValidationException {
        if (this.fingerprint == 513) {
            return SingletonIterator.makeIterator(new StringValue(charSequence));
        }
        if (this.fingerprint == 642) {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(charSequence));
        }
        AtomicValue atomicValue = new StringValue(charSequence).convert(this, conversionContext, true);
        if (atomicValue instanceof ValidationErrorValue) {
            throw ((ValidationErrorValue)atomicValue).getException();
        }
        return SingletonIterator.makeIterator(atomicValue);
    }

    public AtomicValue makeDerivedValue(AtomicValue atomicValue, CharSequence charSequence, boolean bl) {
        throw new UnsupportedOperationException("makeDerivedValue is not supported for built-in types");
    }

    public void analyzeContentExpression(Expression expression, int n, StaticContext staticContext) throws XPathException {
        BuiltInAtomicType.analyzeContentExpression(this, expression, staticContext, n);
    }

    public static void analyzeContentExpression(SimpleType simpleType, Expression expression, StaticContext staticContext, int n) throws XPathException {
        if (n == 1) {
            expression.checkPermittedContents(simpleType, staticContext, true);
        } else if (n == 2 && (expression instanceof ValueOf || expression instanceof Value)) {
            expression.checkPermittedContents(simpleType, staticContext, true);
        }
    }
}

