/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import net.sf.saxon.ConversionContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringTokenIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.StringValue;

public class BuiltInListType
implements ListType,
Serializable {
    private int fingerprint;
    private BuiltInAtomicType itemType = null;

    public int getWhitespaceAction() {
        return 2;
    }

    public AtomicType getCommonAtomicType() {
        return this.itemType;
    }

    public BuiltInListType(int n) {
        this.fingerprint = n;
        switch (n) {
            case 564: {
                this.itemType = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(563);
                break;
            }
            case 562: {
                this.itemType = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(561);
                break;
            }
            case 557: {
                this.itemType = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(556);
            }
        }
    }

    public int getValidationStatus() {
        return 3;
    }

    public SchemaType getBaseType() {
        return AnySimpleType.getInstance();
    }

    public boolean isListType() {
        return true;
    }

    public boolean isUnionType() {
        return false;
    }

    public SchemaType getBuiltInBaseType() throws ValidationException {
        return this;
    }

    public boolean isNamespaceSensitive() {
        return false;
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public int getNameCode() {
        return this.fingerprint;
    }

    public String getDisplayName() {
        return StandardNames.getDisplayName(this.fingerprint);
    }

    public boolean isComplexType() {
        return false;
    }

    public boolean isSimpleType() {
        return true;
    }

    public int getBlock() {
        return 0;
    }

    public SchemaType getKnownBaseType() throws IllegalStateException {
        return AnySimpleType.getInstance();
    }

    public int getDerivationMethod() {
        return 8;
    }

    public boolean allowsDerivation(int n) {
        return true;
    }

    public SequenceIterator getTypedValue(NodeInfo nodeInfo) throws XPathException {
        try {
            return this.getTypedValue(nodeInfo.getStringValue(), new InscopeNamespaceResolver(nodeInfo), nodeInfo.getConfiguration());
        }
        catch (ValidationException validationException) {
            throw new DynamicError("Internal error: value doesn't match its type annotation. " + validationException.getMessage());
        }
    }

    public boolean isSameType(SchemaType schemaType) {
        return schemaType.getFingerprint() == this.getFingerprint();
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public void isTypeDerivationOK(SchemaType schemaType, int n) throws SchemaException, ValidationException {
    }

    public String getLocalName() {
        return this.getDisplayName().substring(3);
    }

    public SimpleType getItemType() {
        return this.itemType;
    }

    public String applyWhitespaceNormalization(String string) {
        return ((Object)NormalizeSpace.normalize(string)).toString();
    }

    public void analyzeContentExpression(Expression expression, int n, StaticContext staticContext) throws XPathException {
        BuiltInAtomicType.analyzeContentExpression(this, expression, staticContext, n);
    }

    public ValidationException validateContent(CharSequence charSequence, NamespaceResolver namespaceResolver, ConversionContext conversionContext) {
        SimpleType simpleType = this.getItemType();
        StringTokenIterator stringTokenIterator = new StringTokenIterator(((Object)charSequence).toString());
        ValidationException validationException = null;
        try {
            StringValue stringValue;
            while ((stringValue = (StringValue)stringTokenIterator.next()) != null) {
                ValidationException validationException2 = simpleType.validateContent(stringValue.getStringValue(), namespaceResolver, conversionContext);
                if (validationException2 == null) continue;
                return validationException2;
            }
        }
        catch (ValidationException validationException3) {
            validationException = validationException3;
        }
        catch (XPathException xPathException) {
            validationException = new ValidationException(xPathException);
        }
        return validationException;
    }

    public SequenceIterator getTypedValue(CharSequence charSequence, NamespaceResolver namespaceResolver, ConversionContext conversionContext) throws ValidationException {
        StringTokenIterator stringTokenIterator = new StringTokenIterator(((Object)charSequence).toString());
        ListTypeMappingFunction listTypeMappingFunction = new ListTypeMappingFunction();
        listTypeMappingFunction.resolver = namespaceResolver;
        listTypeMappingFunction.atomicType = (AtomicType)this.getItemType();
        return new MappingIterator(stringTokenIterator, listTypeMappingFunction, null);
    }

    private static class ListTypeMappingFunction
    implements MappingFunction {
        public NamespaceResolver resolver;
        public AtomicType atomicType;

        private ListTypeMappingFunction() {
        }

        public Object map(Item item, XPathContext xPathContext) throws XPathException {
            try {
                return this.atomicType.getTypedValue(item.getStringValue(), this.resolver, xPathContext);
            }
            catch (ValidationException validationException) {
                return new DynamicError(validationException);
            }
        }
    }
}

