/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import java.util.Set;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;

public abstract class Type
implements Serializable {
    public static final short ELEMENT = 1;
    public static final short ATTRIBUTE = 2;
    public static final short TEXT = 3;
    public static final short PROCESSING_INSTRUCTION = 7;
    public static final short COMMENT = 8;
    public static final short DOCUMENT = 9;
    public static final short NAMESPACE = 13;
    public static final short STOPPER = 11;
    public static final short NODE = 0;
    public static final ItemType NODE_TYPE = AnyNodeTest.getInstance();
    public static final short ITEM = 88;
    public static final ItemType ITEM_TYPE = AnyItemType.getInstance();
    public static final short MAX_NODE_TYPE = 13;
    public static final short EMPTY = 15;
    public static final int ATOMIC = 643;
    public static final int NUMBER = 646;
    public static final int STRING = 513;
    public static final int BOOLEAN = 514;
    public static final int DECIMAL = 515;
    public static final int FLOAT = 516;
    public static final int DOUBLE = 517;
    public static final int DURATION = 518;
    public static final int DATE_TIME = 519;
    public static final int TIME = 520;
    public static final int DATE = 521;
    public static final int G_YEAR_MONTH = 522;
    public static final int G_YEAR = 523;
    public static final int G_MONTH_DAY = 524;
    public static final int G_DAY = 525;
    public static final int G_MONTH = 526;
    public static final int HEX_BINARY = 527;
    public static final int BASE64_BINARY = 528;
    public static final int ANY_URI = 529;
    public static final int QNAME = 530;
    public static final int NOTATION = 531;
    public static final int UNTYPED_ATOMIC = 642;
    public static final int ANY_SIMPLE_TYPE = 573;
    public static final int OBJECT = 285;
    public static final int INTEGER = 532;
    public static final int NON_POSITIVE_INTEGER = 533;
    public static final int NEGATIVE_INTEGER = 534;
    public static final int LONG = 535;
    public static final int INT = 536;
    public static final int SHORT = 537;
    public static final int BYTE = 538;
    public static final int NON_NEGATIVE_INTEGER = 539;
    public static final int POSITIVE_INTEGER = 540;
    public static final int UNSIGNED_LONG = 541;
    public static final int UNSIGNED_INT = 542;
    public static final int UNSIGNED_SHORT = 543;
    public static final int UNSIGNED_BYTE = 544;
    public static final int NORMALIZED_STRING = 553;
    public static final int TOKEN = 554;
    public static final int LANGUAGE = 555;
    public static final int NMTOKEN = 556;
    public static final int NMTOKENS = 557;
    public static final int NAME = 558;
    public static final int NCNAME = 559;
    public static final int ID = 560;
    public static final int IDREF = 561;
    public static final int IDREFS = 562;
    public static final int ENTITY = 563;
    public static final int YEAR_MONTH_DURATION = 644;
    public static final int DAY_TIME_DURATION = 645;
    public static final BuiltInAtomicType UNTYPED_ATOMIC_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(642);
    public static final BuiltInAtomicType ANY_ATOMIC_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(643);
    public static final BuiltInAtomicType YEAR_MONTH_DURATION_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(644);
    public static final BuiltInAtomicType DAY_TIME_DURATION_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(645);
    public static final BuiltInAtomicType STRING_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(513);
    public static final BuiltInAtomicType BOOLEAN_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(514);
    public static final BuiltInAtomicType DECIMAL_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(515);
    public static final BuiltInAtomicType FLOAT_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(516);
    public static final BuiltInAtomicType DOUBLE_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(517);
    public static final BuiltInAtomicType DURATION_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(518);
    public static final BuiltInAtomicType DATE_TIME_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(519);
    public static final BuiltInAtomicType TIME_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(520);
    public static final BuiltInAtomicType DATE_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(521);
    public static final BuiltInAtomicType G_YEAR_MONTH_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(522);
    public static final BuiltInAtomicType G_YEAR_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(523);
    public static final BuiltInAtomicType G_MONTH_DAY_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(524);
    public static final BuiltInAtomicType G_DAY_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(525);
    public static final BuiltInAtomicType G_MONTH_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(526);
    public static final BuiltInAtomicType HEX_BINARY_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(527);
    public static final BuiltInAtomicType BASE64_BINARY_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(528);
    public static final BuiltInAtomicType ANY_URI_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(529);
    public static final BuiltInAtomicType QNAME_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(530);
    public static final BuiltInAtomicType NOTATION_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(531);
    public static final BuiltInAtomicType INTEGER_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(532);
    public static final BuiltInAtomicType ID_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(560);
    public static final BuiltInAtomicType NCNAME_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(559);
    public static final BuiltInAtomicType NUMBER_TYPE = (BuiltInAtomicType)BuiltInSchemaFactory.getSchemaType(646);
    public static final int SAME_TYPE = 0;
    public static final int SUBSUMES = 1;
    public static final int SUBSUMED_BY = 2;
    public static final int OVERLAPS = 3;
    public static final int DISJOINT = 4;

    private Type() {
    }

    public static boolean isNodeType(ItemType itemType) {
        return itemType instanceof NodeTest;
    }

    public static final String displayTypeName(Item item) {
        if (item instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)item;
            switch (nodeInfo.getNodeKind()) {
                case 9: {
                    return "document-node()";
                }
                case 1: {
                    NamePool namePool = nodeInfo.getNamePool();
                    int n = nodeInfo.getTypeAnnotation();
                    return "element(" + ((NodeInfo)item).getDisplayName() + ", " + (n == -1 ? "xdt:untyped)" : namePool.getDisplayName(n) + ')');
                }
                case 2: {
                    NamePool namePool = nodeInfo.getNamePool();
                    int n = nodeInfo.getTypeAnnotation();
                    return "attribute(" + ((NodeInfo)item).getDisplayName() + ", " + (n == -1 ? "xdt:untypedAtomic)" : namePool.getDisplayName(n) + ')');
                }
                case 3: {
                    return "text()";
                }
                case 8: {
                    return "comment()";
                }
                case 7: {
                    return "processing-instruction()";
                }
                case 13: {
                    return "namespace()";
                }
            }
            return "";
        }
        return ((AtomicValue)item).getItemType().toString();
    }

    public static ItemType getBuiltInItemType(String string, String string2) {
        SchemaType schemaType = BuiltInSchemaFactory.getSchemaType(StandardNames.getFingerprint(string, string2));
        if (schemaType instanceof ItemType) {
            return (ItemType)((Object)schemaType);
        }
        return null;
    }

    public static boolean isSubType(ItemType itemType, ItemType itemType2) {
        int n = Type.relationship(itemType, itemType2);
        return n == 0 || n == 2;
    }

    public static int relationship(ItemType itemType, ItemType itemType2) {
        int n;
        int n2;
        int n3;
        if (itemType == itemType2) {
            return 0;
        }
        if (itemType instanceof AnyItemType) {
            if (itemType2 instanceof AnyItemType) {
                return 0;
            }
            return 1;
        }
        if (itemType2 instanceof AnyItemType) {
            return 2;
        }
        if (itemType instanceof AtomicType) {
            if (itemType2 instanceof NodeTest) {
                return 4;
            }
            if (((AtomicType)itemType).getFingerprint() == ((AtomicType)itemType2).getFingerprint()) {
                return 0;
            }
            ItemType itemType3 = itemType2;
            while (itemType3 instanceof AtomicType) {
                if (((AtomicType)itemType).getFingerprint() == ((AtomicType)itemType3).getFingerprint()) {
                    return 1;
                }
                itemType3 = itemType3.getSuperType();
            }
            itemType3 = itemType;
            while (itemType3 instanceof AtomicType) {
                if (((AtomicType)itemType3).getFingerprint() == ((AtomicType)itemType2).getFingerprint()) {
                    return 2;
                }
                itemType3 = itemType3.getSuperType();
            }
            return 4;
        }
        if (itemType2 instanceof AtomicType) {
            return 4;
        }
        if (itemType instanceof AnyNodeTest) {
            if (itemType2 instanceof AnyNodeTest) {
                return 0;
            }
            return 1;
        }
        if (itemType2 instanceof AnyNodeTest) {
            return 2;
        }
        if (itemType instanceof NoNodeTest) {
            return 4;
        }
        if (itemType2 instanceof NoNodeTest) {
            return 4;
        }
        int n4 = ((NodeTest)itemType).getNodeKindMask();
        if ((n4 & (n3 = ((NodeTest)itemType2).getNodeKindMask())) == 0) {
            return 4;
        }
        int n5 = n4 == n3 ? 0 : ((n4 & n3) == n4 ? 2 : ((n4 & n3) == n3 ? 1 : 3));
        Set set = ((NodeTest)itemType).getRequiredNodeNames();
        Set set2 = ((NodeTest)itemType2).getRequiredNodeNames();
        if (set == null) {
            n2 = set2 == null ? 0 : 1;
        } else if (set2 == null) {
            n2 = 2;
        } else if (set.containsAll(set2)) {
            n2 = ((Object)set).equals(set2) ? 0 : 1;
        } else if (set2.containsAll(set)) {
            n2 = 2;
        } else {
            set2.retainAll(set);
            n2 = set2.size() == 0 ? 4 : 3;
        }
        if (itemType instanceof DocumentNodeTest) {
            n = itemType2 instanceof DocumentNodeTest ? Type.relationship(((DocumentNodeTest)itemType).getElementTest(), ((DocumentNodeTest)itemType2).getElementTest()) : 2;
        } else if (itemType2 instanceof DocumentNodeTest) {
            n = 1;
        } else {
            SchemaType schemaType = ((NodeTest)itemType).getContentType();
            SchemaType schemaType2 = ((NodeTest)itemType2).getContentType();
            n = Type.schemaTypeRelationship(schemaType, schemaType2);
        }
        if (n5 == 0 && n2 == 0 && n == 0) {
            return 0;
        }
        if (!(n5 != 0 && n5 != 1 || n2 != 0 && n2 != 1 || n != 0 && n != 1)) {
            return 1;
        }
        if (!(n5 != 0 && n5 != 2 || n2 != 0 && n2 != 2 || n != 0 && n != 2)) {
            return 2;
        }
        if (n5 == 4 || n2 == 4 || n == 4) {
            return 4;
        }
        return 3;
    }

    public static int schemaTypeRelationship(SchemaType schemaType, SchemaType schemaType2) {
        if (schemaType.isSameType(schemaType2)) {
            return 0;
        }
        if (schemaType instanceof AnyType) {
            return 1;
        }
        if (schemaType2 instanceof AnyType) {
            return 2;
        }
        SchemaType schemaType3 = schemaType;
        while ((schemaType3 = schemaType3.getBaseType()) != null) {
            if (!schemaType3.isSameType(schemaType2)) continue;
            return 2;
        }
        SchemaType schemaType4 = schemaType2;
        while ((schemaType4 = schemaType4.getBaseType()) != null) {
            if (!schemaType4.isSameType(schemaType)) continue;
            return 1;
        }
        return 4;
    }

    public static final ItemType getCommonSuperType(ItemType itemType, ItemType itemType2) {
        if (itemType instanceof NoNodeTest) {
            return itemType2;
        }
        if (itemType2 instanceof NoNodeTest) {
            return itemType;
        }
        int n = Type.relationship(itemType, itemType2);
        if (n == 0) {
            return itemType;
        }
        if (n == 2) {
            return itemType2;
        }
        if (n == 1) {
            return itemType;
        }
        return Type.getCommonSuperType(itemType2.getSuperType(), itemType);
    }

    public static boolean isPrimitiveType(int n) {
        return n >= 0 && (n <= 532 || n == 646 || n == 642 || n == 643 || n == 645 || n == 644 || n == 573);
    }

    public static boolean isComparable(int n, int n2) {
        if (n == 643 || n2 == 643) {
            return true;
        }
        if (n == 642) {
            n = 513;
        }
        if (n2 == 642) {
            n2 = 513;
        }
        if (n == 529) {
            n = 513;
        }
        if (n2 == 529) {
            n2 = 513;
        }
        if (n == 532 || n == 517 || n == 516 || n == 515) {
            n = 646;
        }
        if (n2 == 532 || n2 == 517 || n2 == 516 || n2 == 515) {
            n2 = 646;
        }
        return n == n2;
    }

    public static boolean isOrdered(int n) {
        switch (n) {
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 529: 
            case 532: 
            case 643: 
            case 644: 
            case 645: 
            case 646: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumericPrimitiveType(ItemType itemType) {
        if (itemType instanceof AtomicType) {
            int n = ((AtomicType)itemType).getFingerprint();
            return n == 532 || n == 517 || n == 516 || n == 515 || n == 646;
        }
        return false;
    }
}

