/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.ConversionContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;

public final class BigIntegerValue
extends NumericValue {
    private BigInteger value;
    private ItemType type;
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger MAX_UNSIGNED_LONG = new BigInteger("18446744073709551615");
    public static final BigIntegerValue ZERO = new BigIntegerValue(BigInteger.ZERO);
    static /* synthetic */ Class class$net$sf$saxon$value$IntegerValue;
    static /* synthetic */ Class class$java$math$BigInteger;

    public BigIntegerValue(BigInteger bigInteger) {
        this.value = bigInteger;
        this.type = Type.INTEGER_TYPE;
    }

    public BigIntegerValue(long l) {
        this.value = BigInteger.valueOf(l);
        this.type = Type.INTEGER_TYPE;
    }

    public ValidationException convertToSubType(AtomicType atomicType, boolean bl) {
        if (!bl) {
            this.type = atomicType;
            return null;
        }
        if (IntegerValue.checkBigRange(this.value, atomicType)) {
            this.type = atomicType;
            return null;
        }
        ValidationException validationException = new ValidationException("Integer value is out of range for subtype " + atomicType.getDisplayName());
        validationException.setErrorCode("FORG0001");
        return validationException;
    }

    public static NumericValue makeValue(BigInteger bigInteger) {
        if (bigInteger.compareTo(MAX_LONG) > 0 || bigInteger.compareTo(MIN_LONG) < 0) {
            return new BigIntegerValue(bigInteger);
        }
        return new IntegerValue(bigInteger.longValue());
    }

    public int hashCode() {
        if (this.value.compareTo(MIN_INT) >= 0 && this.value.compareTo(MAX_INT) <= 0) {
            return this.value.intValue();
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public BigInteger getBigInteger() {
        return this.value;
    }

    public boolean isWithinLongRange() {
        return this.value.compareTo(MIN_LONG) >= 0 && this.value.compareTo(MAX_LONG) <= 0;
    }

    public BigDecimal asDecimal() {
        return new BigDecimal(this.value);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.value.compareTo(BigInteger.ZERO) != 0;
    }

    public int compareTo(Object object) {
        if (object instanceof BigIntegerValue) {
            return this.value.compareTo(((BigIntegerValue)object).value);
        }
        if (object instanceof DecimalValue) {
            return this.asDecimal().compareTo(((DecimalValue)object).getValue());
        }
        return super.compareTo(object);
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, ConversionContext conversionContext) {
        switch (builtInAtomicType.getFingerprint()) {
            case 514: {
                return BooleanValue.get(this.effectiveBooleanValue(null));
            }
            case 88: 
            case 532: 
            case 535: 
            case 643: 
            case 646: {
                return this;
            }
            case 533: 
            case 534: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 542: 
            case 543: 
            case 544: {
                if (this.isWithinLongRange()) {
                    IntegerValue integerValue = new IntegerValue(this.longValue());
                    ValidationException validationException = integerValue.convertToSubtype(builtInAtomicType, bl);
                    if (validationException == null) {
                        return integerValue;
                    }
                    return new ValidationErrorValue(validationException);
                }
                BigIntegerValue bigIntegerValue = new BigIntegerValue(this.value);
                ValidationException validationException = bigIntegerValue.convertToSubType(builtInAtomicType, bl);
                if (validationException == null) {
                    return bigIntegerValue;
                }
                return new ValidationErrorValue(validationException);
            }
            case 541: {
                if (this.value.signum() < 0 || this.value.bitLength() > 64) {
                    ValidationException validationException = new ValidationException("Integer value is out of range for type " + builtInAtomicType.getDisplayName());
                    validationException.setErrorCode("FORG0001");
                    return new ValidationErrorValue(validationException);
                }
                if (this.isWithinLongRange()) {
                    IntegerValue integerValue = new IntegerValue(this.longValue());
                    ValidationException validationException = integerValue.convertToSubtype(builtInAtomicType, bl);
                    if (validationException != null) {
                        return new ValidationErrorValue(validationException);
                    }
                    return integerValue;
                }
                BigIntegerValue bigIntegerValue = new BigIntegerValue(this.value);
                ValidationException validationException = bigIntegerValue.convertToSubType(builtInAtomicType, bl);
                if (validationException != null) {
                    return new ValidationErrorValue(validationException);
                }
                return bigIntegerValue;
            }
            case 517: {
                return new DoubleValue(this.value.doubleValue());
            }
            case 516: {
                return new FloatValue(this.value.floatValue());
            }
            case 515: {
                return new DecimalValue(new BigDecimal(this.value));
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert integer to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("FORG0001");
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public NumericValue negate() {
        return new BigIntegerValue(this.value.negate());
    }

    public NumericValue floor() {
        return this;
    }

    public NumericValue ceiling() {
        return this;
    }

    public NumericValue round() {
        return this;
    }

    public NumericValue roundToHalfEven(int n) {
        if (n >= 0) {
            return this;
        }
        BigInteger bigInteger = BigInteger.valueOf(10L).pow(-n);
        BigInteger[] bigIntegerArray = this.value.divideAndRemainder(bigInteger);
        int n2 = bigIntegerArray[1].compareTo(bigInteger.divide(BigInteger.valueOf(2L)));
        if (n2 > 0) {
            bigIntegerArray[0] = bigIntegerArray[0].add(BigInteger.valueOf(1L));
        } else if (n2 == 0 && bigIntegerArray[0].mod(BigInteger.valueOf(2L)).signum() != 0) {
            bigIntegerArray[0] = bigIntegerArray[0].add(BigInteger.valueOf(1L));
        }
        return BigIntegerValue.makeValue(bigIntegerArray[0].multiply(bigInteger));
    }

    public double signum() {
        return this.value.signum();
    }

    public boolean isWholeNumber() {
        return true;
    }

    public NumericValue arithmetic(int n, NumericValue numericValue, XPathContext xPathContext) throws XPathException {
        if (numericValue instanceof BigIntegerValue) {
            BigInteger bigInteger = ((BigIntegerValue)numericValue).value;
            switch (n) {
                case 15: {
                    return BigIntegerValue.makeValue(this.value.add(bigInteger));
                }
                case 16: {
                    return BigIntegerValue.makeValue(this.value.subtract(bigInteger));
                }
                case 17: {
                    return BigIntegerValue.makeValue(this.value.multiply(bigInteger));
                }
                case 50: {
                    try {
                        return BigIntegerValue.makeValue(this.value.divide(bigInteger));
                    }
                    catch (ArithmeticException arithmeticException) {
                        DynamicError dynamicError;
                        if ("/ by zero".equals(arithmeticException.getMessage())) {
                            dynamicError = new DynamicError("Integer division by zero");
                            dynamicError.setErrorCode("FOAR0001");
                        } else {
                            dynamicError = new DynamicError("Integer division failure", arithmeticException);
                        }
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                }
                case 18: {
                    DecimalValue decimalValue = new DecimalValue(new BigDecimal(this.value));
                    DecimalValue decimalValue2 = new DecimalValue(new BigDecimal(bigInteger));
                    return decimalValue.arithmetic(n, decimalValue2, xPathContext);
                }
                case 19: {
                    return BigIntegerValue.makeValue(this.value.remainder(bigInteger));
                }
            }
            throw new UnsupportedOperationException("Unknown operator");
        }
        if (numericValue instanceof IntegerValue) {
            BigIntegerValue bigIntegerValue = new BigIntegerValue(numericValue.longValue());
            return this.arithmetic(n, bigIntegerValue, xPathContext);
        }
        NumericValue numericValue2 = (NumericValue)this.convert(numericValue.getItemType().getPrimitiveType(), xPathContext);
        return numericValue2.arithmetic(n, numericValue, xPathContext);
    }

    public ItemType getItemType() {
        return this.type;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (this.isWithinLongRange()) {
            IntegerValue integerValue = new IntegerValue(this.longValue());
            return integerValue.convertToJava(clazz, xPathContext);
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$IntegerValue == null ? (class$net$sf$saxon$value$IntegerValue = BigIntegerValue.class$("net.sf.saxon.value.IntegerValue")) : class$net$sf$saxon$value$IntegerValue)) {
            return this;
        }
        if (clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = BigIntegerValue.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return this.value;
        }
        return this.convert(515, xPathContext).convertToJava(clazz, xPathContext);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

