/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.StringTokenizer;
import net.sf.saxon.ConversionContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;

public class DurationValue
extends AtomicValue
implements Comparable {
    protected boolean negative = false;
    protected int years = 0;
    protected int months = 0;
    protected int days = 0;
    protected int hours = 0;
    protected int minutes = 0;
    protected int seconds = 0;
    protected int milliseconds = 0;
    static /* synthetic */ Class class$net$sf$saxon$value$DurationValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Object;

    protected DurationValue() {
    }

    public DurationValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)DurationValue.trimWhitespace(charSequence)).toString(), "-+.PYMDTHS", true);
        try {
            String string;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDuration("empty string", charSequence);
            }
            if ("+".equals(string = (String)stringTokenizer.nextElement())) {
                string = (String)stringTokenizer.nextElement();
            } else if ("-".equals(string)) {
                this.negative = true;
                string = (String)stringTokenizer.nextElement();
            }
            if (!"P".equals(string)) {
                this.badDuration("missing 'P'", charSequence);
            }
            int n = 0;
            block10: while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if ("T".equals(string)) {
                    n = 4;
                    string = (String)stringTokenizer.nextElement();
                }
                int n2 = Integer.parseInt(string);
                if (!stringTokenizer.hasMoreElements()) {
                    this.badDuration("missing unit letter at end", charSequence);
                }
                char c = ((String)stringTokenizer.nextElement()).charAt(0);
                switch (c) {
                    case 'Y': {
                        if (n > 0) {
                            this.badDuration("Y is out of sequence", charSequence);
                        }
                        this.years = n2;
                        n = 1;
                        continue block10;
                    }
                    case 'M': {
                        if (n == 4 || n == 5) {
                            this.minutes = n2;
                            n = 6;
                            continue block10;
                        }
                        if (n == 0 || n == 1) {
                            this.months = n2;
                            n = 2;
                            continue block10;
                        }
                        this.badDuration("M is out of sequence", charSequence);
                    }
                    case 'D': {
                        if (n > 2) {
                            this.badDuration("D is out of sequence", charSequence);
                        }
                        this.days = n2;
                        n = 3;
                        continue block10;
                    }
                    case 'H': {
                        if (n != 4) {
                            this.badDuration("H is out of sequence", charSequence);
                        }
                        this.hours = n2;
                        n = 5;
                        continue block10;
                    }
                    case '.': {
                        if (n < 4 || n > 6) {
                            this.badDuration("misplaced decimal point", charSequence);
                        }
                        this.seconds = n2;
                        n = 7;
                        continue block10;
                    }
                    case 'S': {
                        if (n < 4 || n > 7) {
                            this.badDuration("S is out of sequence", charSequence);
                        }
                        if (n == 7) {
                            while (string.length() < 3) {
                                string = string + "0";
                            }
                            if (string.length() > 3) {
                                string = string.substring(0, 3);
                            }
                            this.milliseconds = Integer.parseInt(string);
                        } else {
                            this.seconds = n2;
                        }
                        n = 8;
                        continue block10;
                    }
                }
                this.badDuration("misplaced " + c, charSequence);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.badDuration("non-numeric component", charSequence);
        }
    }

    protected void badDuration(String string, CharSequence charSequence) throws XPathException {
        DynamicError dynamicError = new DynamicError("Invalid duration value '" + charSequence + "' (" + string + ')');
        dynamicError.setErrorCode("FORG0001");
        throw dynamicError;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, ConversionContext conversionContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 518: 
            case 643: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
            case 644: {
                if (this.days != 0 || this.hours != 0 || this.minutes != 0 || this.seconds != 0 || this.milliseconds != 0) {
                    ValidationException validationException = new ValidationException("Cannot convert to yearMonthDuration because some components are non-zero");
                    validationException.setErrorCode("FORG0001");
                    return new ValidationErrorValue(validationException);
                }
                return MonthDurationValue.fromMonths((this.years * 12 + this.months) * (this.negative ? -1 : 1));
            }
            case 645: {
                if (this.years != 0 || this.months != 0) {
                    ValidationException validationException = new ValidationException("Cannot convert to dayTimeDuration because some components are non-zero");
                    validationException.setErrorCode("FORG0001");
                    return new ValidationErrorValue(validationException);
                }
                return new SecondsDurationValue(this.negative ? -1 : 1, this.days, this.hours, this.minutes, this.seconds, this.milliseconds);
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert duration to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("FORG0001");
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        if (this.negative) {
            fastStringBuffer.append('-');
        }
        fastStringBuffer.append("P" + this.years + 'Y');
        fastStringBuffer.append(this.months + "M");
        fastStringBuffer.append(this.days + "DT");
        fastStringBuffer.append(this.hours + "H");
        fastStringBuffer.append(this.minutes + "M");
        fastStringBuffer.append(this.seconds + "");
        if (this.milliseconds != 0) {
            fastStringBuffer.append('.');
            DateTimeValue.appendString(fastStringBuffer, this.milliseconds, 3);
        }
        fastStringBuffer.append('S');
        return fastStringBuffer.toString();
    }

    public double getLengthInSeconds() {
        double d = this.years;
        d = d * 12.0 + (double)this.months;
        d = d * 30.43684991666667 + (double)this.days;
        d = d * 24.0 + (double)this.hours;
        d = d * 60.0 + (double)this.minutes;
        d = d * 60.0 + (double)this.seconds;
        return this.negative ? -d : (d += (double)this.milliseconds / 1000.0);
    }

    public ItemType getItemType() {
        return Type.DURATION_TYPE;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = DurationValue.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DurationValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DurationValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DurationValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            DynamicError dynamicError = new DynamicError("Conversion of duration to " + clazz.getName() + " is not supported");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("SAXON:0000");
        }
        return object;
    }

    public AtomicValue getComponent(int n) throws XPathException {
        switch (n) {
            case 1: {
                return new IntegerValue(this.negative ? -this.years : this.years);
            }
            case 2: {
                return new IntegerValue(this.negative ? -this.months : this.months);
            }
            case 3: {
                return new IntegerValue(this.negative ? -this.days : this.days);
            }
            case 4: {
                return new IntegerValue(this.negative ? -this.hours : this.hours);
            }
            case 5: {
                return new IntegerValue(this.negative ? -this.minutes : this.minutes);
            }
            case 6: {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
                String string = "000" + this.milliseconds;
                string = string.substring(string.length() - 3);
                fastStringBuffer.append((this.negative ? "-" : "") + this.seconds + '.' + string);
                return DecimalValue.makeDecimalValue(fastStringBuffer, false);
            }
        }
        throw new IllegalArgumentException("Unknown component for duration: " + n);
    }

    public int compareTo(Object object) {
        double d;
        if (!(object instanceof DurationValue)) {
            throw new ClassCastException("Duration values are not comparable to " + object.getClass());
        }
        double d2 = this.getLengthInSeconds();
        if (d2 == (d = ((DurationValue)object).getLengthInSeconds())) {
            return 0;
        }
        if (d2 < d) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return new Double(this.getLengthInSeconds()).hashCode();
    }

    public DurationValue add(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        throw new DynamicError("Only subtypes of xs:duration can be added");
    }

    public DurationValue subtract(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        throw new DynamicError("Only subtypes of xs:duration can be subtracted");
    }

    public DurationValue multiply(double d, XPathContext xPathContext) throws XPathException {
        throw new DynamicError("Only subtypes of xs:duration can be multiplied by a number");
    }

    public DoubleValue divide(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        throw new DynamicError("Only subtypes of xs:duration can be divided by another duration");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

