/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import net.sf.saxon.ConversionContext;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public final class FloatValue
extends NumericValue {
    private float value;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$DoubleValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;

    public FloatValue(CharSequence charSequence) throws DynamicError {
        try {
            this.value = (float)Value.stringToNumber(charSequence);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DynamicError("Cannot convert string " + Err.wrap(charSequence, 4) + " to a float");
        }
    }

    public FloatValue(float f) {
        this.value = f;
    }

    public float getValue() {
        return this.value;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.value > -2.1474836E9f && this.value < 2.1474836E9f) {
            return (int)this.value;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return (double)this.value != 0.0 && !Float.isNaN(this.value);
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, ConversionContext conversionContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 514: {
                return BooleanValue.get((double)this.value != 0.0 && !Float.isNaN(this.value));
            }
            case 88: 
            case 516: 
            case 643: 
            case 646: {
                return this;
            }
            case 532: {
                if (Float.isNaN(this.value)) {
                    ValidationException validationException = new ValidationException("Cannot convert float NaN to an integer");
                    validationException.setErrorCode("FORG0001");
                    return new ValidationErrorValue(validationException);
                }
                if (Float.isInfinite(this.value)) {
                    ValidationException validationException = new ValidationException("Cannot convert float infinity to an integer");
                    validationException.setErrorCode("FORG0001");
                    return new ValidationErrorValue(validationException);
                }
                if (this.value > 9.223372E18f || this.value < -9.223372E18f) {
                    return new BigIntegerValue(new BigDecimal(this.value).toBigInteger());
                }
                return new IntegerValue((long)this.value);
            }
            case 515: {
                try {
                    return new DecimalValue(this.value);
                }
                catch (ValidationException validationException) {
                    return new ValidationErrorValue(validationException);
                }
            }
            case 517: {
                return new DoubleValue(this.value);
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert float to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("FORG0001");
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        return DoubleValue.doubleToString(this.value, Float.toString(this.value));
    }

    public ItemType getItemType() {
        return Type.FLOAT_TYPE;
    }

    public NumericValue negate() {
        return new FloatValue(-this.value);
    }

    public NumericValue floor() {
        return new FloatValue((float)Math.floor(this.value));
    }

    public NumericValue ceiling() {
        return new FloatValue((float)Math.ceil(this.value));
    }

    public NumericValue round() {
        if (Float.isNaN(this.value)) {
            return this;
        }
        if (Float.isInfinite(this.value)) {
            return this;
        }
        if ((double)this.value == 0.0) {
            return this;
        }
        if ((double)this.value > -0.5 && (double)this.value < 0.0) {
            return new DoubleValue(-0.0);
        }
        if (this.value > -2.1474836E9f && this.value < 2.1474836E9f) {
            return new FloatValue(Math.round(this.value));
        }
        return this;
    }

    public NumericValue roundToHalfEven(int n) {
        try {
            return (FloatValue)new DoubleValue(this.value).roundToHalfEven(n).convert(516, null);
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)xPathException);
        }
    }

    public double signum() {
        if (Float.isNaN(this.value)) {
            return this.value;
        }
        if (this.value > 0.0f) {
            return 1.0;
        }
        if (this.value == 0.0f) {
            return 0.0;
        }
        return -1.0;
    }

    public boolean isWholeNumber() {
        return (double)this.value == Math.floor(this.value);
    }

    public NumericValue arithmetic(int n, NumericValue numericValue, XPathContext xPathContext) throws XPathException {
        if (numericValue instanceof FloatValue) {
            switch (n) {
                case 15: {
                    return new FloatValue(this.value + ((FloatValue)numericValue).value);
                }
                case 16: {
                    return new FloatValue(this.value - ((FloatValue)numericValue).value);
                }
                case 17: {
                    return new FloatValue(this.value * ((FloatValue)numericValue).value);
                }
                case 18: {
                    return new FloatValue(this.value / ((FloatValue)numericValue).value);
                }
                case 50: {
                    if ((double)((FloatValue)numericValue).value == 0.0) {
                        DynamicError dynamicError = new DynamicError("Integer division by zero");
                        dynamicError.setErrorCode("FOAR0001");
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                    return (NumericValue)new FloatValue(this.value / ((FloatValue)numericValue).value).convert(532, xPathContext);
                }
                case 19: {
                    return new FloatValue(this.value % ((FloatValue)numericValue).value);
                }
            }
            throw new UnsupportedOperationException("Unknown operator");
        }
        if (numericValue instanceof DoubleValue) {
            return ((DoubleValue)this.convert(517, xPathContext)).arithmetic(n, numericValue, xPathContext);
        }
        return this.arithmetic(n, (FloatValue)numericValue.convert(516, xPathContext), xPathContext);
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = FloatValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return new Double(this.value);
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DoubleValue == null ? (class$net$sf$saxon$value$DoubleValue = FloatValue.class$("net.sf.saxon.value.DoubleValue")) : class$net$sf$saxon$value$DoubleValue)) {
            return this;
        }
        if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = FloatValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return (double)this.value != 0.0 && !Float.isNaN(this.value);
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = FloatValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = FloatValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = FloatValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = FloatValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.value);
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = FloatValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long((long)this.value);
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = FloatValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)this.value);
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = FloatValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)this.value);
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = FloatValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((byte)this.value);
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = FloatValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character((char)this.value);
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            DynamicError dynamicError = new DynamicError("Conversion of float to " + clazz.getName() + " is not supported");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("SAXON:0000");
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

