/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.ConversionContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;

public class HexBinaryValue
extends AtomicValue {
    private byte[] binaryValue;
    static /* synthetic */ Class class$net$sf$saxon$value$HexBinaryValue;
    static /* synthetic */ Class class$java$lang$String;

    public HexBinaryValue(CharSequence charSequence) throws XPathException {
        if ((charSequence.length() & 1) != 0) {
            DynamicError dynamicError = new DynamicError("A hexBinary value must contain an even number of characters");
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
        this.binaryValue = new byte[charSequence.length() / 2];
        for (int i = 0; i < this.binaryValue.length; ++i) {
            this.binaryValue[i] = (byte)((this.fromHex(charSequence.charAt(2 * i)) << 4) + this.fromHex(charSequence.charAt(2 * i + 1)));
        }
    }

    public HexBinaryValue(byte[] byArray) {
        this.binaryValue = byArray;
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    private int fromHex(char c) throws XPathException {
        int n = "0123456789ABCDEFabcdef".indexOf(c);
        if (n > 15) {
            n -= 6;
        }
        if (n < 0) {
            DynamicError dynamicError = new DynamicError("Invalid hexadecimal digit");
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
        return n;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, ConversionContext conversionContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 527: 
            case 643: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
            case 528: {
                return new Base64BinaryValue(this.binaryValue);
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert hexBinarry to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("FORG0001");
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        String string = "0123456789ABCDEF";
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.binaryValue.length * 2);
        for (int i = 0; i < this.binaryValue.length; ++i) {
            fastStringBuffer.append(string.charAt(this.binaryValue[i] >> 4 & 0xF));
            fastStringBuffer.append(string.charAt(this.binaryValue[i] & 0xF));
        }
        return fastStringBuffer.toString();
    }

    public ItemType getItemType() {
        return Type.HEX_BINARY_TYPE;
    }

    public int getLengthInOctets() {
        return this.binaryValue.length;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$HexBinaryValue == null ? (class$net$sf$saxon$value$HexBinaryValue = HexBinaryValue.class$("net.sf.saxon.value.HexBinaryValue")) : class$net$sf$saxon$value$HexBinaryValue)) {
            return this;
        }
        if (clazz.isAssignableFrom(class$java$lang$String == null ? (class$java$lang$String = HexBinaryValue.class$("java.lang.String")) : class$java$lang$String)) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of hexBinary to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public boolean equals(Object object) {
        HexBinaryValue hexBinaryValue;
        if (object instanceof HexBinaryValue) {
            hexBinaryValue = (HexBinaryValue)object;
        } else if (object instanceof AtomicValue) {
            try {
                hexBinaryValue = (HexBinaryValue)((AtomicValue)object).convert(527, null);
            }
            catch (XPathException xPathException) {
                return false;
            }
        } else {
            return false;
        }
        if (this.binaryValue.length != hexBinaryValue.binaryValue.length) {
            return false;
        }
        for (int i = 0; i < this.binaryValue.length; ++i) {
            if (this.binaryValue[i] == hexBinaryValue.binaryValue[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Base64BinaryValue.byteArrayHashCode(this.binaryValue);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

