/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TeeOutputter;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public final class MemoClosure
extends Closure {
    private Item[] reservoir = null;
    private int used;
    private int state;
    private static final int UNREAD = 0;
    private static final int MAYBE_MORE = 1;
    private static final int ALL_READ = 3;
    private static final int BUSY = 4;

    MemoClosure() {
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        switch (this.state) {
            case 0: {
                this.state = 4;
                this.inputIterator = this.expression.iterate(this.savedXPathContext);
                this.reservoir = new Item[50];
                this.used = 0;
                this.state = 1;
                return new ProgressiveIterator();
            }
            case 1: {
                return new ProgressiveIterator();
            }
            case 3: {
                return new ArrayIterator(this.reservoir, 0, this.used);
            }
            case 4: {
                throw new DynamicError("Attempt to access a lazily-evaluated variable while it is being evaluated");
            }
        }
        throw new IllegalStateException("Unknown iterator state");
    }

    public void process(XPathContext xPathContext) throws XPathException {
        if (this.reservoir != null) {
            Item item;
            SequenceIterator sequenceIterator = this.iterate(xPathContext);
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            while ((item = sequenceIterator.next()) != null) {
                sequenceReceiver.append(item, 0, 2);
            }
        } else {
            Controller controller = xPathContext.getController();
            XPathContextMinor xPathContextMinor = this.savedXPathContext.newMinorContext();
            SequenceOutputter sequenceOutputter = new SequenceOutputter();
            sequenceOutputter.setPipelineConfiguration(controller.makePipelineConfiguration());
            sequenceOutputter.open();
            TeeOutputter teeOutputter = new TeeOutputter(xPathContext.getReceiver(), sequenceOutputter);
            teeOutputter.setPipelineConfiguration(controller.makePipelineConfiguration());
            xPathContextMinor.setTemporaryReceiver(teeOutputter);
            this.expression.process(xPathContextMinor);
            sequenceOutputter.close();
            ArrayList arrayList = sequenceOutputter.getList();
            this.reservoir = new Item[arrayList.size()];
            this.reservoir = arrayList.toArray(this.reservoir);
            this.used = arrayList.size();
            this.state = 3;
            this.savedXPathContext = null;
        }
    }

    public Item itemAt(int n) throws XPathException {
        if (n < 0) {
            return null;
        }
        if (this.reservoir != null && n < this.used) {
            return this.reservoir[n];
        }
        if (this.state == 3) {
            return null;
        }
        if (this.state == 0) {
            return super.itemAt(n);
        }
        int n2 = n - this.used + 1;
        while (n2-- > 0) {
            Item item = this.inputIterator.next();
            if (item == null) {
                this.state = 3;
                this.condense();
                return this.itemAt(n);
            }
            this.append(item);
            this.state = 1;
        }
        return this.reservoir[n];
    }

    public int getLength() throws XPathException {
        if (this.state == 3) {
            return this.used;
        }
        return super.getLength();
    }

    private void append(Item item) {
        if (this.used >= this.reservoir.length) {
            Item[] itemArray = new Item[this.used * 2];
            System.arraycopy(this.reservoir, 0, itemArray, 0, this.used);
            this.reservoir = itemArray;
        }
        this.reservoir[this.used++] = item;
    }

    private void condense() {
        if (this.reservoir.length - this.used > 30) {
            Item[] itemArray = new Item[this.used];
            System.arraycopy(this.reservoir, 0, itemArray, 0, this.used);
            this.reservoir = itemArray;
        }
        this.savedXPathContext = null;
    }

    public final class ProgressiveIterator
    implements SequenceIterator,
    LastPositionFinder,
    GroundedIterator {
        int position = -1;

        public Item next() throws XPathException {
            if (this.position == -2) {
                return null;
            }
            if (++this.position < MemoClosure.this.used) {
                return MemoClosure.this.reservoir[this.position];
            }
            Item item = MemoClosure.this.inputIterator.next();
            if (item == null) {
                MemoClosure.this.state = 3;
                MemoClosure.this.condense();
                this.position = -2;
                return null;
            }
            this.position = MemoClosure.this.used;
            MemoClosure.this.append(item);
            MemoClosure.this.state = 1;
            return item;
        }

        public Item current() {
            if (this.position < 0) {
                return null;
            }
            return MemoClosure.this.reservoir[this.position];
        }

        public int position() {
            return this.position + 1;
        }

        public SequenceIterator getAnother() {
            return new ProgressiveIterator();
        }

        public int getLastPosition() throws XPathException {
            Item item;
            if (MemoClosure.this.state == 3) {
                return MemoClosure.this.used;
            }
            int n = this.position;
            while ((item = this.next()) != null) {
            }
            this.position = n;
            return MemoClosure.this.used;
        }

        public Value materialize() throws XPathException {
            if (MemoClosure.this.state == 3) {
                return new SequenceExtent(MemoClosure.this.reservoir);
            }
            if (MemoClosure.this.state == 0 || MemoClosure.this.used == 0) {
                SequenceIterator sequenceIterator = MemoClosure.this.expression.iterate(MemoClosure.this.savedXPathContext);
                if (sequenceIterator instanceof GroundedIterator) {
                    return ((GroundedIterator)sequenceIterator).materialize();
                }
                return new SequenceExtent(sequenceIterator);
            }
            return new SequenceExtent(MemoClosure.this.iterate(null));
        }
    }
}

