/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.StringTokenizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;

public final class MonthDurationValue
extends DurationValue
implements Comparable {
    static /* synthetic */ Class class$net$sf$saxon$value$DurationValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Object;

    private MonthDurationValue() {
    }

    public MonthDurationValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)MonthDurationValue.trimWhitespace(charSequence)).toString(), "-+PYM", true);
        try {
            String string;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDuration("empty string", charSequence);
            }
            if ("+".equals(string = (String)stringTokenizer.nextElement())) {
                string = (String)stringTokenizer.nextElement();
            } else if ("-".equals(string)) {
                this.negative = true;
                string = (String)stringTokenizer.nextElement();
            }
            if (!"P".equals(string)) {
                this.badDuration("missing 'P'", charSequence);
            }
            int n = 0;
            block6: while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if ("T".equals(string)) {
                    n = 4;
                    string = (String)stringTokenizer.nextElement();
                }
                int n2 = Integer.parseInt(string);
                if (!stringTokenizer.hasMoreElements()) {
                    this.badDuration("missing unit letter at end", charSequence);
                }
                char c = ((String)stringTokenizer.nextElement()).charAt(0);
                switch (c) {
                    case 'Y': {
                        if (n > 0) {
                            this.badDuration("Y is out of sequence", charSequence);
                        }
                        this.years = n2;
                        n = 1;
                        continue block6;
                    }
                    case 'M': {
                        if (n == 4 || n == 5) {
                            this.minutes = n2;
                            n = 6;
                            continue block6;
                        }
                        if (n == 0 || n == 1) {
                            this.months = n2;
                            n = 2;
                            continue block6;
                        }
                        this.badDuration("M is out of sequence", charSequence);
                    }
                }
                this.badDuration("misplaced " + c, charSequence);
            }
            this.normalize();
        }
        catch (NumberFormatException numberFormatException) {
            this.badDuration("non-numeric component", charSequence);
        }
    }

    public String getStringValue() {
        int n = this.years * 12 + this.months;
        int n2 = n / 12;
        int n3 = n % 12;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        if (this.negative) {
            fastStringBuffer.append('-');
        }
        fastStringBuffer.append('P');
        if (n2 != 0) {
            fastStringBuffer.append(n2 + "Y");
        }
        if (n3 != 0 || n2 == 0) {
            fastStringBuffer.append(n3 + "M");
        }
        return fastStringBuffer.toString();
    }

    public void normalize() {
        if (this.months >= 12) {
            this.years += this.months / 12;
            this.months %= 12;
        }
    }

    public int getLengthInMonths() {
        return (this.years * 12 + this.months) * (this.negative ? -1 : 1);
    }

    public static MonthDurationValue fromMonths(int n) {
        MonthDurationValue monthDurationValue = new MonthDurationValue();
        monthDurationValue.negative = n < 0;
        monthDurationValue.months = n < 0 ? -n : n;
        monthDurationValue.normalize();
        return monthDurationValue;
    }

    public DurationValue multiply(double d, XPathContext xPathContext) {
        return MonthDurationValue.fromMonths((int)((double)this.getLengthInMonths() * d));
    }

    public DoubleValue divide(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        if (durationValue instanceof MonthDurationValue) {
            return new DoubleValue((double)this.getLengthInMonths() / (double)((MonthDurationValue)durationValue).getLengthInMonths());
        }
        throw new DynamicError("Cannot divide two durations of different type");
    }

    public DurationValue add(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        if (durationValue instanceof MonthDurationValue) {
            return MonthDurationValue.fromMonths(this.getLengthInMonths() + ((MonthDurationValue)durationValue).getLengthInMonths());
        }
        throw new DynamicError("Cannot add two durations of different type");
    }

    public DurationValue subtract(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        if (durationValue instanceof MonthDurationValue) {
            return MonthDurationValue.fromMonths(this.getLengthInMonths() - ((MonthDurationValue)durationValue).getLengthInMonths());
        }
        throw new DynamicError("Cannot subtract two durations of different type");
    }

    public ItemType getItemType() {
        return Type.YEAR_MONTH_DURATION_TYPE;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = MonthDurationValue.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = MonthDurationValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = MonthDurationValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = MonthDurationValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        throw new DynamicError("Conversion of yearMonthDuration to " + clazz.getName() + " is not supported");
    }

    public int compareTo(Object object) {
        if (object instanceof MonthDurationValue) {
            return this.getLengthInMonths() - ((MonthDurationValue)object).getLengthInMonths();
        }
        return super.compareTo(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

