/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Pattern;
import net.sf.saxon.ConversionContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;

public final class RestrictedStringValue
extends StringValue {
    private int type;

    public static AtomicValue makeRestrictedString(CharSequence charSequence, int n, boolean bl) {
        RestrictedStringValue restrictedStringValue = new RestrictedStringValue();
        restrictedStringValue.type = n;
        if (charSequence == null) {
            restrictedStringValue.value = "";
        } else if (n == 553) {
            restrictedStringValue.value = RestrictedStringValue.normalizeWhitespace(charSequence);
        } else if (n == 554) {
            restrictedStringValue.value = RestrictedStringValue.collapseWhitespace(charSequence);
        } else {
            restrictedStringValue.value = RestrictedStringValue.trimWhitespace(charSequence);
            if (bl) {
                ValidationException validationException = restrictedStringValue.validate();
                if (validationException == null) {
                    return restrictedStringValue;
                }
                return new ValidationErrorValue(validationException);
            }
            return restrictedStringValue;
        }
        return restrictedStringValue;
    }

    private ValidationException validate() {
        switch (this.type) {
            case 554: {
                return null;
            }
            case 553: {
                return null;
            }
            case 555: {
                String string = "(([a-z]|[A-Z])([a-z]|[A-Z])|([iI]-([a-z]|[A-Z])+)|([xX]-([a-z]|[A-Z])+))(-([a-z]|[A-Z])+)*";
                if (!Pattern.matches(string, ((Object)this.value).toString())) {
                    ValidationException validationException = new ValidationException("The value '" + this.value + "' is not a valid xs:language");
                    validationException.setErrorCode("FORG0001");
                    return validationException;
                }
                return null;
            }
            case 558: {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(this.value.length());
                fastStringBuffer.append(((Object)this.value).toString());
                for (int i = 0; i < fastStringBuffer.length(); ++i) {
                    if (fastStringBuffer.charAt(i) != ':') continue;
                    fastStringBuffer.setCharAt(i, '_');
                }
                if (!XMLChar.isValidNCName(fastStringBuffer.toString())) {
                    ValidationException validationException = new ValidationException("The value '" + this.value + "' is not a valid Name");
                    validationException.setErrorCode("FORG0001");
                    return validationException;
                }
                return null;
            }
            case 559: 
            case 560: 
            case 561: 
            case 563: {
                if (!XMLChar.isValidNCName(((Object)this.value).toString())) {
                    ValidationException validationException = new ValidationException("The value '" + this.value + "' is not a valid NCName");
                    validationException.setErrorCode("FORG0001");
                    return validationException;
                }
                return null;
            }
            case 556: {
                if (!XMLChar.isValidNmtoken(((Object)this.value).toString())) {
                    ValidationException validationException = new ValidationException("The value '" + this.value + "' is not a valid NMTOKEN");
                    validationException.setErrorCode("FORG0001");
                    return validationException;
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown string value type " + this.type);
    }

    public ItemType getItemType() {
        return (AtomicType)BuiltInSchemaFactory.getSchemaType(this.type);
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, ConversionContext conversionContext) {
        int n = builtInAtomicType.getPrimitiveType();
        if (n == 513) {
            return new StringValue(this.value);
        }
        if (n == 642) {
            return new UntypedAtomicValue(this.value);
        }
        return super.convertPrimitive(builtInAtomicType, bl, conversionContext);
    }

    public String toString() {
        return this.getItemType().toString() + '(' + super.toString() + ')';
    }
}

