/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.List;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ReverseArrayIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Value;

public final class SequenceExtent
extends Value {
    private Item[] value;
    private int start = 0;
    private int end;
    private ItemType itemType = null;

    public SequenceExtent(Item[] itemArray) {
        this.value = itemArray;
        this.end = itemArray.length;
    }

    public SequenceExtent(SequenceExtent sequenceExtent, int n, int n2) {
        this.value = sequenceExtent.value;
        this.start = sequenceExtent.start + n;
        this.end = this.start + n2;
    }

    public SequenceExtent(List list) {
        this.value = new Item[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.value[i] = (Item)list.get(i);
        }
        this.end = list.size();
    }

    public SequenceExtent(SequenceIterator sequenceIterator) throws XPathException {
        Item item;
        int n = 20;
        this.value = new Item[n];
        int n2 = 0;
        while ((item = sequenceIterator.next()) != null) {
            if (n2 >= n) {
                Item[] itemArray = new Item[n *= 2];
                System.arraycopy(this.value, 0, itemArray, 0, n2);
                this.value = itemArray;
            }
            this.value[n2++] = item;
        }
        this.end = n2;
    }

    public static Value makeSequenceExtent(SequenceIterator sequenceIterator) throws XPathException {
        if (sequenceIterator instanceof GroundedIterator) {
            return ((GroundedIterator)sequenceIterator).materialize();
        }
        return new SequenceExtent(sequenceIterator);
    }

    public int getImplementationMethod() {
        return 2;
    }

    public Value simplify() {
        int n = this.getLength();
        if (n == 0) {
            return EmptySequence.getInstance();
        }
        if (n == 1) {
            return Value.asValue(this.itemAt(0));
        }
        return this;
    }

    public Value reduce() {
        return this.simplify();
    }

    public int getLength() {
        return this.end - this.start;
    }

    public int getCardinality() {
        switch (this.end - this.start) {
            case 0: {
                return 8192;
            }
            case 1: {
                return 16384;
            }
        }
        return 49152;
    }

    public ItemType getItemType() {
        if (this.itemType != null) {
            return this.itemType;
        }
        if (this.end == this.start) {
            this.itemType = AnyItemType.getInstance();
        } else {
            this.itemType = SequenceExtent.computeItemType(this.value[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                if (this.itemType == AnyItemType.getInstance()) {
                    return this.itemType;
                }
                this.itemType = Type.getCommonSuperType(this.itemType, SequenceExtent.computeItemType(this.value[i]));
            }
        }
        return this.itemType;
    }

    private static ItemType computeItemType(Item item) {
        if (item instanceof AtomicValue) {
            return ((AtomicValue)item).getItemType();
        }
        return NodeKindTest.makeNodeKindTest(((NodeInfo)item).getNodeKind());
    }

    public Item itemAt(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        return this.value[this.start + n];
    }

    public void swap(int n, int n2) {
        Item item = this.value[this.start + n];
        this.value[this.start + n] = this.value[this.start + n2];
        this.value[this.start + n2] = item;
    }

    public SequenceIterator iterate(XPathContext xPathContext) {
        return new ArrayIterator(this.value, this.start, this.end);
    }

    public AxisIterator reverseIterate() {
        return new ReverseArrayIterator(this.value, this.start, this.end);
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        int n = this.getLength();
        if (n == 0) {
            return false;
        }
        if (this.value[0] instanceof NodeInfo) {
            return true;
        }
        if (n > 1) {
            return ExpressionTool.effectiveBooleanValue(this.iterate(xPathContext));
        }
        return ((AtomicValue)this.value[0]).effectiveBooleanValue(xPathContext);
    }
}

