/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.om.FastStringBuffer;

public class Whitespace {
    public static final int PRESERVE = 0;
    public static final int REPLACE = 1;
    public static final int COLLAPSE = 2;

    private Whitespace() {
    }

    public static CharSequence applyWhitespaceNormalization(int n, CharSequence charSequence) {
        switch (n) {
            case 0: {
                return charSequence;
            }
            case 1: {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
                for (int i = 0; i < charSequence.length(); ++i) {
                    if ("\n\r\t".indexOf(charSequence.charAt(i)) >= 0) {
                        fastStringBuffer.append(' ');
                        continue;
                    }
                    fastStringBuffer.append(charSequence.charAt(i));
                }
                return fastStringBuffer;
            }
            case 2: {
                return NormalizeSpace.normalize(((Object)charSequence).toString());
            }
        }
        throw new IllegalArgumentException("Unknown whitespace facet value");
    }
}

