/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.CommandLineStarter;
import org.apache.fop.apps.FOInputHandler;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.apps.Starter;
import org.apache.fop.apps.XSLTInputHandler;
import org.apache.fop.messaging.MessageHandler;

public class CommandLineOptions {
    private static final int NOT_SET = 0;
    private static final int FO_INPUT = 1;
    private static final int XSLT_INPUT = 2;
    private static final int PDF_OUTPUT = 1;
    private static final int AWT_OUTPUT = 2;
    private static final int MIF_OUTPUT = 3;
    private static final int PRINT_OUTPUT = 4;
    private static final int PCL_OUTPUT = 5;
    private static final int PS_OUTPUT = 6;
    private static final int TXT_OUTPUT = 7;
    private static final int SVG_OUTPUT = 8;
    private static final int AREA_OUTPUT = 9;
    Boolean errorDump = Boolean.FALSE;
    Boolean dumpConfiguration = Boolean.FALSE;
    Boolean quiet = Boolean.FALSE;
    Boolean suppressLowLevelAreas = Boolean.FALSE;
    File userConfigFile = null;
    File fofile = null;
    File xsltfile = null;
    File xmlfile = null;
    File outfile = null;
    int inputmode = 0;
    int outputmode = 0;
    String language = null;
    private HashMap rendererOptions;
    private Logger log;
    static /* synthetic */ Class class$org$apache$fop$apps$CommandLineOptions;

    public CommandLineOptions(String[] args) throws FOPException, FileNotFoundException {
        this.setLogger((Logger)new ConsoleLogger(1));
        boolean optionsParsed = true;
        this.rendererOptions = new HashMap();
        try {
            optionsParsed = this.parseOptions(args);
            if (optionsParsed) {
                this.checkSettings();
                if (this.errorDump != null && this.errorDump.booleanValue()) {
                    this.debug();
                }
            }
        }
        catch (FOPException e) {
            CommandLineOptions.printUsage();
            throw e;
        }
        catch (FileNotFoundException e) {
            CommandLineOptions.printUsage();
            throw e;
        }
    }

    private void checkSettings() throws FOPException, FileNotFoundException {
        if (this.inputmode == 0) {
            throw new FOPException("No input file specified");
        }
        if (this.outputmode == 0) {
            throw new FOPException("No output file specified");
        }
        if (this.inputmode == 2) {
            if (this.xmlfile == null) {
                throw new FOPException("XML file must be specified for the tranform mode");
            }
            if (this.xsltfile == null) {
                throw new FOPException("XSLT file must be specified for the tranform mode");
            }
            if (this.fofile != null) {
                this.log.warn("Can't use fo file with transform mode! Ignoring.\nYour input is \n xmlfile: " + this.xmlfile.getAbsolutePath() + "\nxsltfile: " + this.xsltfile.getAbsolutePath() + "\n  fofile: " + this.fofile.getAbsolutePath());
            }
            if (!this.xmlfile.exists()) {
                throw new FileNotFoundException("xml file " + this.xmlfile.getAbsolutePath() + " not found ");
            }
            if (!this.xsltfile.exists()) {
                throw new FileNotFoundException("xsl file " + this.xsltfile.getAbsolutePath() + " not found ");
            }
        } else if (this.inputmode == 1) {
            if (this.xmlfile != null || this.xsltfile != null) {
                this.log.warn("fo input mode, but xmlfile or xslt file are set:");
                this.log.error("xml file: " + this.xmlfile.toString());
                this.log.error("xslt file: " + this.xsltfile.toString());
            }
            if (!this.fofile.exists()) {
                throw new FileNotFoundException("fo file " + this.fofile.getAbsolutePath() + " not found ");
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void debug() {
        this.log.debug("Input mode: ");
        switch (this.inputmode) {
            case 0: {
                this.log.debug("not set");
                break;
            }
            case 1: {
                this.log.debug("FO ");
                this.log.debug("fo input file: " + this.fofile.toString());
                break;
            }
            case 2: {
                this.log.debug("xslt transformation");
                this.log.debug("xml input file: " + this.xmlfile.toString());
                this.log.debug("xslt stylesheet: " + this.xsltfile.toString());
                break;
            }
            default: {
                this.log.debug("unknown input type");
            }
        }
        this.log.debug("Output mode: ");
        switch (this.outputmode) {
            case 0: {
                this.log.debug("not set");
                break;
            }
            case 1: {
                this.log.debug("pdf");
                this.log.debug("output file: " + this.outfile.toString());
                break;
            }
            case 2: {
                this.log.debug("awt on screen");
                if (this.outfile == null) break;
                this.log.error("awt mode, but outfile is set:");
                this.log.debug("out file: " + this.outfile.toString());
                break;
            }
            case 3: {
                this.log.debug("mif");
                this.log.debug("output file: " + this.outfile.toString());
                break;
            }
            case 4: {
                this.log.debug("print directly");
                if (this.outfile == null) break;
                this.log.error("print mode, but outfile is set:");
                this.log.error("out file: " + this.outfile.toString());
                break;
            }
            case 5: {
                this.log.debug("pcl");
                this.log.debug("output file: " + this.outfile.toString());
                break;
            }
            case 6: {
                this.log.debug("PostScript");
                this.log.debug("output file: " + this.outfile.toString());
                break;
            }
            case 7: {
                this.log.debug("txt");
                this.log.debug("output file: " + this.outfile.toString());
                if (!this.rendererOptions.containsKey("txt.encoding")) break;
                this.log.debug("output encoding: " + this.rendererOptions.get("txt.encoding"));
                break;
            }
            case 8: {
                this.log.debug("svg");
                this.log.debug("output file: " + this.outfile.toString());
                break;
            }
            default: {
                this.log.debug("unknown input type");
            }
        }
        this.log.debug("OPTIONS");
        if (this.userConfigFile != null) {
            this.log.debug("user configuration file: " + this.userConfigFile.toString());
        } else {
            this.log.debug("no user configuration file is used [default]");
        }
        if (this.errorDump != null) {
            this.log.debug("debug mode on");
        } else {
            this.log.debug("debug mode off [default]");
        }
        if (this.dumpConfiguration != null) {
            this.log.debug("dump configuration");
        } else {
            this.log.debug("don't dump configuration [default]");
        }
        if (this.quiet != null) {
            this.log.debug("quiet mode on");
        } else {
            this.log.debug("quiet mode off [default]");
        }
    }

    public Boolean dumpConfiguration() {
        return this.dumpConfiguration;
    }

    public File getFOFile() {
        return this.fofile;
    }

    public File getInputFile() {
        switch (this.inputmode) {
            case 1: {
                return this.fofile;
            }
            case 2: {
                return this.xmlfile;
            }
        }
        return this.fofile;
    }

    public InputHandler getInputHandler() throws FOPException {
        switch (this.inputmode) {
            case 1: {
                return new FOInputHandler(this.fofile);
            }
            case 2: {
                return new XSLTInputHandler(this.xmlfile, this.xsltfile);
            }
        }
        return new FOInputHandler(this.fofile);
    }

    public int getInputMode() {
        return this.inputmode;
    }

    public String getLanguage() {
        return this.language;
    }

    public File getOutputFile() {
        return this.outfile;
    }

    public int getOutputMode() {
        return this.outputmode;
    }

    public int getRenderer() throws FOPException {
        switch (this.outputmode) {
            case 0: {
                throw new FOPException("Renderer has not been set!");
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 9;
            }
            case 9: {
                this.rendererOptions.put("fineDetail", this.isCoarseAreaXml());
                return 4;
            }
        }
        throw new FOPException("Invalid Renderer setting!");
    }

    public HashMap getRendererOptions() {
        return this.rendererOptions;
    }

    public Starter getStarter() throws FOPException {
        Starter starter = null;
        switch (this.outputmode) {
            case 2: {
                try {
                    starter = (Starter)Class.forName("org.apache.fop.apps.AWTStarter").getConstructor(class$org$apache$fop$apps$CommandLineOptions != null ? class$org$apache$fop$apps$CommandLineOptions : (class$org$apache$fop$apps$CommandLineOptions = CommandLineOptions.class$("org.apache.fop.apps.CommandLineOptions"))).newInstance(this);
                    break;
                }
                catch (Exception e) {
                    if (e instanceof FOPException) {
                        throw (FOPException)e;
                    }
                    throw new FOPException("AWTStarter could not be loaded.", e);
                }
            }
            case 4: {
                try {
                    starter = (Starter)Class.forName("org.apache.fop.apps.PrintStarter").getConstructor(class$org$apache$fop$apps$CommandLineOptions != null ? class$org$apache$fop$apps$CommandLineOptions : (class$org$apache$fop$apps$CommandLineOptions = CommandLineOptions.class$("org.apache.fop.apps.CommandLineOptions"))).newInstance(this);
                    break;
                }
                catch (Exception e) {
                    if (e instanceof FOPException) {
                        throw (FOPException)e;
                    }
                    throw new FOPException("PrintStarter could not be loaded.", e);
                }
            }
            default: {
                starter = new CommandLineStarter(this);
            }
        }
        starter.setLogger(this.log);
        return starter;
    }

    public File getUserConfigFile() {
        return this.userConfigFile;
    }

    public File getXMLFile() {
        return this.xmlfile;
    }

    public File getXSLFile() {
        return this.xsltfile;
    }

    public Boolean isCoarseAreaXml() {
        return this.suppressLowLevelAreas;
    }

    public Boolean isDebugMode() {
        return this.errorDump;
    }

    public Boolean isQuiet() {
        return this.quiet;
    }

    public static void main(String[] args) {
        try {
            CommandLineOptions options = new CommandLineOptions(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseOptions(String[] args) throws FOPException {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-d") || args[i].equals("--full-error-dump")) {
                this.errorDump = Boolean.TRUE;
                this.setLogger((Logger)new ConsoleLogger(0));
            } else if (args[i].equals("-x") || args[i].equals("--dump-config")) {
                this.dumpConfiguration = Boolean.TRUE;
            } else if (args[i].equals("-q") || args[i].equals("--quiet")) {
                this.quiet = Boolean.TRUE;
                this.setLogger((Logger)new ConsoleLogger(3));
            } else if (args[i].equals("-c")) {
                if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
                    throw new FOPException("if you use '-c', you must specify the name of the configuration file");
                }
                this.userConfigFile = new File(args[i + 1]);
                ++i;
            } else if (args[i].equals("-l")) {
                if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
                    throw new FOPException("if you use '-l', you must specify a language");
                }
                this.language = args[i + 1];
                ++i;
            } else if (args[i].equals("-s")) {
                this.suppressLowLevelAreas = Boolean.TRUE;
            } else if (args[i].equals("-fo")) {
                this.inputmode = 1;
                if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the fo file for the '-fo' option");
                }
                this.fofile = new File(args[i + 1]);
                ++i;
            } else if (args[i].equals("-xsl")) {
                this.inputmode = 2;
                if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the stylesheet file for the '-xsl' option");
                }
                this.xsltfile = new File(args[i + 1]);
                ++i;
            } else if (args[i].equals("-xml")) {
                this.inputmode = 2;
                if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the input file for the '-xml' option");
                }
                this.xmlfile = new File(args[i + 1]);
                ++i;
            } else if (args[i].equals("-awt")) {
                this.setOutputMode(2);
            } else if (args[i].equals("-pdf")) {
                this.setOutputMode(1);
                if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the pdf output file");
                }
                this.outfile = new File(args[i + 1]);
                ++i;
            } else if (args[i].equals("-mif")) {
                this.setOutputMode(3);
                if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the mif output file");
                }
                this.outfile = new File(args[i + 1]);
                ++i;
            } else if (args[i].equals("-print")) {
                this.setOutputMode(4);
                if (i + 1 < args.length && args[i + 1].equals("help")) {
                    this.printUsagePrintOutput();
                    return false;
                }
            } else if (args[i].equals("-pcl")) {
                this.setOutputMode(5);
                if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the pdf output file");
                }
                this.outfile = new File(args[i + 1]);
                ++i;
            } else if (args[i].equals("-ps")) {
                this.setOutputMode(6);
                if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the PostScript output file");
                }
                this.outfile = new File(args[i + 1]);
                ++i;
            } else if (args[i].equals("-txt")) {
                this.setOutputMode(7);
                if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the text output file");
                }
                this.outfile = new File(args[i + 1]);
                ++i;
            } else if (args[i].equals("-svg")) {
                this.setOutputMode(8);
                if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the svg output file");
                }
                this.outfile = new File(args[i + 1]);
                ++i;
            } else if (args[i].charAt(0) != '-') {
                if (this.inputmode == 0) {
                    this.inputmode = 1;
                    this.fofile = new File(args[i]);
                } else {
                    if (this.outputmode != 0) throw new FOPException("Don't know what to do with " + args[i]);
                    this.outputmode = 1;
                    this.outfile = new File(args[i]);
                }
            } else if (args[i].equals("-at")) {
                this.setOutputMode(9);
                if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the area-tree output file");
                }
                this.outfile = new File(args[i + 1]);
                ++i;
            } else if (args[i].equals("-txt.encoding")) {
                if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify text renderer encoding");
                }
                this.rendererOptions.put("txt.encoding", args[i + 1]);
                ++i;
            } else {
                CommandLineOptions.printUsage();
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void printUsage() {
        System.err.println("\nUSAGE\nFop [options] [-fo|-xml] infile [-xsl file] [-awt|-pdf|-mif|-pcl|-ps|-txt|-at|-print] <outfile>\n [OPTIONS]  \n  -d          debug mode   \n  -x          dump configuration settings  \n  -q          quiet mode  \n  -c cfg.xml  use additional configuration file cfg.xml\n  -l lang     the language to use for user information \n  -s          for area tree XML, down to block areas only\n\n [INPUT]  \n  infile            xsl:fo input file (the same as the next) \n  -fo  infile       xsl:fo input file  \n  -xml infile       xml input file, must be used together with -xsl \n  -xsl stylesheet   xslt stylesheet \n \n [OUTPUT] \n  outfile           input will be rendered as pdf file into outfile \n  -pdf outfile      input will be rendered as pdf file (outfile req'd) \n  -awt              input will be displayed on screen \n  -mif outfile      input will be rendered as mif file (outfile req'd)\n  -pcl outfile      input will be rendered as pcl file (outfile req'd) \n  -ps outfile       input will be rendered as PostScript file (outfile req'd) \n  -txt outfile      input will be rendered as text file (outfile req'd) \n    -txt.encoding encoding  use the encoding for the output file.\n                    the encoding must be a valid java encoding.\n  -svg outfile      input will be rendered as an svg slides file (outfile req'd) \n  -at outfile       representation of area tree as XML (outfile req'd) \n  -print            input file will be rendered and sent to the printer \n                    see options with \"-print help\" \n\n [Examples]\n  Fop foo.fo foo.pdf \n  Fop -fo foo.fo -pdf foo.pdf (does the same as the previous line)\n  Fop -xsl foo.xsl -xml foo.xml -pdf foo.pdf\n  Fop foo.fo -mif foo.mif\n  Fop foo.fo -print or Fop -print foo.fo \n  Fop foo.fo -awt \n");
    }

    public void printUsagePrintOutput() {
        System.err.println("USAGE: -print [-Dstart=i] [-Dend=i] [-Dcopies=i] [-Deven=true|false]  org.apache.fop.apps.Fop (..) -print \nExample:\njava -Dstart=1 -Dend=2 org.apache.Fop.apps.Fop infile.fo -print ");
    }

    private void setLogger(Logger newLogger) {
        this.log = newLogger;
        MessageHandler.setScreenLogger(newLogger);
    }

    private void setOutputMode(int mode) throws FOPException {
        if (this.outputmode != 0) {
            throw new FOPException("you can only set one output method");
        }
        this.outputmode = mode;
    }
}

