/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import org.xml.sax.SAXException;

public class FOPException
extends Exception {
    private static final String EXCEPTION_SEPARATOR = "\n---------\n";
    private Throwable _exception;

    public FOPException(String message) {
        super(message);
    }

    public FOPException(String message, Throwable e) {
        super(message);
        this.setException(e);
    }

    public FOPException(Throwable e) {
        super(e.getMessage());
        this.setException(e);
    }

    public Throwable getException() {
        return this._exception;
    }

    protected Throwable getRootException() {
        Throwable result = this._exception;
        if (result instanceof SAXException) {
            result = ((SAXException)result).getException();
        }
        if (result instanceof InvocationTargetException) {
            result = ((InvocationTargetException)result).getTargetException();
        }
        if (result != this._exception) {
            return result;
        }
        return null;
    }

    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace();
            if (this._exception != null) {
                System.err.println(EXCEPTION_SEPARATOR);
                this._exception.printStackTrace();
            }
            if (this.getRootException() != null) {
                System.err.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace();
            }
        }
    }

    public void printStackTrace(PrintStream stream) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            super.printStackTrace(stream);
            if (this._exception != null) {
                stream.println(EXCEPTION_SEPARATOR);
                this._exception.printStackTrace(stream);
            }
            if (this.getRootException() != null) {
                System.err.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace(stream);
            }
        }
    }

    public void printStackTrace(PrintWriter writer) {
        PrintWriter printWriter = writer;
        synchronized (printWriter) {
            super.printStackTrace(writer);
            if (this._exception != null) {
                writer.println(EXCEPTION_SEPARATOR);
                this._exception.printStackTrace(writer);
            }
            if (this.getRootException() != null) {
                System.err.println(EXCEPTION_SEPARATOR);
                this.getRootException().printStackTrace(writer);
            }
        }
    }

    protected void setException(Throwable t) {
        this._exception = t;
    }
}

