/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class TraxInputHandler
extends InputHandler {
    File xmlfile;
    File xsltfile;
    private Transformer transformer;
    private Source xmlSource;

    public TraxInputHandler(File xmlfile, File xsltfile) throws FOPException {
        this.xmlfile = xmlfile;
        this.xsltfile = xsltfile;
        try {
            this.transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xsltfile));
        }
        catch (Exception ex) {
            throw new FOPException(ex);
        }
    }

    public TraxInputHandler(String xmlURL, String xsltURL) throws FOPException {
        this.xmlSource = new StreamSource(xmlURL);
        try {
            this.transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xsltURL));
        }
        catch (Exception ex) {
            throw new FOPException(ex);
        }
    }

    public TraxInputHandler(InputSource xmlSource, InputSource xsltSource) throws FOPException {
        this.xmlSource = new StreamSource(xmlSource.getByteStream(), xmlSource.getSystemId());
        try {
            this.transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xsltSource.getByteStream(), xsltSource.getSystemId()));
        }
        catch (Exception ex) {
            throw new FOPException(ex);
        }
    }

    public InputSource getInputSource() {
        return InputHandler.fileInputSource(this.xmlfile);
    }

    public XMLReader getParser() throws FOPException {
        return TraxInputHandler.getXMLFilter(this.xmlfile, this.xsltfile);
    }

    public static XMLFilter getXMLFilter(File xmlfile, File xsltfile) throws FOPException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            if (tFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && tFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
                SAXTransformerFactory saxTFactory = (SAXTransformerFactory)tFactory;
                XMLFilter xmlfilter = saxTFactory.newXMLFilter(new StreamSource(xsltfile));
                XMLReader parser = InputHandler.createParser();
                if (parser == null) {
                    throw new FOPException("Unable to create SAX parser");
                }
                xmlfilter.setParent(parser);
                return xmlfilter;
            }
            throw new FOPException("Your parser doesn't support the features SAXSource and SAXResult.\nMake sure you are using a xsl parser which supports TrAX");
        }
        catch (FOPException fex) {
            throw fex;
        }
        catch (Exception ex) {
            throw new FOPException(ex);
        }
    }

    public void run(Driver driver) throws FOPException {
        try {
            this.transformer.transform(this.xmlSource, new SAXResult(driver.getContentHandler()));
        }
        catch (Exception ex) {
            throw new FOPException(ex);
        }
    }

    public void setParameter(String name, Object value) {
        this.transformer.setParameter(name, value);
    }
}

