/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

public class ColorSpace {
    private boolean hasICCProfile;
    private byte[] iccProfile;
    private int numComponents;
    public static int DEVICE_UNKNOWN = -1;
    public static int DEVICE_GRAY = 1;
    public static int DEVICE_RGB = 2;
    public static int DEVICE_CMYK = 3;
    protected int currentColorSpace = -1;

    public ColorSpace(int theColorSpace) {
        this.currentColorSpace = theColorSpace;
        this.hasICCProfile = false;
        this.numComponents = this.calculateNumComponents();
    }

    private int calculateNumComponents() {
        if (this.currentColorSpace == DEVICE_GRAY) {
            return 1;
        }
        if (this.currentColorSpace == DEVICE_RGB) {
            return 3;
        }
        if (this.currentColorSpace == DEVICE_CMYK) {
            return 4;
        }
        return 0;
    }

    public int getColorSpace() {
        return this.currentColorSpace;
    }

    public String getColorSpacePDFString() {
        if (this.currentColorSpace == DEVICE_RGB) {
            return "DeviceRGB";
        }
        if (this.currentColorSpace == DEVICE_CMYK) {
            return "DeviceCMYK";
        }
        if (this.currentColorSpace == DEVICE_GRAY) {
            return "DeviceGray";
        }
        return "DeviceRGB";
    }

    public byte[] getICCProfile() {
        if (this.hasICCProfile) {
            return this.iccProfile;
        }
        return new byte[0];
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public boolean hasICCProfile() {
        return this.hasICCProfile;
    }

    public void setColorSpace(int theColorSpace) {
        this.currentColorSpace = theColorSpace;
        this.numComponents = this.calculateNumComponents();
    }

    public void setICCProfile(byte[] iccProfile) {
        this.iccProfile = iccProfile;
        this.hasICCProfile = true;
    }
}

