/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.extensions;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.extensions.ExtensionObj;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaTree;

public class ContinuedLabel
extends ExtensionObj {
    private FObj containingTable = null;

    public ContinuedLabel(FObj parent, PropertyList propertyList) {
        super(parent, propertyList);
        while (parent != null) {
            if (parent.getName().equals("fo:table")) {
                this.containingTable = parent;
                break;
            }
            parent = parent.getParent();
        }
    }

    public void format(AreaTree areaTree) throws FOPException {
    }

    public String getName() {
        return "fop:continued-label";
    }

    public int layout(Area area) throws FOPException {
        if (this.marker == -1000) {
            this.marker = 0;
        }
        if (this.containingTable != null && this.containingTable.areasGenerated > 0) {
            int numChildren = this.children.size();
            int i = this.marker;
            while (i < numChildren) {
                FONode fo = (FONode)this.children.get(i);
                int status = fo.layout(area);
                if (Status.isIncomplete(status)) {
                    this.marker = i;
                    return status;
                }
                ++i;
            }
        }
        return 1;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void removeID(IDReferences idReferences) {
        int numChildren = this.children.size();
        int i = 0;
        while (i < numChildren) {
            FONode child = (FONode)this.children.get(i);
            if (child instanceof FObj) {
                ((FObj)child).removeID(idReferences);
            }
            ++i;
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList) {
            return new ContinuedLabel(parent, propertyList);
        }
    }
}

