/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.extensions;

import java.util.ArrayList;
import org.apache.fop.extensions.ExtensionObj;
import org.apache.fop.extensions.Label;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;

public class Outline
extends ExtensionObj {
    private Label _label;
    private ArrayList _outlines = new ArrayList();
    private String _internalDestination = this.properties.get("internal-destination").getString();
    private String _externalDestination = this.properties.get("external-destination").getString();
    private Outline _parentOutline;
    private Object _rendererObject;

    public Outline(FObj parent, PropertyList propertyList) {
        super(parent, propertyList);
        if (this._externalDestination != null && !this._externalDestination.equals("")) {
            this.log.warn("fox:outline external-destination not supported currently.");
        }
        if (this._internalDestination == null || this._internalDestination.equals("")) {
            this.log.warn("fox:outline requires an internal-destination.");
        }
        FObj node = this.getParent();
        while (node != null) {
            if (node instanceof Outline) {
                this._parentOutline = (Outline)node;
                break;
            }
            node = node.getParent();
        }
    }

    protected void addChild(FONode obj) {
        if (obj instanceof Label) {
            this._label = (Label)obj;
        } else if (obj instanceof Outline) {
            this._outlines.add(obj);
        }
        super.addChild(obj);
    }

    public String getInternalDestination() {
        return this._internalDestination;
    }

    public Label getLabel() {
        return this._label == null ? new Label(this, this.properties) : this._label;
    }

    public String getName() {
        return "fop:outline";
    }

    public ArrayList getOutlines() {
        return this._outlines;
    }

    public Outline getParentOutline() {
        return this._parentOutline;
    }

    public Object getRendererObject() {
        return this._rendererObject;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void setRendererObject(Object o) {
        this._rendererObject = o;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList) {
            return new Outline(parent, propertyList);
        }
    }
}

