/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.StreamRenderer;
import org.apache.fop.extensions.ExtensionObj;
import org.apache.fop.fo.DirectPropertyListBuilder;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.PropertyListBuilder;
import org.apache.fop.fo.TreeBuilder;
import org.apache.fop.fo.Unknown;
import org.apache.fop.fo.UnknownXMLObj;
import org.apache.fop.fo.pagination.PageSequence;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FOTreeBuilder
extends DefaultHandler
implements TreeBuilder {
    protected HashMap fobjTable = new HashMap();
    protected ArrayList namespaces = new ArrayList();
    protected HashMap propertylistTable = new HashMap();
    protected FObj currentFObj = null;
    protected FObj rootFObj = null;
    protected HashMap unknownFOs = new HashMap();
    private StreamRenderer streamRenderer;
    private Logger log;

    public void addElementPropertyList(String namespaceURI, String localName, HashMap list) {
        PropertyListBuilder plb = (PropertyListBuilder)this.propertylistTable.get(namespaceURI);
        if (plb == null) {
            plb = new PropertyListBuilder();
            plb.addElementList(localName, list);
            this.propertylistTable.put(namespaceURI, plb);
        } else {
            plb.addElementList(localName, list);
        }
    }

    public void addMapping(String namespaceURI, HashMap table) {
        this.fobjTable.put(namespaceURI, table);
        this.namespaces.add(namespaceURI.intern());
    }

    public void addPropertyList(String namespaceURI, HashMap list) {
        PropertyListBuilder plb = (PropertyListBuilder)this.propertylistTable.get(namespaceURI);
        if (plb == null) {
            plb = new PropertyListBuilder();
            plb.addList(list);
            this.propertylistTable.put(namespaceURI, plb);
        } else {
            plb.addList(list);
        }
    }

    public void addPropertyListBuilder(String namespaceURI, PropertyListBuilder propbuilder) {
        PropertyListBuilder plb = (PropertyListBuilder)this.propertylistTable.get(namespaceURI);
        if (plb == null) {
            this.propertylistTable.put(namespaceURI, propbuilder);
        }
    }

    public void characters(char[] data, int start, int length) {
        if (this.currentFObj != null) {
            this.currentFObj.addCharacters(data, start, length);
        }
    }

    public void endDocument() throws SAXException {
        this.log.info("Parsing of document complete, stopping renderer");
        this.streamRenderer.stopRenderer();
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        this.currentFObj.end();
        if (this.currentFObj instanceof PageSequence) {
            this.streamRenderer.render((PageSequence)this.currentFObj);
        } else if (this.currentFObj instanceof ExtensionObj && !(this.currentFObj.getParent() instanceof ExtensionObj)) {
            this.streamRenderer.addExtension((ExtensionObj)this.currentFObj);
        }
        this.currentFObj = this.currentFObj.getParent();
    }

    public StreamRenderer getStreamRenderer() {
        return this.streamRenderer;
    }

    public boolean hasData() {
        return this.rootFObj != null;
    }

    public void reset() {
        this.currentFObj = null;
        this.rootFObj = null;
        this.streamRenderer = null;
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public void setStreamRenderer(StreamRenderer streamRenderer) {
        this.streamRenderer = streamRenderer;
    }

    public void startDocument() throws SAXException {
        this.rootFObj = null;
        this.log.info("building formatting object tree");
        this.streamRenderer.startRenderer();
    }

    public void startElement(String uri, String localName, String rawName, Attributes attlist) throws SAXException {
        FObj fobj;
        FObj.Maker fobjMaker = null;
        HashMap table = (HashMap)this.fobjTable.get(uri);
        if (table != null) {
            fobjMaker = (FObj.Maker)table.get(localName);
        }
        PropertyListBuilder currentListBuilder = (PropertyListBuilder)this.propertylistTable.get(uri);
        boolean foreignXML = false;
        if (fobjMaker == null) {
            String fullName = String.valueOf(uri) + "^" + localName;
            if (!this.unknownFOs.containsKey(fullName)) {
                this.unknownFOs.put(fullName, "");
                this.log.error("Unknown formatting object " + fullName);
            }
            if (this.namespaces.contains(uri.intern())) {
                fobjMaker = new Unknown.Maker();
            } else {
                fobjMaker = new UnknownXMLObj.Maker(uri, localName);
                foreignXML = true;
            }
        }
        try {
            PropertyList list = null;
            if (currentListBuilder != null) {
                list = currentListBuilder.makeList(uri, localName, attlist, this.currentFObj == null ? null : this.currentFObj.properties, this.currentFObj);
            } else if (foreignXML) {
                list = new DirectPropertyListBuilder.AttrPropertyList(attlist);
            } else {
                if (this.currentFObj == null) {
                    throw new FOPException("Invalid XML or missing namespace");
                }
                list = this.currentFObj.properties;
            }
            fobj = fobjMaker.make(this.currentFObj, list);
            fobj.setLogger(this.log);
        }
        catch (FOPException e) {
            throw new SAXException(e);
        }
        if (this.rootFObj == null) {
            this.rootFObj = fobj;
            if (!fobj.getName().equals("fo:root")) {
                throw new SAXException(new FOPException("Root element must be root, not " + fobj.getName()));
            }
        } else if (!(fobj instanceof PageSequence)) {
            this.currentFObj.addChild(fobj);
        }
        this.currentFObj = fobj;
    }
}

