/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.TextState;

public abstract class FObjMixed
extends FObj {
    protected TextState textState;
    private StringBuffer textBuffer;

    protected FObjMixed(FObj parent, PropertyList propertyList) throws FOPException {
        super(parent, propertyList);
        this.textState = this.propMgr.getTextDecoration(parent);
    }

    protected void addCharacters(char[] data, int start, int length) {
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer();
        }
        this.textBuffer.append(data, start, length);
    }

    protected void addChild(FONode child) {
        this.finalizeText();
        super.addChild(child);
    }

    protected void end() {
        this.finalizeText();
        this.textBuffer = null;
    }

    private final void finalizeText() {
        if (this.textBuffer != null && this.textBuffer.length() > 0) {
            FOText ft = new FOText(this.textBuffer, this);
            ft.setTextState(this.textState);
            super.addChild(ft);
            this.textBuffer.setLength(0);
        }
    }

    public TextState getTextState() {
        return this.textState;
    }

    public int layout(Area area) throws FOPException {
        Property prop;
        if (this.properties != null && (prop = this.properties.get("id")) != null) {
            String id = prop.getString();
            if (this.marker == -1000) {
                if (area.getIDReferences() != null) {
                    area.getIDReferences().createID(id);
                }
                this.marker = 0;
            }
            if (this.marker == 0 && area.getIDReferences() != null) {
                area.getIDReferences().configureID(id, area);
            }
        }
        int numChildren = this.children.size();
        int i = this.marker;
        while (i < numChildren) {
            FONode fo = (FONode)this.children.get(i);
            int status = fo.layout(area);
            if (Status.isIncomplete(status)) {
                this.marker = i;
                return status;
            }
            ++i;
        }
        return 1;
    }
}

