/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.Page;

public class RetrieveMarker
extends FObj {
    private String retrieveClassName;
    private int retrievePosition;
    private int retrieveBoundary;
    private Marker bestMarker;

    public RetrieveMarker(FObj parent, PropertyList propertyList) {
        super(parent, propertyList);
        this.retrieveClassName = this.properties.get("retrieve-class-name").getString();
        this.retrievePosition = this.properties.get("retrieve-position").getEnum();
        this.retrieveBoundary = this.properties.get("retrieve-boundary").getEnum();
    }

    public String getName() {
        return "fo:retrieve-marker";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int layout(Area area) throws FOPException {
        if (this.marker == -1000) {
            this.marker = 0;
            Page containingPage = area.getPage();
            this.bestMarker = this.searchPage(containingPage);
            if (this.bestMarker != null) {
                this.bestMarker.resetMarkerContent();
                return this.bestMarker.layoutMarker(area);
            }
            AreaTree areaTree = containingPage.getAreaTree();
            if (this.retrieveBoundary == 84) {
                PageSequence pageSequence = areaTree.getCurrentPageSequence();
                if (pageSequence != containingPage.getPageSequence()) return 1;
                return this.layoutBestMarker(areaTree.getCurrentPageSequenceMarkers(), area);
            }
            if (this.retrieveBoundary != 25) throw new FOPException("Illegal 'retrieve-boundary' value");
            return this.layoutBestMarker(areaTree.getDocumentMarkers(), area);
        }
        if (this.bestMarker == null) return 1;
        return this.bestMarker.layoutMarker(area);
    }

    private int layoutBestMarker(ArrayList markers, Area area) throws FOPException {
        if (markers != null) {
            int i = markers.size() - 1;
            while (i >= 0) {
                Marker currentMarker = (Marker)markers.get(i);
                if (currentMarker.getMarkerClassName().equals(this.retrieveClassName)) {
                    this.bestMarker = currentMarker;
                    this.bestMarker.resetMarkerContent();
                    return this.bestMarker.layoutMarker(area);
                }
                --i;
            }
        }
        return 1;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    private Marker searchPage(Page page) throws FOPException {
        ArrayList pageMarkers = page.getMarkers();
        if (pageMarkers.isEmpty()) {
            return null;
        }
        if (this.retrievePosition == 37) {
            int i = 0;
            while (i < pageMarkers.size()) {
                Marker currentMarker = (Marker)pageMarkers.get(i);
                if (currentMarker.getMarkerClassName().equals(this.retrieveClassName)) {
                    return currentMarker;
                }
                ++i;
            }
        } else if (this.retrievePosition == 42) {
            int i = 0;
            while (i < pageMarkers.size()) {
                Marker currentMarker = (Marker)pageMarkers.get(i);
                if (currentMarker.getMarkerClassName().equals(this.retrieveClassName) && currentMarker.getRegistryArea().isFirst()) {
                    return currentMarker;
                }
                ++i;
            }
        } else if (this.retrievePosition == 61) {
            int i = pageMarkers.size() - 1;
            while (i >= 0) {
                Marker currentMarker = (Marker)pageMarkers.get(i);
                if (currentMarker.getMarkerClassName().equals(this.retrieveClassName) && currentMarker.getRegistryArea().isFirst()) {
                    return currentMarker;
                }
                --i;
            }
        } else if (this.retrievePosition == 57) {
            int i = pageMarkers.size() - 1;
            while (i >= 0) {
                Marker currentMarker = (Marker)pageMarkers.get(i);
                if (currentMarker.getMarkerClassName().equals(this.retrieveClassName) && currentMarker.getRegistryArea().isLast()) {
                    return currentMarker;
                }
                --i;
            }
        } else {
            throw new FOPException("Illegal 'retrieve-position' value");
        }
        return null;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList) throws FOPException {
            return new RetrieveMarker(parent, propertyList);
        }
    }
}

