/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.SimplePageMaster;

public class LayoutMasterSet
extends FObj {
    private HashMap simplePageMasters = new HashMap();
    private HashMap pageSequenceMasters = new HashMap();
    private HashMap allRegions;
    private Root root;

    protected LayoutMasterSet(FObj parent, PropertyList propertyList) throws FOPException {
        super(parent, propertyList);
        if (!parent.getName().equals("fo:root")) {
            throw new FOPException("fo:layout-master-set must be child of fo:root, not " + parent.getName());
        }
        this.root = (Root)parent;
        this.root.setLayoutMasterSet(this);
        this.allRegions = new HashMap();
    }

    protected void addPageSequenceMaster(String masterName, PageSequenceMaster pageSequenceMaster) throws FOPException {
        if (this.existsName(masterName)) {
            throw new FOPException("'master-name' (" + masterName + ") must be unique " + "across page-masters and page-sequence-masters");
        }
        this.pageSequenceMasters.put(masterName, pageSequenceMaster);
    }

    protected void addSimplePageMaster(SimplePageMaster simplePageMaster) throws FOPException {
        if (this.existsName(simplePageMaster.getMasterName())) {
            throw new FOPException("'master-name' (" + simplePageMaster.getMasterName() + ") must be unique " + "across page-masters and page-sequence-masters");
        }
        this.simplePageMasters.put(simplePageMaster.getMasterName(), simplePageMaster);
    }

    protected void checkRegionNames() throws FOPException {
        Iterator spm = this.simplePageMasters.values().iterator();
        while (spm.hasNext()) {
            SimplePageMaster simplePageMaster = (SimplePageMaster)spm.next();
            HashMap spmRegions = simplePageMaster.getRegions();
            Iterator e = spmRegions.values().iterator();
            while (e.hasNext()) {
                String localClass;
                Region region = (Region)e.next();
                if (this.allRegions.containsKey(region.getRegionName()) && !(localClass = (String)this.allRegions.get(region.getRegionName())).equals(region.getRegionClass())) {
                    throw new FOPException("Duplicate region-names (" + region.getRegionName() + ") must map " + "to the same region-class (" + localClass + "!=" + region.getRegionClass() + ")");
                }
                this.allRegions.put(region.getRegionName(), region.getRegionClass());
            }
        }
    }

    private boolean existsName(String masterName) {
        return this.simplePageMasters.containsKey(masterName) || this.pageSequenceMasters.containsKey(masterName);
    }

    public String getName() {
        return "fo:layout-master-set";
    }

    protected PageSequenceMaster getPageSequenceMaster(String masterName) {
        return (PageSequenceMaster)this.pageSequenceMasters.get(masterName);
    }

    protected SimplePageMaster getSimplePageMaster(String masterName) {
        return (SimplePageMaster)this.simplePageMasters.get(masterName);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected boolean regionNameExists(String regionName) {
        Iterator i = this.simplePageMasters.values().iterator();
        while (i.hasNext()) {
            if (!((SimplePageMaster)i.next()).regionNameExists(regionName)) continue;
            return true;
        }
        return false;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList) throws FOPException {
            return new LayoutMasterSet(parent, propertyList);
        }
    }
}

