/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.avalon.framework.logger.Logger;

public class PageNumberGenerator {
    private String format;
    private char groupingSeparator;
    private int groupingSize;
    private int letterValue;
    private int DECIMAL = 1;
    private int LOWERALPHA = 2;
    private int UPPERALPHA = 3;
    private int LOWERROMAN = 4;
    private int UPPERROMAN = 5;
    private int formatType = this.DECIMAL;
    private int minPadding = 0;
    private String[] zeros = new String[]{"", "0", "00", "000", "0000", "00000"};
    private Logger log;

    public PageNumberGenerator(String format, char groupingSeparator, int groupingSize, int letterValue) {
        this.format = format;
        this.groupingSeparator = groupingSeparator;
        this.groupingSize = groupingSize;
        this.letterValue = letterValue;
        int fmtLen = format.length();
        if (fmtLen == 1) {
            if (format.equals("1")) {
                this.formatType = this.DECIMAL;
                this.minPadding = 0;
            } else if (format.equals("a")) {
                this.formatType = this.LOWERALPHA;
            } else if (format.equals("A")) {
                this.formatType = this.UPPERALPHA;
            } else if (format.equals("i")) {
                this.formatType = this.LOWERROMAN;
            } else if (format.equals("I")) {
                this.formatType = this.UPPERROMAN;
            } else {
                this.formatType = this.DECIMAL;
                this.minPadding = 0;
            }
        } else {
            int i = 0;
            while (i < fmtLen - 1) {
                if (format.charAt(i) != '0') {
                    this.formatType = this.DECIMAL;
                    this.minPadding = 0;
                } else {
                    this.minPadding = fmtLen - 1;
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String makeAlpha(int num) {
        block1: {
            letters = "abcdefghijklmnopqrstuvwxyz";
            alphaNumber = new StringBuffer();
            base = 26;
            rem = 0;
            if (--num >= base) ** GOTO lbl13
            alphaNumber.append(letters.charAt(num));
            break block1;
lbl-1000:
            // 1 sources

            {
                rem = num % base;
                alphaNumber.append(letters.charAt(rem));
                num /= base;
lbl13:
                // 2 sources

                ** while (num >= base)
            }
lbl14:
            // 1 sources

            alphaNumber.append(letters.charAt(num - 1));
        }
        return alphaNumber.reverse().toString();
    }

    public String makeFormattedPageNumber(int number) {
        String pn = null;
        if (this.formatType == this.DECIMAL) {
            pn = Integer.toString(number);
            if (this.minPadding >= pn.length()) {
                int nz = this.minPadding - pn.length() + 1;
                pn = String.valueOf(this.zeros[nz]) + pn;
            }
        } else if (this.formatType == this.LOWERROMAN || this.formatType == this.UPPERROMAN) {
            pn = this.makeRoman(number);
            if (this.formatType == this.UPPERROMAN) {
                pn = pn.toUpperCase();
            }
        } else {
            pn = this.makeAlpha(number);
            if (this.formatType == this.UPPERALPHA) {
                pn = pn.toUpperCase();
            }
        }
        return pn;
    }

    /*
     * Unable to fully structure code
     */
    private String makeRoman(int num) {
        arabic = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        roman = new String[]{"m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", "v", "iv", "i"};
        i = 0;
        romanNumber = new StringBuffer();
        ** GOTO lbl12
        {
            num -= arabic[i];
            romanNumber.append(roman[i]);
            do {
                if (num >= arabic[i]) continue block0;
                ++i;
lbl12:
                // 2 sources

            } while (num > 0);
        }
        return romanNumber.toString();
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }
}

