/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.RegionArea;

public class RegionBefore
extends Region {
    public static final String REGION_CLASS = "before";
    private int precedence;

    protected RegionBefore(FObj parent, PropertyList propertyList) throws FOPException {
        super(parent, propertyList);
        this.precedence = this.properties.get("precedence").getEnum();
    }

    protected String getDefaultRegionName() {
        return "xsl-region-before";
    }

    public int getExtent() {
        return this.properties.get("extent").getLength().mvalue();
    }

    public String getName() {
        return "fo:region-before";
    }

    public boolean getPrecedence() {
        return this.precedence == 120;
    }

    public String getRegionClass() {
        return REGION_CLASS;
    }

    RegionArea makeRegionArea(int allocationRectangleXPosition, int allocationRectangleYPosition, int allocationRectangleWidth, int allocationRectangleHeight) {
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        int extent = this.properties.get("extent").getLength().mvalue();
        RegionArea area = new RegionArea(allocationRectangleXPosition, allocationRectangleYPosition, allocationRectangleWidth, extent);
        area.setBackground(bProps);
        return area;
    }

    RegionArea makeRegionArea(int allocationRectangleXPosition, int allocationRectangleYPosition, int allocationRectangleWidth, int allocationRectangleHeight, int startExtent, int endExtent) {
        if (!this.getPrecedence()) {
            allocationRectangleXPosition += startExtent;
            allocationRectangleWidth -= startExtent + endExtent;
        }
        return this.makeRegionArea(allocationRectangleXPosition, allocationRectangleYPosition, allocationRectangleWidth, allocationRectangleHeight);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList) throws FOPException {
            return new RegionBefore(parent, propertyList);
        }
    }
}

