/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fop.tools.IOUtil;

public class FontFileReader {
    private int fsize;
    private int current;
    private byte[] file;

    public FontFileReader(InputStream in) throws IOException {
        this.init(in);
    }

    public FontFileReader(String fileName) throws IOException {
        File f = new File(fileName);
        FileInputStream in = new FileInputStream(f);
        try {
            this.init(in);
        }
        finally {
            Object var5_4 = null;
            ((InputStream)in).close();
        }
    }

    public byte[] getBytes(int offset, int length) throws IOException {
        if (offset + length > this.fsize) {
            throw new IOException("Reached EOF");
        }
        byte[] ret = new byte[length];
        System.arraycopy(this.file, offset, ret, 0, length);
        return ret;
    }

    public int getCurrentPos() {
        return this.current;
    }

    public int getFileSize() {
        return this.fsize;
    }

    private void init(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.file = IOUtil.toByteArray(in, 50000);
            this.fsize = this.file.length;
            this.current = 0;
        }
        finally {
            Object var4_3 = null;
            bout.close();
        }
    }

    public byte read() throws IOException {
        if (this.current > this.fsize) {
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte ret = this.file[this.current++];
        return ret;
    }

    public final byte readTTFByte() throws IOException {
        return this.read();
    }

    public final int readTTFLong() throws IOException {
        long ret = this.readTTFUByte();
        ret = (ret << 8) + (long)this.readTTFUByte();
        ret = (ret << 8) + (long)this.readTTFUByte();
        ret = (ret << 8) + (long)this.readTTFUByte();
        return (int)ret;
    }

    public final short readTTFShort() throws IOException {
        int ret = (this.readTTFUByte() << 8) + this.readTTFUByte();
        short sret = (short)ret;
        return sret;
    }

    public final short readTTFShort(long pos) throws IOException {
        long cp = this.getCurrentPos();
        this.seek_set(pos);
        short ret = this.readTTFShort();
        this.seek_set(cp);
        return ret;
    }

    public final String readTTFString() throws IOException {
        int i = this.current;
        while (this.file[i++] != 0) {
            if (i <= this.fsize) continue;
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte[] tmp = new byte[i - this.current];
        System.arraycopy(this.file, this.current, tmp, 0, i - this.current);
        return new String(tmp, "ISO-8859-1");
    }

    public final String readTTFString(int len) throws IOException {
        if (len + this.current > this.fsize) {
            throw new EOFException("Reached EOF, file size=" + this.fsize);
        }
        byte[] tmp = new byte[len];
        System.arraycopy(this.file, this.current, tmp, 0, len);
        this.current += len;
        return new String(tmp, "ISO-8859-1");
    }

    public final int readTTFUByte() throws IOException {
        byte buf = this.read();
        if (buf < 0) {
            return 256 + buf;
        }
        return buf;
    }

    public final long readTTFULong() throws IOException {
        long ret = this.readTTFUByte();
        ret = (ret << 8) + (long)this.readTTFUByte();
        ret = (ret << 8) + (long)this.readTTFUByte();
        ret = (ret << 8) + (long)this.readTTFUByte();
        return ret;
    }

    public final int readTTFUShort() throws IOException {
        int ret = (this.readTTFUByte() << 8) + this.readTTFUByte();
        return ret;
    }

    public final int readTTFUShort(long pos) throws IOException {
        long cp = this.getCurrentPos();
        this.seek_set(pos);
        int ret = this.readTTFUShort();
        this.seek_set(cp);
        return ret;
    }

    public void seek_add(long add) throws IOException {
        this.seek_set((long)this.current + add);
    }

    public void seek_set(long offset) throws IOException {
        if (offset > (long)this.fsize || offset < 0L) {
            throw new EOFException("Reached EOF, file size=" + this.fsize + " offset=" + offset);
        }
        this.current = (int)offset;
    }

    public void skip(long add) throws IOException {
        this.seek_add(add);
    }

    public final void writeTTFUShort(int pos, int val) throws IOException {
        if (pos + 2 > this.fsize) {
            throw new EOFException("Reached EOF");
        }
        byte b1 = (byte)(val >> 8 & 0xFF);
        byte b2 = (byte)(val & 0xFF);
        this.file[pos] = b1;
        this.file[pos + 1] = b2;
    }
}

