/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.fop.fonts.FontFileReader;
import org.apache.fop.fonts.Glyphs;
import org.apache.fop.fonts.TTFCmapEntry;
import org.apache.fop.fonts.TTFDirTabEntry;
import org.apache.fop.fonts.TTFMtxEntry;
import org.apache.fop.fonts.UnicodeMapping;

public class TTFFile {
    static final byte NTABS = 24;
    static final int NMACGLYPHS = 258;
    static final int MAX_CHAR_CODE = 255;
    static final int ENC_BUF_SIZE = 1024;
    static String encoding = "WinAnsiEncoding";
    short firstChar = 0;
    boolean is_embeddable = true;
    boolean hasSerifs = true;
    HashMap dirTabs;
    HashMap kerningTab;
    HashMap ansiKerningTab;
    ArrayList cmaps;
    ArrayList unicodeMapping;
    int upem;
    int nhmtx;
    int post_format;
    int loca_format;
    long lastLoca = 0L;
    int nglyphs;
    int nmglyphs;
    TTFMtxEntry[] mtx_tab;
    int[] mtx_encoded = null;
    String fontName = "";
    String fullName = "";
    String notice = "";
    String familyName = "";
    String subFamilyName = "";
    long italicAngle = 0L;
    long isFixedPitch = 0L;
    int fontBBox1 = 0;
    int fontBBox2 = 0;
    int fontBBox3 = 0;
    int fontBBox4 = 0;
    int capHeight = 0;
    int underlinePosition = 0;
    int underlineThickness = 0;
    int xHeight = 0;
    int ascender = 0;
    int descender = 0;
    short lastChar = 0;
    int[] ansiWidth;
    HashMap ansiIndex;
    private TTFDirTabEntry currentDirTab;

    protected final boolean checkTTC(FontFileReader in, String name, boolean verbose) throws IOException {
        String tag = in.readTTFString(4);
        if ("ttcf".equals(tag)) {
            in.skip(4L);
            int numDirectories = (int)in.readTTFULong();
            long[] dirOffsets = new long[numDirectories];
            int i = 0;
            while (i < numDirectories) {
                dirOffsets[i] = in.readTTFULong();
                ++i;
            }
            if (verbose) {
                System.out.println("This is a TrueType collection file with" + numDirectories + " fonts");
                System.out.println("Containing the following fonts: ");
            }
            boolean found = false;
            long dirTabOffset = 0L;
            int i2 = 0;
            while (i2 < numDirectories) {
                in.seek_set(dirOffsets[i2]);
                this.readDirTabs(in);
                this.readName(in);
                if (this.fullName.equals(name)) {
                    found = true;
                    dirTabOffset = dirOffsets[i2];
                    if (verbose) {
                        System.out.println("* " + this.fullName);
                    }
                } else if (verbose) {
                    System.out.println(this.fullName);
                }
                this.notice = "";
                this.fullName = "";
                this.familyName = "";
                this.fontName = "";
                this.subFamilyName = "";
                ++i2;
            }
            in.seek_set(dirTabOffset);
            return found;
        }
        in.seek_set(0L);
        return true;
    }

    private void createCMaps() {
        UnicodeMapping um;
        this.cmaps = new ArrayList();
        TTFCmapEntry tce = new TTFCmapEntry();
        UnicodeMapping lastMapping = um = (UnicodeMapping)this.unicodeMapping.get(0);
        tce.unicodeStart = um.uIdx;
        tce.glyphStartIndex = um.gIdx;
        int i = 1;
        while (i < this.unicodeMapping.size()) {
            um = (UnicodeMapping)this.unicodeMapping.get(i);
            if (lastMapping.uIdx + 1 != um.uIdx || lastMapping.gIdx + 1 != um.gIdx) {
                tce.unicodeEnd = lastMapping.uIdx;
                this.cmaps.add(tce);
                tce = new TTFCmapEntry();
                tce.unicodeStart = um.uIdx;
                tce.glyphStartIndex = um.gIdx;
            }
            lastMapping = um;
            ++i;
        }
        tce.unicodeEnd = um.uIdx;
        this.cmaps.add(tce);
    }

    public HashMap getAnsiKerning() {
        return this.ansiKerningTab;
    }

    public ArrayList getCMaps() {
        return this.cmaps;
    }

    public int getCapHeight() {
        return this.get_ttf_funit(this.capHeight);
    }

    public String getCharSetName() {
        return encoding;
    }

    public int getCharWidth(int idx) {
        return this.get_ttf_funit(this.ansiWidth[idx]);
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public short getFirstChar() {
        return this.firstChar;
    }

    public int getFlags() {
        int flags = 32;
        if (this.italicAngle != 0L) {
            flags |= 0x40;
        }
        if (this.isFixedPitch != 0L) {
            flags |= 2;
        }
        if (this.hasSerifs) {
            flags |= 1;
        }
        return flags;
    }

    public int[] getFontBBox() {
        int[] fbb = new int[]{this.get_ttf_funit(this.fontBBox1), this.get_ttf_funit(this.fontBBox2), this.get_ttf_funit(this.fontBBox3), this.get_ttf_funit(this.fontBBox4)};
        return fbb;
    }

    public String getItalicAngle() {
        String ia = Short.toString((short)(this.italicAngle / 65536L));
        return ia;
    }

    public HashMap getKerning() {
        return this.kerningTab;
    }

    public short getLastChar() {
        return this.lastChar;
    }

    public int getLowerCaseAscent() {
        return this.get_ttf_funit(this.ascender);
    }

    public int getLowerCaseDescent() {
        return this.get_ttf_funit(this.descender);
    }

    protected void getNumGlyphs(FontFileReader in) throws IOException {
        this.seek_tab(in, "maxp", 4L);
        this.nglyphs = in.readTTFUShort();
    }

    public String getPostscriptName() {
        if ("Regular".equals(this.subFamilyName) || "Roman".equals(this.subFamilyName)) {
            return this.familyName;
        }
        return String.valueOf(this.familyName) + "," + this.subFamilyName;
    }

    public String getStemV() {
        return "0";
    }

    public int[] getWidths() {
        int[] wx = new int[this.mtx_tab.length];
        int i = 0;
        while (i < wx.length) {
            wx[i] = this.get_ttf_funit(this.mtx_tab[i].wx);
            ++i;
        }
        return wx;
    }

    public String getWindowsName() {
        return new String(String.valueOf(this.familyName) + "," + this.subFamilyName);
    }

    public int getXHeight() {
        return this.get_ttf_funit(this.xHeight);
    }

    int get_ttf_funit(int n) {
        int ret;
        if (n < 0) {
            long rest1 = n % this.upem;
            long storrest = 1000L * rest1;
            long ledd2 = rest1 / storrest;
            ret = -(-1000 * n / this.upem - (int)ledd2);
        } else {
            ret = n / this.upem * 1000 + n % this.upem * 1000 / this.upem;
        }
        return ret;
    }

    private void initAnsiWidths() {
        this.ansiWidth = new int[256];
        int i = 0;
        while (i < 256) {
            this.ansiWidth[i] = this.mtx_tab[0].wx;
            ++i;
        }
        this.ansiIndex = new HashMap();
        int i2 = 32;
        while (i2 < Glyphs.winAnsiEncoding.length) {
            Integer ansi = new Integer(i2);
            Integer uni = new Integer(Glyphs.winAnsiEncoding[i2]);
            ArrayList<Integer> v = (ArrayList<Integer>)this.ansiIndex.get(uni);
            if (v == null) {
                v = new ArrayList<Integer>();
                this.ansiIndex.put(uni, v);
            }
            v.add(ansi);
            ++i2;
        }
    }

    public boolean isEmbeddable() {
        return this.is_embeddable;
    }

    public static void main(String[] args) {
        try {
            TTFFile ttfFile = new TTFFile();
            FontFileReader reader = new FontFileReader(args[0]);
            String name = null;
            if (args.length >= 2) {
                name = args[1];
            }
            ttfFile.readFont(reader, name);
            ttfFile.printStuff();
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
        }
    }

    public void printStuff() {
        System.out.println("Font name: " + this.fontName);
        System.out.println("Full name: " + this.fullName);
        System.out.println("Family name: " + this.familyName);
        System.out.println("Subfamily name: " + this.subFamilyName);
        System.out.println("Notice:    " + this.notice);
        System.out.println("xHeight:   " + this.get_ttf_funit(this.xHeight));
        System.out.println("capheight: " + this.get_ttf_funit(this.capHeight));
        int italic = (int)(this.italicAngle >> 16);
        System.out.println("Italic: " + italic);
        System.out.print("ItalicAngle: " + (short)(this.italicAngle / 65536L));
        if (this.italicAngle % 65536L > 0L) {
            System.out.print("." + (short)(this.italicAngle % 65536L * 1000L) / 65536);
        }
        System.out.println();
        System.out.println("Ascender:    " + this.get_ttf_funit(this.ascender));
        System.out.println("Descender:   " + this.get_ttf_funit(this.descender));
        System.out.println("FontBBox:    [" + this.get_ttf_funit(this.fontBBox1) + " " + this.get_ttf_funit(this.fontBBox2) + " " + this.get_ttf_funit(this.fontBBox3) + " " + this.get_ttf_funit(this.fontBBox4) + "]");
    }

    private void print_max_min() {
        int min = 255;
        int max = 0;
        int i = 0;
        while (i < this.mtx_tab.length) {
            if (this.mtx_tab[i].index < min) {
                min = this.mtx_tab[i].index;
            }
            if (this.mtx_tab[i].index > max) {
                max = this.mtx_tab[i].index;
            }
            ++i;
        }
        System.out.println("Min: " + min);
        System.out.println("Max: " + max);
    }

    private boolean readCMAP(FontFileReader in) throws IOException {
        this.unicodeMapping = new ArrayList();
        int mtxPtr = 0;
        this.seek_tab(in, "cmap", 2L);
        int num_cmap = in.readTTFUShort();
        long cmap_unioffset = 0L;
        int i = 0;
        while (i < num_cmap) {
            int cmap_pid = in.readTTFUShort();
            int cmap_eid = in.readTTFUShort();
            long cmap_offset = in.readTTFULong();
            if (cmap_pid == 3 && cmap_eid == 1) {
                cmap_unioffset = cmap_offset;
            }
            ++i;
        }
        if (cmap_unioffset <= 0L) {
            System.out.println("Unicode cmap table not present");
            return false;
        }
        this.seek_tab(in, "cmap", cmap_unioffset);
        int cmap_format = in.readTTFUShort();
        int cmap_length = in.readTTFUShort();
        if (cmap_format == 4) {
            in.skip(2L);
            int cmap_segCountX2 = in.readTTFUShort();
            int cmap_searchRange = in.readTTFUShort();
            int cmap_entrySelector = in.readTTFUShort();
            int cmap_rangeShift = in.readTTFUShort();
            int[] cmap_endCounts = new int[cmap_segCountX2 / 2];
            int[] cmap_startCounts = new int[cmap_segCountX2 / 2];
            int[] cmap_deltas = new int[cmap_segCountX2 / 2];
            int[] cmap_rangeOffsets = new int[cmap_segCountX2 / 2];
            int i2 = 0;
            while (i2 < cmap_segCountX2 / 2) {
                cmap_endCounts[i2] = in.readTTFUShort();
                ++i2;
            }
            in.skip(2L);
            int i3 = 0;
            while (i3 < cmap_segCountX2 / 2) {
                cmap_startCounts[i3] = in.readTTFUShort();
                ++i3;
            }
            int i4 = 0;
            while (i4 < cmap_segCountX2 / 2) {
                cmap_deltas[i4] = in.readTTFShort();
                ++i4;
            }
            int i5 = 0;
            while (i5 < cmap_segCountX2 / 2) {
                cmap_rangeOffsets[i5] = in.readTTFUShort();
                ++i5;
            }
            int glyphIdArrayOffset = in.getCurrentPos();
            int i6 = 0;
            while (i6 < cmap_startCounts.length) {
                int j = cmap_startCounts[i6];
                while (j <= cmap_endCounts[i6]) {
                    if (j < 256 && j > this.lastChar) {
                        this.lastChar = (short)j;
                    }
                    if (mtxPtr < this.mtx_tab.length) {
                        int glyphIdx;
                        if (cmap_rangeOffsets[i6] != 0 && j != 65535) {
                            int glyphOffset = glyphIdArrayOffset + (cmap_rangeOffsets[i6] / 2 + (j - cmap_startCounts[i6]) + i6 - cmap_segCountX2 / 2) * 2;
                            in.seek_set(glyphOffset);
                            glyphIdx = in.readTTFUShort() + cmap_deltas[i6] & 0xFFFF;
                            this.unicodeMapping.add(new UnicodeMapping(glyphIdx, j));
                            this.mtx_tab[glyphIdx].unicodeIndex.add(new Integer(j));
                            ArrayList v = (ArrayList)this.ansiIndex.get(new Integer(j));
                            if (v != null) {
                                int k = 0;
                                while (k < v.size()) {
                                    Integer aIdx = (Integer)v.get(k);
                                    this.ansiWidth[aIdx.intValue()] = this.mtx_tab[glyphIdx].wx;
                                    ++k;
                                }
                            }
                        } else {
                            glyphIdx = j + cmap_deltas[i6] & 0xFFFF;
                            if (glyphIdx < this.mtx_tab.length) {
                                this.mtx_tab[glyphIdx].unicodeIndex.add(new Integer(j));
                            } else {
                                System.out.println("Glyph " + glyphIdx + " out of range: " + this.mtx_tab.length);
                            }
                            this.unicodeMapping.add(new UnicodeMapping(glyphIdx, j));
                            if (glyphIdx < this.mtx_tab.length) {
                                this.mtx_tab[glyphIdx].unicodeIndex.add(new Integer(j));
                            } else {
                                System.out.println("Glyph " + glyphIdx + " out of range: " + this.mtx_tab.length);
                            }
                            ArrayList v = (ArrayList)this.ansiIndex.get(new Integer(j));
                            if (v != null) {
                                int k = 0;
                                while (k < v.size()) {
                                    Integer aIdx = (Integer)v.get(k);
                                    this.ansiWidth[aIdx.intValue()] = this.mtx_tab[glyphIdx].wx;
                                    ++k;
                                }
                            }
                        }
                        if (glyphIdx < this.mtx_tab.length && this.mtx_tab[glyphIdx].unicodeIndex.size() < 2) {
                            ++mtxPtr;
                        }
                    }
                    ++j;
                }
                ++i6;
            }
        }
        return true;
    }

    protected void readDirTabs(FontFileReader in) throws IOException {
        in.skip(4L);
        int ntabs = in.readTTFUShort();
        in.skip(6L);
        this.dirTabs = new HashMap();
        TTFDirTabEntry[] pd = new TTFDirTabEntry[ntabs];
        int i = 0;
        while (i < ntabs) {
            pd[i] = new TTFDirTabEntry();
            this.dirTabs.put(pd[i].read(in), pd[i]);
            ++i;
        }
    }

    public void readFont(FontFileReader in) throws IOException {
        this.readFont(in, null);
    }

    public void readFont(FontFileReader in, String name) throws IOException {
        if (!this.checkTTC(in, name, true)) {
            throw new IOException("Failed to read font");
        }
        this.readDirTabs(in);
        this.readFontHeader(in);
        this.getNumGlyphs(in);
        System.out.println("Number of glyphs in font: " + this.nglyphs);
        this.readHorizontalHeader(in);
        this.readHorizontalMetrics(in);
        this.initAnsiWidths();
        this.readPostscript(in);
        this.readOS2(in);
        this.readIndexToLocation(in);
        this.readGlyf(in);
        this.readName(in);
        this.readPCLT(in);
        this.readCMAP(in);
        this.createCMaps();
        this.readKerning(in);
    }

    protected void readFontHeader(FontFileReader in) throws IOException {
        this.seek_tab(in, "head", 18L);
        this.upem = in.readTTFUShort();
        in.skip(16L);
        this.fontBBox1 = in.readTTFShort();
        this.fontBBox2 = in.readTTFShort();
        this.fontBBox3 = in.readTTFShort();
        this.fontBBox4 = in.readTTFShort();
        in.skip(6L);
        this.loca_format = in.readTTFShort();
    }

    private final void readGlyf(FontFileReader in) throws IOException {
        TTFDirTabEntry dirTab = (TTFDirTabEntry)this.dirTabs.get("glyf");
        int i = 0;
        while (i < this.nglyphs - 1) {
            if (this.mtx_tab[i].offset != this.mtx_tab[i + 1].offset) {
                in.seek_set(dirTab.offset + this.mtx_tab[i].offset);
                in.skip(2L);
                this.mtx_tab[i].bbox[0] = in.readTTFShort();
                this.mtx_tab[i].bbox[1] = in.readTTFShort();
                this.mtx_tab[i].bbox[2] = in.readTTFShort();
                this.mtx_tab[i].bbox[3] = in.readTTFShort();
            } else {
                this.mtx_tab[i].bbox[0] = this.mtx_tab[0].bbox[0];
                this.mtx_tab[i].bbox[1] = this.mtx_tab[0].bbox[1];
                this.mtx_tab[i].bbox[2] = this.mtx_tab[0].bbox[2];
                this.mtx_tab[i].bbox[3] = this.mtx_tab[0].bbox[3];
            }
            ++i;
        }
        long n = ((TTFDirTabEntry)this.dirTabs.get((Object)"glyf")).offset;
        int i2 = 0;
        while (i2 < this.nglyphs) {
            if (i2 + 1 >= this.mtx_tab.length || this.mtx_tab[i2].offset != this.mtx_tab[i2 + 1].offset) {
                in.seek_set(n + this.mtx_tab[i2].offset);
                in.skip(2L);
                this.mtx_tab[i2].bbox[0] = in.readTTFShort();
                this.mtx_tab[i2].bbox[1] = in.readTTFShort();
                this.mtx_tab[i2].bbox[2] = in.readTTFShort();
                this.mtx_tab[i2].bbox[3] = in.readTTFShort();
            } else {
                this.mtx_tab[i2].bbox[0] = this.mtx_tab[0].bbox[0];
                this.mtx_tab[i2].bbox[1] = this.mtx_tab[0].bbox[0];
                this.mtx_tab[i2].bbox[2] = this.mtx_tab[0].bbox[0];
                this.mtx_tab[i2].bbox[3] = this.mtx_tab[0].bbox[0];
            }
            ++i2;
        }
    }

    protected void readHorizontalHeader(FontFileReader in) throws IOException {
        this.seek_tab(in, "hhea", 4L);
        this.ascender = in.readTTFShort();
        this.descender = in.readTTFShort();
        in.skip(26L);
        this.nhmtx = in.readTTFUShort();
        if (this.ascender == 0 || this.descender == 0) {
            this.seek_tab(in, "OS/2", 68L);
            if (this.currentDirTab.length >= 78L) {
                this.ascender = in.readTTFShort();
                this.descender = in.readTTFShort();
            }
        }
    }

    protected void readHorizontalMetrics(FontFileReader in) throws IOException {
        this.seek_tab(in, "hmtx", 0L);
        int mtx_size = this.nglyphs > this.nhmtx ? this.nglyphs : this.nhmtx;
        this.mtx_tab = new TTFMtxEntry[mtx_size];
        int i = 0;
        while (i < mtx_size) {
            this.mtx_tab[i] = new TTFMtxEntry();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.nhmtx) {
            this.mtx_tab[i2].wx = in.readTTFUShort();
            this.mtx_tab[i2].lsb = in.readTTFShort();
            ++i2;
        }
        if (this.nhmtx < mtx_size) {
            int lastWidth = this.mtx_tab[this.nhmtx - 1].wx;
            int i3 = this.nhmtx;
            while (i3 < mtx_size) {
                this.mtx_tab[i3].wx = lastWidth;
                this.mtx_tab[i3].lsb = in.readTTFShort();
                ++i3;
            }
        }
    }

    protected final void readIndexToLocation(FontFileReader in) throws IOException {
        this.seek_tab(in, "loca", 0L);
        int i = 0;
        while (i < this.nglyphs) {
            this.mtx_tab[i].offset = this.loca_format == 1 ? in.readTTFULong() : (long)(in.readTTFUShort() << 1);
            ++i;
        }
        this.lastLoca = this.loca_format == 1 ? in.readTTFULong() : (long)(in.readTTFUShort() << 1);
    }

    private final void readKerning(FontFileReader in) throws IOException {
        this.kerningTab = new HashMap();
        this.ansiKerningTab = new HashMap();
        TTFDirTabEntry dirTab = (TTFDirTabEntry)this.dirTabs.get("kern");
        if (dirTab != null) {
            this.seek_tab(in, "kern", 2L);
            int n = in.readTTFUShort();
            while (n > 0) {
                in.skip(4L);
                int k = in.readTTFUShort();
                if ((k & 1) == 0 || (k & 2) != 0 || (k & 4) != 0) {
                    return;
                }
                if (k >> 8 == 0) {
                    k = in.readTTFUShort();
                    in.skip(6L);
                    while (k-- > 0) {
                        int i = in.readTTFUShort();
                        int j = in.readTTFUShort();
                        short kpx = in.readTTFShort();
                        if (kpx == 0) continue;
                        Integer iObj = new Integer(i);
                        HashMap<Integer, Integer> adjTab = (HashMap<Integer, Integer>)this.kerningTab.get(iObj);
                        if (adjTab == null) {
                            adjTab = new HashMap<Integer, Integer>();
                        }
                        adjTab.put(new Integer(j), new Integer(this.get_ttf_funit(kpx)));
                        this.kerningTab.put(iObj, adjTab);
                    }
                }
                --n;
            }
            Iterator ae = this.kerningTab.keySet().iterator();
            while (ae.hasNext()) {
                Integer cidKey = (Integer)ae.next();
                HashMap<Integer, Integer> akpx = new HashMap<Integer, Integer>();
                HashMap ckpx = (HashMap)this.kerningTab.get(cidKey);
                Iterator aee = ckpx.keySet().iterator();
                while (aee.hasNext()) {
                    Integer cidKey2 = (Integer)aee.next();
                    Integer kern = (Integer)ckpx.get(cidKey2);
                    ArrayList unicodeIndex = this.mtx_tab[cidKey2.intValue()].unicodeIndex;
                    int i = 0;
                    while (i < unicodeIndex.size()) {
                        Integer unicodeKey = (Integer)unicodeIndex.get(i);
                        Integer[] ansiKeys = this.unicodeToWinAnsi(unicodeKey);
                        int u = 0;
                        while (u < ansiKeys.length) {
                            akpx.put(ansiKeys[u], kern);
                            ++u;
                        }
                        ++i;
                    }
                }
                if (akpx.size() <= 0) continue;
                ArrayList unicodeIndex = this.mtx_tab[cidKey.intValue()].unicodeIndex;
                int i = 0;
                while (i < unicodeIndex.size()) {
                    Integer unicodeKey = (Integer)unicodeIndex.get(i);
                    Integer[] ansiKeys = this.unicodeToWinAnsi(unicodeKey);
                    int u = 0;
                    while (u < ansiKeys.length) {
                        this.ansiKerningTab.put(ansiKeys[u], akpx);
                        ++u;
                    }
                    ++i;
                }
            }
        }
    }

    private final void readName(FontFileReader in) throws IOException {
        this.seek_tab(in, "name", 2L);
        int i = in.getCurrentPos();
        int n = in.readTTFUShort();
        int j = in.readTTFUShort() + i - 2;
        i += 4;
        while (n-- > 0) {
            in.seek_set(i);
            int platform_id = in.readTTFUShort();
            int encoding_id = in.readTTFUShort();
            int language_id = in.readTTFUShort();
            int k = in.readTTFUShort();
            int l = in.readTTFUShort();
            if (!(platform_id != 1 && platform_id != 3 || encoding_id != 0 && encoding_id != 1 || k != 1 && k != 2 && k != 0 && k != 4 && k != 6)) {
                in.seek_set(j + in.readTTFUShort());
                String txt = in.readTTFString(l);
                switch (k) {
                    case 0: {
                        this.notice = txt;
                        break;
                    }
                    case 1: {
                        this.familyName = txt;
                        break;
                    }
                    case 2: {
                        this.subFamilyName = txt;
                        break;
                    }
                    case 4: {
                        this.fullName = txt;
                        break;
                    }
                    case 6: {
                        this.fontName = txt;
                        break;
                    }
                }
                if (!this.notice.equals("") && !this.fullName.equals("") && !this.fontName.equals("") && !this.familyName.equals("") && !this.subFamilyName.equals("")) break;
            }
            i += 12;
        }
    }

    private final void readOS2(FontFileReader in) throws IOException {
        if (this.dirTabs.get("OS/2") != null) {
            this.seek_tab(in, "OS/2", 8L);
            int fsType = in.readTTFUShort();
            this.is_embeddable = fsType != 2;
        } else {
            this.is_embeddable = true;
        }
    }

    private final void readPCLT(FontFileReader in) throws IOException {
        TTFDirTabEntry dirTab = (TTFDirTabEntry)this.dirTabs.get("PCLT");
        if (dirTab != null) {
            in.seek_set(dirTab.offset + 4L + 4L + 2L);
            this.xHeight = in.readTTFUShort();
            in.skip(4L);
            this.capHeight = in.readTTFUShort();
            in.skip(34L);
            int serifStyle = in.readTTFUByte();
            serifStyle >>= 6;
            this.hasSerifs = (serifStyle &= 3) != 1;
        } else {
            int i = 0;
            while (i < this.mtx_tab.length) {
                if ("H".equals(this.mtx_tab[i].name)) {
                    this.capHeight = this.mtx_tab[i].bbox[3] - this.mtx_tab[i].bbox[1];
                }
                ++i;
            }
        }
    }

    private final void readPostscript(FontFileReader in) throws IOException {
        this.seek_tab(in, "post", 0L);
        this.post_format = in.readTTFLong();
        this.italicAngle = in.readTTFULong();
        this.underlinePosition = in.readTTFShort();
        this.underlineThickness = in.readTTFShort();
        this.isFixedPitch = in.readTTFULong();
        in.skip(16L);
        switch (this.post_format) {
            case 65536: {
                int i = 0;
                while (i < Glyphs.mac_glyph_names.length) {
                    this.mtx_tab[i].name = Glyphs.mac_glyph_names[i];
                    ++i;
                }
                break;
            }
            case 131072: {
                int numGlyphStrings = 0;
                int l = in.readTTFUShort();
                int i = 0;
                while (i < l) {
                    this.mtx_tab[i].index = in.readTTFUShort();
                    if (this.mtx_tab[i].index > 257) {
                        ++numGlyphStrings;
                    }
                    ++i;
                }
                String[] ps_glyphs_buf = new String[numGlyphStrings];
                i = 0;
                while (i < ps_glyphs_buf.length) {
                    ps_glyphs_buf[i] = in.readTTFString(in.readTTFUByte());
                    ++i;
                }
                i = 0;
                while (i < l) {
                    if (this.mtx_tab[i].index < 258) {
                        this.mtx_tab[i].name = Glyphs.mac_glyph_names[this.mtx_tab[i].index];
                    } else if (!this.mtx_tab[i].isIndexReserved()) {
                        int k = this.mtx_tab[i].index - 258;
                        this.mtx_tab[i].name = ps_glyphs_buf[k];
                    }
                    ++i;
                }
                break;
            }
            case 196608: {
                System.out.println("Postscript format 3");
                break;
            }
            default: {
                System.out.println("Unknown Postscript format : " + this.post_format);
            }
        }
    }

    void seek_tab(FontFileReader in, String name, long offset) throws IOException {
        TTFDirTabEntry dt = (TTFDirTabEntry)this.dirTabs.get(name);
        if (dt == null) {
            System.out.println("Dirtab " + name + " not found.");
        } else {
            in.seek_set(dt.offset + offset);
            this.currentDirTab = dt;
        }
    }

    private Integer[] unicodeToWinAnsi(int unicode) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int i = 32;
        while (i < Glyphs.winAnsiEncoding.length) {
            if (unicode == Glyphs.winAnsiEncoding[i]) {
                ret.add(new Integer(i));
            }
            ++i;
        }
        Integer[] itg = new Integer[ret.size()];
        ret.toArray(itg);
        return itg;
    }
}

