/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import com.sun.media.jai.codec.FileCacheSeekableStream;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDirectory;
import com.sun.media.jai.codec.TIFFField;
import java.io.InputStream;
import java.net.URL;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.JAIImage;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.CCFFilter;
import org.apache.fop.pdf.DCTFilter;

public class TiffImage
extends JAIImage {
    public TiffImage(URL href) throws FopImageException {
        super(href);
    }

    public TiffImage(URL href, ImageReader imgReader) throws FopImageException {
        super(href, imgReader);
    }

    protected void loadImage() throws FopImageException {
        try {
            InputStream inputStream = this.m_href.openStream();
            FileCacheSeekableStream seekableInput = new FileCacheSeekableStream(inputStream);
            TIFFDirectory ifd = new TIFFDirectory((SeekableStream)seekableInput, 0);
            TIFFField fld = null;
            this.m_height = (int)ifd.getFieldAsLong(257);
            this.m_width = (int)ifd.getFieldAsLong(256);
            fld = ifd.getField(277);
            if (fld != null && fld.getAsInt(0) != 1) {
                throw new FopImageException("Error while loading image " + this.m_href.toString() + " : " + this.getClass() + " - " + "unsupported samples per pixel value " + fld.getAsInt(0));
            }
            this.m_bitsPerPixel = 1;
            fld = ifd.getField(258);
            if (fld != null) {
                this.m_bitsPerPixel = fld.getAsInt(0);
            }
            this.m_colorSpace = new ColorSpace(ColorSpace.DEVICE_GRAY);
            fld = ifd.getField(262);
            if (fld != null && fld.getAsInt(0) != 0) {
                if (fld.getAsInt(0) == 2) {
                    this.m_colorSpace = new ColorSpace(ColorSpace.DEVICE_RGB);
                } else {
                    throw new FopImageException("Error while loading image " + this.m_href.toString() + " : " + this.getClass() + " - " + "unsupported photometric interpretation value " + fld.getAsInt(0));
                }
            }
            this.m_isTransparent = false;
            int comp = 1;
            fld = ifd.getField(259);
            if (fld != null) {
                comp = fld.getAsInt(0);
            }
            if (comp != 1) {
                if (comp == 3) {
                    this.m_compressionType = new CCFFilter();
                    this.m_compressionType.setApplied(true);
                } else if (comp == 4) {
                    CCFFilter ccf = new CCFFilter();
                    this.m_compressionType = ccf;
                    this.m_compressionType.setApplied(true);
                    ccf.setDecodeParms("<< /K -1 /Columns " + this.m_width + " >>");
                } else if (comp == 6) {
                    this.m_compressionType = new DCTFilter();
                    this.m_compressionType.setApplied(true);
                } else {
                    throw new FopImageException("Error while loading image " + this.m_href.toString() + " : " + this.getClass() + " - " + "unsupported compression value " + comp);
                }
            }
            if ((fld = ifd.getField(278)) != null && (long)this.m_height != fld.getAsLong(0)) {
                throw new FopImageException("Error while loading image " + this.m_href.toString() + " : " + this.getClass() + " - " + "only single strip images supported ");
            }
            long offset = ifd.getFieldAsLong(273);
            long length = ifd.getFieldAsLong(279);
            byte[] readBuf = new byte[(int)length];
            inputStream.close();
            inputStream = this.m_href.openStream();
            inputStream.skip(offset);
            int bytes_read = inputStream.read(readBuf);
            if ((long)bytes_read != length) {
                throw new FopImageException("Error while loading image " + this.m_href.toString() + " : " + this.getClass() + " - " + "length mismatch on read");
            }
            this.m_bitmaps = readBuf;
        }
        catch (FopImageException fie) {
            MessageHandler.logln("Reverting to TIFF image handling through JAI: " + fie.getMessage());
            this.m_compressionType = null;
            super.loadImage();
        }
        catch (Exception ex) {
            throw new FopImageException("Error while loading image " + this.m_href.toString() + " : " + ex.getClass() + " - " + ex.getMessage());
        }
    }
}

