/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.layout.FontDescriptor;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontMetric;
import org.apache.fop.render.awt.FontMetricsMapper;
import org.apache.fop.render.pdf.CodePointMapping;
import org.apache.fop.render.pdf.Font;

public class FontState {
    private FontInfo _fontInfo;
    private String _fontName;
    private int _fontSize;
    private String _fontFamily;
    private String _fontStyle;
    private String _fontWeight;
    private int _fontVariant;
    private FontMetric _metric;
    private int _letterSpacing;
    private static Map EMPTY_MAP = new HashMap();

    public FontState(FontInfo fontInfo, String fontFamily, String fontStyle, String fontWeight, int fontSize, int fontVariant) throws FOPException {
        this._fontInfo = fontInfo;
        this._fontFamily = fontFamily;
        this._fontStyle = fontStyle;
        this._fontWeight = fontWeight;
        this._fontSize = fontSize;
        String _fontKey = FontInfo.createFontKey(this._fontFamily, this._fontStyle, this._fontWeight);
        if (!fontInfo.hasFont(_fontKey)) {
            StringTokenizer st = new StringTokenizer(this._fontFamily, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.charAt(0) == '\"' || token.charAt(0) == '\'') {
                    token = token.substring(1, token.length() - 1);
                } else {
                    StringBuffer sb = new StringBuffer();
                    boolean spaced = false;
                    int i = 0;
                    while (i < token.length()) {
                        char c = token.charAt(i);
                        if (!FontState.isWhitespace(c)) {
                            sb.append(c);
                            spaced = false;
                        } else if (!spaced) {
                            sb.append(c);
                            spaced = true;
                        }
                        ++i;
                    }
                    token = sb.toString();
                }
                _fontKey = FontInfo.createFontKey(token, this._fontStyle, this._fontWeight);
                if (!fontInfo.hasFont(_fontKey)) continue;
                this._fontFamily = token;
                break;
            }
        }
        this._fontName = fontInfo.fontLookup(_fontKey);
        this._metric = fontInfo.getMetricsFor(this._fontName);
        this._fontVariant = fontVariant;
        this._letterSpacing = 0;
    }

    public FontState(FontInfo fontInfo, String fontFamily, String fontStyle, String fontWeight, int fontSize, int fontVariant, int letterSpacing) throws FOPException {
        this(fontInfo, fontFamily, fontStyle, fontWeight, fontSize, fontVariant);
        this._letterSpacing = letterSpacing;
    }

    public int getAscender() {
        return this._metric.getAscender(this._fontSize) / 1000;
    }

    public int getCapHeight() {
        return this._metric.getCapHeight(this._fontSize) / 1000;
    }

    public int getDescender() {
        return this._metric.getDescender(this._fontSize) / 1000;
    }

    public String getFontFamily() {
        return this._fontFamily;
    }

    public FontInfo getFontInfo() {
        return this._fontInfo;
    }

    public String getFontName() {
        return this._fontName;
    }

    public int getFontSize() {
        return this._fontSize;
    }

    public String getFontStyle() {
        return this._fontStyle;
    }

    public int getFontVariant() {
        return this._fontVariant;
    }

    public String getFontWeight() {
        return this._fontWeight;
    }

    public Map getKerning() {
        Map ret;
        if (this._metric instanceof FontDescriptor && (ret = ((FontDescriptor)((Object)this._metric)).getKerningInfo()) != null) {
            return ret;
        }
        return EMPTY_MAP;
    }

    public int getLetterSpacing() {
        return this._letterSpacing;
    }

    public int getXHeight() {
        return this._metric.getXHeight(this._fontSize) / 1000;
    }

    private static boolean isWhitespace(char ch) {
        return ch <= ' ' && (4294981120L >> ch & 1L) != 0L;
    }

    public char mapChar(char c) {
        if (this._metric instanceof Font) {
            return ((Font)this._metric).mapChar(c);
        }
        if (this._metric instanceof FontMetricsMapper) {
            return c;
        }
        char d = CodePointMapping.getMapping("WinAnsiEncoding").mapChar(c);
        c = d != '\u0000' ? d : (char)35;
        return c;
    }

    public int width(int charnum) {
        return this._letterSpacing + this._metric.width(charnum, this._fontSize) / 1000;
    }
}

